"""An example showing how to visualize the atoms in a Dacapo calculation"""

from Dacapo import Dacapo
from ASE.Visualization.VTK import VTKPlotWaveFunction, VTKPlotAtoms

# First read the atoms from the netcdf output file
atoms = Dacapo.ReadAtoms('AlH_ontop.nc')

# The vtkavatar for the atoms is generated and a window will pop up showing
# the atoms, unitcell, forces, and velocities (if any). Use the mouse to
# rotate (left), pan (middle), and zoom (right)
p1 = VTKPlotAtoms(atoms)

# In order to get a better overview the repeated atoms can also be visualized:
p1.SetPeriods((3, 3, 1))
# Use the Render method to update the VTK pipeline
p1.Render()

# The appearence of the individual atomic elements can also be changed.
# Finding aluminium atom avatar (found in the dictionary of species avatars)
p1_Al=p1.GetDictOfSpecies()['Al']
p1_H=p1.GetDictOfSpecies()['H']
# Change the radius to 2.0 AA and set the color to blue
p1_Al.SetRadius(2.0)
p1_H.SetRadius(1.0)
#The color is given in an rgb (red,green,blue) scale
p1_Al.SetColor((1,0,0))
p1_H.SetColor((1,1,1))
p1.Render()

# The forces are not visible but they can be scaled:
#forceplot=p1.GetForces()
#forceplot.SetScale(500)
#p1.Render()
# and the forces can be removed:
#p1.RemoveAvatar(forceplot)
#p1.Render()

#The unitcell can be removed
p1.RemoveAvatar(p1.unitcell)
p1.Render()


#The plot can be saved, the number is the factor, with which the picture is enlarged
p1.SaveAsBMP("atomplot.bmp",2)
