"""Bulk Al(fcc) test"""

from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms
from ASE.Visualization.RasMol import RasMol


bulk = ListOfAtoms([Atom('Al', (0, 0, 0))] )
a = 4.05
b = a / 2
bulk.SetUnitCell([(0, b, b), 
                  (b, 0, b), 
                  (b, b, 0)])

calc = Dacapo(kpts=(4,4,4),               # set the k-points (Monkhorst-Pack)
              planewavecutoff=300,        # planewavecutoff in eV
              nbands=6,                   # set the number of electronic bands
              usesymm=True,               # use symmetry to reduce the k-points
              out='Al-fcc-single.nc',     # define the out netcdf file
              txtout='Al-fcc-single.txt') # define the ascii out file

bulk.SetCalculator(calc)
calc.SetDensityCutoff(400)

energy = bulk.GetPotentialEnergy()

print energy
bulk_plot = RasMol(bulk, repeat=(5,5,5))
