!
!     @(#)van_us_def.h	1.9 6/10/99
!     constants used for Vanderbilt us potentials
      integer lmaxx 
      integer  nhm,nkb

      parameter(lmaxx=2) 
      integer nbrx,lqx,nlx,mx,nanx,nqfm
      parameter(nbrx = 6, &
                lqx = (2*lmaxx+1),&
                nlx = (lmaxx+1)**2,&
                mx=2*lqx-1,nqfm=10)
!
!     maximum number of different projectors for one atom
!     (this is now defined to be 18:2d 2p 2s) 
      integer nkbpmaxatom
      parameter(nkbpmaxatom=18)

!     maximum number of projectors
      integer   nkbmax

!     dimension for defining qrad 
      integer nbrx2dim
      parameter(nbrx2dim=nbrx*(nbrx/2+1))

!     constant to scale g and gg
      real*8  tpiba,tpiba2       
      parameter(tpiba = 1.0d0, tpiba2 = 1.0d0)
      real *8 pi,fpi,tpi
      parameter(pi=3.14159265358979d0,tpi=2.0*pi,fpi=4.0*pi)

      real*8    hsqdtm,eV,angst
! hsqdtm = (planck's constant/(2*pi))**2/(2*electron mass)
      data hsqdtm /3.810033d0/
      parameter(eV=27.2113961d0,angst=0.529177249d0)

      real *8   rydberg,bohr,rydb3_eva3 ,rydb2_eva2,rydb1_eva1
      parameter(rydberg=eV/2.0d0,bohr=0.529177249d0)
      parameter(rydb3_eva3 = rydberg*bohr**3,&
                rydb2_eva2=rydberg*bohr**2,&
                rydb1_eva1=rydberg*bohr )


!     electron charge divided by epslon0(permittivity of vacuum)
      real*8 edeps 
      data edeps /180.951360318d0/           

!     parameter(rydberg=13.6058d0,bohr=0.5291772d0)
!     data eV,angst/27.2116d0,0.529177d0/

