#include "definitions.h"
      subroutine us_newd_id(nconso)
      write(nconso,*) '@(#)us_newd.F	1.9 11/9/98'
      return
      end
!----------------------------------------------------------------------
      subroutine newd(nions,nspec,nionsp,nplwv,nrplwv,nrplwv_global,&
                  nbands,nkprun,ngx,ngy,ngz,&
                  posion,dirc,volc,cveff,nspin,idebug,nconso&
#ifdef PARAL
                  ,&
#include PARAL_ARGS
#endif
                 ,timer)
!-----------------------------------------------------------------------
! 
!     The Dnm matrix in Vanderbilt US potentials in calculated 
!
!                   0
!          Dnm(ispin) = Dnm  + sum_G(Veff(G,ispin) Qnm(G) exp(-iG.R))
!
!          ispin : 1,nspin 
!
!-----------------------------------------------------------------------
      use van_us_data_module
#ifdef PARAL 
      use par_functions_module
#endif PARAL
      implicit none

      integer nions,nrplwv,nrplwv_global,nplwv,nbands,nkprun
      integer ngx,ngy,ngz,nspec,nionsp(nspec)
      real*8  posion(3,nions,nspec),dirc(3,3),volc
      integer nspin,idebug,nconso
      complex*16 cveff(nplwv,*)

!     local arrays (automatic) 
      complex*16  auxfft(nplwv)
      integer     recl 
#ifdef VPP500
      parameter   (recl = 2048) 
#else
      parameter   (recl = 1024)
#endif 
      complex*16  qgm(recl,(nhm*(nhm+1))/2)
      complex*16  aux(ngdens_max),qg(recl)
      real*8 ylmk0(recl ,lqx*lqx)
#ifdef PARAL
#include      PARAL_DECL
#endif
      real*8 timer(*)

!     locals
      integer na,nsp,nsp1,iv,jv,ik,i,inr,mu,m,j
      integer imin,imax,ispin,ndeeq
      real*8  arg,xyz(3),DDOT ,ps,rinplw,sum
      real*8  zero
      real*8  g1(ngdens,3),gg1(ngdens)
      parameter(zero=0.0d0) 
#include "etime.h"

      logical*4 lrec,init
      data init/.true./
      save init
      external  DDOT 

      if (idebug.gt.0) then 
        write(nconso,*) 'us_newd ',idebug,ngdens,ngldim,ngl,volc         
      endif
!----------------------------------------------------------------------
      if (init) then
!       setup qrad
        call calcqr(ngdens,ngldim,ngl,nspec,volc,gg(1+goffs),qrad,0,&
                    ivjv2index,maxindex)
        init = .false.
      endif
!----------------------------------------------------------------------

#ifdef QRAD_SWAP
      if (nspec.gt.1) call openqrad(ngl) 
#endif QRAD_SWAP

!----------------------------------------------------------------------
!     zero deeq
      call setv(nhm*nhm*nions*2,zero,deeq(1,1,1,1),1)
!    
      do i = 1,ngdens
        do j = 1,3
          g1(i,j) = g(i+goffs,j)
        enddo
        gg1(i) = gg(i+goffs)
      enddo

!     loop over spins
      do ispin = 1,nspin

!-----------------------------------------------------------------------
!     Get Fourier transform of effective potential cveff* (in aux)
      rinplw=1.0d0/nplwv
      do i=1, nplwv
         auxfft(i) = cveff(i,ispin)*rinplw
      enddo
      call fft3d(auxfft,ngx,ngy,ngz,-1)
      do m = 1,ngdens_max
!       aux(m) = auxfft(ipwpadG(m,0))/volc
        aux(m) = conjg(auxfft(ipwpadG(m,0)))
      enddo
!-----------------------------------------------------------------------
!     calculate Qnm*Veff for each type, D = sum_G exp(-iR.G) Q_nm veff(G)*

      do nsp =1,nspec

#ifdef QRAD_SWAP
          if (nspec.gt.1) &
             call readqrad(ngldim,ngl,nsp,qrad,maxindex)
#endif QRAD_SWAP


          imax = 0
          lrec=.true. 
10        continue
          imin=imax
          imax = imin + recl         
          if (imax.ge.ngdens) then
             imax=ngdens
             lrec=.false.
          endif           
!         calculate ylmk0 for imin,imax
          call ylmr2(lqx**2,imin,imax,ngdens,g1,gg1,recl,&
                    (lqx)**2,ylmk0)

          inr = 1
          do iv = 1, nh(nsp)
            do jv = iv, nh(nsp)
               call qvan2(imin,imax,iv,jv,nsp,recl,qgm(1,inr),&
                   ylmk0,qrad,ngdens_max,&
                   nspec,ngldim,igtongl,nhm,indv,nhtol,nhtom, &
                   ap,lpx,lpl,ivjv2index,nbrx,nlx,mx,nbrx2dim,lqx)
               do i=imin+1,imax
                 qgm(i-imin,inr) = qgm(i-imin,inr) * aux(i+goffs)
               enddo
               inr = inr + 1
            enddo
          enddo
                 
!         setup the structure constant (qg) for each atom
          do na = 1, nions
            if (ityp(na).eq.nsp) then 
                call xyzposna(nions,nspec,nionsp,posion,na,dirc,xyz) 
                do ik=imin+1,imax
                 arg = (g(ik+goffs,1)*xyz(1) + g(ik+goffs,2)*xyz(2) &
                        + g(ik+goffs,3)*xyz(3))
                    qg(ik-imin) = dcmplx(cos(arg),sin(arg))    
                enddo                                    

                call uttime(time)
                timer(TNEWDDT)=timer(TNEWDDT)-time(1)
                inr = 1
                do iv = 1, nh(nsp)
                 do jv = iv, nh(nsp)
!                    dirty (but fast) way to calculate: 
!                     sum_G real(exp(-iR.G) Q_nm v^* )
                     ps = DDOT(2*(imax-imin),qg(1),1,qgm(1,inr),1)
                     deeq(iv,jv,na,ispin) = deeq(iv,jv,na,ispin)+ps
                     deeq(jv,iv,na,ispin) = deeq(iv,jv,na,ispin)
                     inr = inr + 1
                 enddo
                enddo
                call uttime(time)
                timer(TNEWDDT)=timer(TNEWDDT)+time(1)
            endif
          enddo
          if (lrec) goto 10
      enddo

      enddo  ! ispin = 1,nspin

#ifdef PARAL 
!     sum of the Dmatrix on each node 
      ndeeq = nhm*nhm*nions*2
      call par_sum_double('A',deeq,deeq,ndeeq,ndeeq,1,&
#include PARAL_ARGS
           ,   timer)
#endif PARAL


! --------------------------------------------------------------------------- 
      do ispin = 1,nspin

!     add ionic part

      na = 1
      do nsp = 1,nspec
        do mu = 1, nionsp(nsp)
          do iv = 1, nh(nsp)
             do jv = iv, nh(nsp)
               deeq(iv,jv,na,ispin) = deeq(iv,jv,na,ispin)&
                                      +dvan(iv,jv,nsp)
               deeq(jv,iv,na,ispin) = deeq(iv,jv,na,ispin)
             enddo
          enddo
          na = na + 1
        enddo
      enddo

      if (idebug.gt.0) then
!     write out             
      na = 1    
      do nsp =1,nspec
          do mu = 1, nionsp(nsp)
             write(nconso,*) 'Dmatrix atm:',na, ' spin:',ispin,nspin
             DO IV=1,NH(nsp)                                    
               WRITE(nconso,101) mu,iv,&
                    (DEEQ(IV,JV,na,ispin),JV=1,NH(nsp))
             END DO                                                   
             na = na + 1
          enddo          
      enddo    
      do nsp =1,nspec
         write(nconso,*) 'DVAN: type ',nsp
             DO IV=1,NH(nsp)
               WRITE(nconso,102) nsp,iv,&
                    (dvan(IV,JV,nsp),JV=1,NH(nsp))
             END DO
      enddo                         
101   format(1x,'DEEQ ',i1,1x,i1,20(f8.4,1x))
102   format(1x,'DVAN ',i1,1x,i1,20(f8.4,1x))
      endif                                   

      enddo  ! ispin = 1,nspin

#ifdef QRAD_SWAP
      if (nspec.gt.1) close(44)  ! qrad swap-file
#endif QRAD_SWAP

      return
      end
!===========================================================================
!              write inputs to qvan2
!              if ((iv.eq.1).and.(jv.eq.1)) then
!              do i=1,nplwkp
!                write(*,*) 'newd qvan inp ',i,ylmk0(i,1),
!    &                   igtongl(i),qrad(igtongl(i),1,1,1,1)
!              enddo
!              endif
!              if ((iv.eq.1).and.(jv.eq.1)) then
!              do i=1,nplwkp                    
!                write(*,*) 'qgm aux ',i,qgm(i,inr),aux(i)
!              enddo                                 
!              endif
!              if ((iv.eq.1).and.(jv.eq.1))
!            write(*,*) 'us_newd ps ',iv,jv,na,deeq(iv,jv,na),
!    &                   volc,ps,volc*ps
!==========================================================================


!----------------------------------------------------------------------
      subroutine xyzpos(posion,dirc,xyz )
!----------------------------------------------------------------------
!
!     get realspace position 
!
!----------------------------------------------------------------------
      implicit none
      real*8   posion(3),dirc(3,3),xyz(3)  
 
      xyz(1) = posion(1)*dirc(1,1)+posion(2)*dirc(2,1)+&
                  posion(3)*dirc(3,1)
      xyz(2) = posion(1)*dirc(1,2)+                           &
                  posion(2)*dirc(2,2)+posion(3)*dirc(3,2)
      xyz(3) = posion(1)*dirc(1,3)+                           &
                  posion(2)*dirc(2,3)+posion(3)*dirc(3,3)


      return 
      end


!----------------------------------------------------------------------
      subroutine xyzposna(nions,nspec,nionsp,posion,na,dirc,xyz )
!----------------------------------------------------------------------
!
!     get realspace position, given the number of the atom na
!
!----------------------------------------------------------------------
      implicit none
      integer  nions,nspec,nionsp(nspec),na
      real*8   posion(3,nions,nspec),dirc(3,3),xyz(3)

      integer  na1,nsp,mu
      real*8   a,b,c

      na1 = 1
      do nsp = 1,nspec 
        do mu = 1,nionsp(nsp)
           if (na1.eq.na) then 
              a = posion(1,mu,nsp)
              b = posion(2,mu,nsp)
              c = posion(3,mu,nsp)
              xyz(1) = a*dirc(1,1)+b*dirc(2,1)+c*dirc(3,1)
              xyz(2) = a*dirc(1,2)+b*dirc(2,2)+c*dirc(3,2)
              xyz(3) = a*dirc(1,3)+b*dirc(2,3)+c*dirc(3,3)
           endif
           na1 = na1 + 1
        enddo
      enddo
 
      return
      end
 


