#include "definitions.h"

!=======================================================================
      subroutine symaid(nconso)
      write(nconso,*) '@(#)symana.F	1.6 10/12/98'
      return
      end
!=======================================================================
      subroutine symana(pos123,dirc,nspec,nionsp,nions,recc,&
                        nconso,nmsfft,ng1,ng2,ng3,numsym,nmstyp,nsymax,&
                        dirnms,nmsfor,nlatma,numlat,nspama,linvad,&
                        numspa,nmamax,lmastr)

      use stress_module, only : point_group_op
      implicit none
      integer nspec,nions
      real*8 pos123(3,nions,nspec)
      real*8 dirc(3,3)
      integer nionsp(nspec)
      real*8 recc(3,3)
      integer nconso
      integer ng1,ng2,ng3
      integer numsym
      integer nsymax
      integer numlat
      integer nmamax
      logical*4 linvad(nmamax)
      integer numspa
      logical*4 lmastr
      logical*4 iokpoi,iokfft
!=======================================================================
! Arrays to be used in the analysis of the k-points
!=======================================================================
      integer nlatma(3,3,nmamax)
      integer nspama(3,3,nmamax)
!=======================================================================
! Arrays to be used in the selfconsistent runs
!=======================================================================
      real*8 dirnms(3,3,max(nsymax,1))
      integer nmsfor(nions,max(nsymax,1))
      integer nmsfft(ng1*ng2*ng3,max(nsymax,1))
      integer nmstyp(max(nsymax,1))
!=======================================================================
! local work arrays
! (mgenset, mgenset_mtype) are for netCDF putput only; indexed
! over accepted generators
!=======================================================================
      integer    ngemax
      parameter (ngemax=5)
      integer ngenma(3,3,ngemax)
      integer ngenty(ngemax)
      real*8 pointg(3,3)
      integer k,nsyn,ngener,npogr,ngeacc,i,j,nneed,nsym
      real*8  dtmp
      integer mgenset(3,3,ngemax)
      integer mgenset_mtype(ngemax)
!=======================================================================
! Find the bravais lattice point group
! Output: nlatma(1..numlat) are all matrices (in a1,a2 and a3 coord.)
!=======================================================================
      call symbra(dirc,recc,nlatma,numlat,nconso)
!=======================================================================
! Loop over the symmetry operations of the bravais lattice point group
!=======================================================================
      numspa=0
      do 1000 npogr=1,numlat
!=======================================================================
! generate the npogr'th matrix in cartesian coordinates
!=======================================================================
         call cartes(dirc,recc,nlatma(1,1,npogr),pointg)
!=======================================================================
! Find out if the ionic coordinates obey this symmetry operation
!=======================================================================
         call sympoi(pos123,nions,nspec,nionsp,dirc,recc,&
                     pointg,iokpoi)
!=======================================================================
! Write symmetri-info to console
!=======================================================================
         if (iokpoi) then
 1050       format(1x,'SYM: The space group contains the ',&
                   'point group operation #',i3)
         endif
!=======================================================================
! Check that the point group operation can be exploited
! (requires that axes that interchange have the same number of
!  divisions on the FFT grid)
!=======================================================================
         iokfft=.false.
         if (iokpoi) then
            iokfft=.true.
            if ((nlatma(1,2,npogr).ne.0.or.nlatma(2,1,npogr).ne.0).and.ng1.ne.ng2) then
               iokfft=.false.
            endif
            if ((nlatma(1,3,npogr).ne.0.or.nlatma(3,1,npogr).ne.0).and.ng1.ne.ng3) then
               iokfft=.false.
            endif
            if ((nlatma(3,2,npogr).ne.0.or.nlatma(2,3,npogr).ne.0).and.ng3.ne.ng2) then
               iokfft=.false.
            endif
            if (.not.iokfft) then
               write(nconso,*) 'SYM: Cannot exploit this symmetry due to FFT grid inconsistency'
            endif
         endif
!=======================================================================
! Store the point group operation
!=======================================================================
         if (iokfft) then
            numspa=numspa+1
            call mstore(nspama(1,1,numspa),nlatma(1,1,npogr))
         endif
 1000 continue
!=======================================================================
! print the number of operations in the space group
!=======================================================================
      write(nconso,*)'SYM: There are ',numspa,' point operations in the space group'

!=======================================================================
! Get and save point operations in cartesian coordinates
! Cartesian matrix save in the stress module
!=======================================================================
      if (nsymax<2) then 
         ! do not allow any point group operations
      else 
         if (.not.allocated(point_group_op)) then
            allocate(point_group_op(3,3,numspa))
            ! get point operations in cartesian coordinates
            do i = 1,numspa
              call cartes(dirc,recc,nspama(1,1,i),point_group_op(1,1,i))
            enddo
         endif
      endif


!=======================================================================
! Make the generators for the numspa space group elements
!=======================================================================
      call symgen(nspama,numspa,ngenma,ngenty,ngener,nconso)
!=======================================================================
! Loop over the various point group operations generators
!=======================================================================
      nsym=1
      ngeacc=0
      nneed=0
      do 2000 npogr=1,ngener
         nneed=nneed+ngenty(npogr)-1
!=======================================================================
! accept as many generators as allowed by nsymax
!=======================================================================
         if (nsymax.lt.nsym+ngenty(npogr)-2) then
            write(nconso,3400)npogr
 3400       format(1x,'SYM: The generator #',i3,' could not be used')
         else
            ngeacc=ngeacc+1
            nmstyp(nsym)=ngenty(npogr)
!=======================================================================
! Make fast-access lists for the symmetrization on the FFT-grid.
!=======================================================================
            call symfft(nmsfft(1,nsym),ngenma(1,1,npogr),ng1,ng2,ng3,nmstyp(nsym))
!=======================================================================
! Make directives for symmetrization of the non-local force contrib.
!=======================================================================
! generate the npogr'th matrix in cartesian coordinates
!=======================================================================
            call cartes(dirc,recc,ngenma(1,1,npogr),pointg)
            call symifo(nconso,pos123,nions,nspec,nionsp,dirc,recc,&
                        pointg,nmsfor(1,nsym))
            if (nmstyp(nsym).eq.2) then
               do 2500 j=1,3
                  do 2400 i=1,3
                     dirnms(i,j,nsym)=pointg(i,j)
 2400             continue
 2500          continue
            elseif (nmstyp(nsym).eq.3) then
               do 2800 j=1,3
                  do 2700 i=1,3
                     dtmp=0.0d0
                     do 2600 k=1,3
                        dtmp=dtmp+pointg(i,k)*pointg(k,j)
 2600                continue
                     dirnms(i,j,nsym)=dtmp
                     dirnms(i,j,nsym+1)=pointg(i,j)
 2700             continue
 2800          continue
            else
            endif

!--------------------------------------------------------------
! Accumulate spatial symmetry info compactly for netCDF output
!--------------------------------------------------------------
            mgenset_mtype(ngeacc) = nmstyp(nsym)
            mgenset(:,:,ngeacc)   = ngenma(:,:,npogr)
            

!=======================================================================
! Print out the point group generators in play during the selfconsistent
! calculation
!=======================================================================
            write(nconso,3100)nsym,nmstyp(nsym)
            write(nconso,3200)((dirnms(j,i,nsym),i=1,3),&
                 (ngenma(j,i,npogr),i=1,3),j=1,3)
            write(nconso,*)'SYM: '
            if (nmstyp(nsym).eq.3) then
               write(nconso,3150)nsym+1
               write(nconso,3300)((dirnms(j,i,nsym+1),i=1,3),j=1,3)
               write(nconso,*)'SYM: '
            endif
 3100       format(1x,'SYM: run-time matrix #',i3,' (',i1,'-fold)')
 3150       format(1x,'SYM: run-time matrix #',i3)
 3200       format(1x,'SYM: xyz-matrix ',3f8.4,'   generator ',3i3)
 3300       format(1x,'SYM: xyz-matrix ',3f8.4)
!=======================================================================
! Count the number of elements in nms-arrays
!=======================================================================
            if (nmstyp(nsym).eq.2) then
               nsym=nsym+1
            elseif (nmstyp(nsym).eq.3) then
               nsym=nsym+2
            else
               write(nconso,*)'Unexpected in @(#)symana.F	1.6'
               call clexit(nconso)
            endif
         endif
 2000 continue
!=======================================================================
! Determine the number of nms-operation (where 3-fold rotation count twice)
!=======================================================================
      numsym=nsym-1
!=======================================================================
! Make all matrices in the part of the space group which is generated
! by the accepted generators (this is only needed if nsymax is too low)
!=======================================================================
      if (ngener.gt.ngeacc) then
         write(nconso,3500)nsymax,nneed
 3500    format(1x,'SYM: Increase nsymax from:',i3,' to: ',i3,&
                ' in order to use all symmetries')
!=======================================================================
! Reduce symmetry set (nspama) to be consistent with accepted generators
! special case if only room for one 2-fold generator and the first
! generator is 3-fold
!=======================================================================
         if (ngeacc.eq.1.and.ngenty(1).eq.3) then
            call kpt48g(nspama,ngenma(1,1,2),1,ngenty(2),numspa)
         else
            call kpt48g(nspama,ngenma,ngeacc,ngenty,numspa)
         endif
      endif
!=======================================================================
! Convert the space group matrices to the reciprocal space basis
!=======================================================================
      call symcnv(dirc,recc,nspama,numspa)
!=======================================================================
! Add the inversion if it is not already contained
! (The space group matrices are only intended for the k-point reduction)
!=======================================================================
      call syminv(nspama,linvad,numspa,nmamax,nconso)
!=======================================================================

! --- print out accepted spatial symmetry compactly ---
        
      call dump_symgen(ngeacc, ngemax, mgenset, mgenset_mtype,lmastr)

      return
      end
!=======================================================================
      subroutine symbra(dirc,recc,ndir48,numlat,nconso)
!=======================================================================
! See what point group operations are in the crystal point group
!=======================================================================
! Output:
! ndir48(1..numlat) Contains the point operations in the lattice point
!                                                                  group
!======================================================================= 
      implicit none
!=======================================================================
      real*8 dirc(3,3),recc(3,3)
      integer nmamax 
      parameter(nmamax=48)
      integer ndir48(3,3,nmamax)
      integer numlat,nconso 

!     locals
      real*8 dirnm(3,3)
      real*8 tmp(3,3)
      integer nrot(3,3)
      logical*4 iok
      integer ii1,jj1,kk1,ii2,jj2,ii3,jj3,kk2,kk3,i,j,k,nsym,nm 
      real*8  unit1,unit2,dtmp,acc
      parameter(acc=1d-5)
!=======================================================================
      nsym=1
      nm=1
      do 1310 ii1=-1,1
         nrot(1,1)=ii1
         do 1210 jj1=-1,1
            nrot(2,1)=jj1
            do 1110 kk1=-1,1
               nrot(3,1)=kk1
               do 1320 ii2=-1,1
                  nrot(1,2)=ii2
                  do 1220 jj2=-1,1
                     nrot(2,2)=jj2
                     do 1120 kk2=-1,1
                        nrot(3,2)=kk2
                        do 1330 ii3=-1,1
                           nrot(1,3)=ii3
                           do 1230 jj3=-1,1
                              nrot(2,3)=jj3
                              do 1130 kk3=-1,1
                                 nrot(3,3)=kk3
!=======================================================================
! Now treating each row in the nrot(i,j) rotated dirc as a point.
!=======================================================================
         do 3260 i=1,3
            do 3240 j=1,3
               dtmp=0.0d0
               do 3220 k=1,3
                  dtmp=dtmp+dirc(k,i)*dble(nrot(k,j))
 3220          continue
               dirnm(i,j)=dtmp
 3240       continue
 3260    continue
         iok=.true.
         do 3300 j=1,3
!=======================================================================
! Check if the basis has just been rotated or mirrored
!=======================================================================
            do 3200 i=1,3
               unit1=0.0d0
               unit2=0.0d0
               do 3225 k=1,3
                  unit1=unit1+dirc(i,k)*dirc(j,k)
                  unit2=unit2+dirnm(k,i)*dirnm(k,j)
 3225          continue
               if (abs(unit1-unit2).gt.acc) then
                  iok=.false.
               endif
               tmp(i,j)=unit2
 3200       continue
 3300    continue
!=======================================================================
! store the point operation if in the lattice point group
!=======================================================================
         if (iok.and.nsym.le.nmamax) then
            do 3360 j=1,3
               do 3330 i=1,3
                  ndir48(i,j,nsym)=nrot(i,j)
 3330          continue
 3360       continue
            nsym=nsym+1
         endif
 1130                         continue
 1230                      continue
 1330                   continue
 1120                continue
 1220             continue
 1320          continue
 1110       continue
 1210    continue
 1310 continue
!=======================================================================
! store and print the number of operations in the lattice point group
!=======================================================================
      numlat=nsym-1
      write(nconso,*)'SYM: There are ',numlat,' point operations in the lattice point group'

      return
      end
!=======================================================================
      subroutine sympoi(pos123,nions,nspec,nionsp,dirc,recc,pointg,iok)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      real*8 pos123(3,nions,nspec)
      integer nionsp(nspec)
      real*8 pointg(3,3)
      real*8 dirc(3,3)
      real*8 recc(3,3)
      logical*4 iok
      parameter(tpi=6.2831853072d0,acc=1d-5)
!=======================================================================
      iok=.true.
      nat=1
      do 1100 nsp=1,nspec
         do 1000 ni=1,nionsp(nsp)
            if (iok) then
!=======================================================================
! Calculate xyz-coordinates
!=======================================================================
               posx=pos123(1,ni,nsp)*dirc(1,1)&
                   +pos123(2,ni,nsp)*dirc(2,1)&
                   +pos123(3,ni,nsp)*dirc(3,1)
               posy=pos123(1,ni,nsp)*dirc(1,2)&
                   +pos123(2,ni,nsp)*dirc(2,2)&
                   +pos123(3,ni,nsp)*dirc(3,2)
               posz=pos123(1,ni,nsp)*dirc(1,3)&
                   +pos123(2,ni,nsp)*dirc(2,3)&
                   +pos123(3,ni,nsp)*dirc(3,3)
!=======================================================================
! Apply the point group operation to the point
!=======================================================================
               possyx=pointg(1,1)*posx&
                     +pointg(1,2)*posy&
                     +pointg(1,3)*posz
               possyy=pointg(2,1)*posx&
                     +pointg(2,2)*posy&
                     +pointg(2,3)*posz
               possyz=pointg(3,1)*posx&
                     +pointg(3,2)*posy&
                     +pointg(3,3)*posz
!=======================================================================
! Calculate the coordinates in the dirc basis
!=======================================================================
            possy1=( recc(1,1)*possyx&
                    +recc(1,2)*possyy&
                    +recc(1,3)*possyz)/tpi
            possy2=( recc(2,1)*possyx&
                    +recc(2,2)*possyy&
                    +recc(2,3)*possyz)/tpi
            possy3=( recc(3,1)*possyx&
                    +recc(3,2)*possyy&
                    +recc(3,3)*possyz)/tpi
!=======================================================================
! Check if this only differs from an other point by a bravais translation
!=======================================================================
            iok=.false.
            nsyat=1
            do 2450 nsysp=1,nspec
               do 2400 nsymat=1,nionsp(nsysp)
!=======================================================================
! Only consider this ion, if:
! i)  still haven't found a corresponding ion
! ii) this ion is of the same type
!=======================================================================
                  if (.not.iok.and.nsp.eq.nsysp) then
!=======================================================================
! find the difference between the resulting point and the nsymat'th point
!=======================================================================
                     diff1=possy1-pos123(1,nsymat,nsysp)
                     diff2=possy2-pos123(2,nsymat,nsysp)
                     diff3=possy3-pos123(3,nsymat,nsysp)
                     if ((abs(diff1-int(diff1+acc)).lt.2*acc.or.abs(diff1-int(diff1-acc)).lt.2*acc)&
                    			  		   .and.(abs(diff2-int(diff2+acc)).lt.2*acc&
                                                            .or.abs(diff2-int(diff2-acc)).lt.2*acc)&
                    					   .and.(abs(diff3-int(diff3+acc)).lt.2*acc&
                                                           .or.abs(diff3-int(diff3-acc)).lt.2*acc)) then
                        iok=.true.
                     endif
                  endif
                  nsyat=nsyat+1
 2400          continue
 2450       continue
         endif
         nat=nat+1
 1000    continue
 1100 continue
      return
      end
!=======================================================================
      subroutine symifo(nconso,pos123,nions,nspec,nionsp,dirc,recc,pointg,nmsfor)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      real*8 pos123(3,nions,nspec)
      integer nconso
      integer nionsp(nspec)
      real*8 pointg(3,3)
      real*8 dirc(3,3)
      real*8 recc(3,3)
      integer nmsfor(nions)
      logical*4 iok
      parameter(tpi=6.2831853072d0,acc=1d-5)
!=======================================================================
      iok=.true.
      nat=1
      do 1100 nsp=1,nspec
         do 1000 ni=1,nionsp(nsp)
            if (iok) then
!=======================================================================
! Calculate xyz-coordinates
!=======================================================================
               posx=pos123(1,ni,nsp)*dirc(1,1)&
                   +pos123(2,ni,nsp)*dirc(2,1)&
                   +pos123(3,ni,nsp)*dirc(3,1)
               posy=pos123(1,ni,nsp)*dirc(1,2)&
                   +pos123(2,ni,nsp)*dirc(2,2)&
                   +pos123(3,ni,nsp)*dirc(3,2)
               posz=pos123(1,ni,nsp)*dirc(1,3)&
                   +pos123(2,ni,nsp)*dirc(2,3)&
                   +pos123(3,ni,nsp)*dirc(3,3)
!=======================================================================
! Apply the point group operation to the point
!=======================================================================
               possyx=pointg(1,1)*posx&
                     +pointg(1,2)*posy&
                     +pointg(1,3)*posz
               possyy=pointg(2,1)*posx&
                     +pointg(2,2)*posy&
                     +pointg(2,3)*posz
               possyz=pointg(3,1)*posx&
                     +pointg(3,2)*posy&
                     +pointg(3,3)*posz
!=======================================================================
! Calculate the coordinates in the dirc basis
!=======================================================================
            possy1=( recc(1,1)*possyx&
                    +recc(1,2)*possyy&
                    +recc(1,3)*possyz)/tpi
            possy2=( recc(2,1)*possyx&
                    +recc(2,2)*possyy&
                    +recc(2,3)*possyz)/tpi
            possy3=( recc(3,1)*possyx&
                    +recc(3,2)*possyy&
                    +recc(3,3)*possyz)/tpi
!=======================================================================
! Check if this only differs from an other point by a bravais translation
!=======================================================================
            iok=.false.
            nsyat=1
            do 2450 nsysp=1,nspec
               do 2400 nsymat=1,nionsp(nsysp)
!=======================================================================
! Only consider this ion, if:
! i)  still haven't found a corresponding ion
! ii) this ion is of the same type
!=======================================================================
                  if (.not.iok.and.nsp.eq.nsysp) then
!=======================================================================
! find the difference between the resulting point and the nsymat'th point
!=======================================================================
                     diff1=possy1-pos123(1,nsymat,nsysp)
                     diff2=possy2-pos123(2,nsymat,nsysp)
                     diff3=possy3-pos123(3,nsymat,nsysp)
                     if ((   abs(diff1-int(diff1+acc)).lt.2*acc&
                          .or.abs(diff1-int(diff1-acc)).lt.2*acc)&
                    .and.(   abs(diff2-int(diff2+acc)).lt.2*acc&
                          .or.abs(diff2-int(diff2-acc)).lt.2*acc)&
                    .and.(   abs(diff3-int(diff3+acc)).lt.2*acc&
                          .or.abs(diff3-int(diff3-acc)).lt.2*acc)) then
                        iok=.true.
                        nmsfor(nat)=nsyat
                     endif
                  endif
                  nsyat=nsyat+1
 2400          continue
 2450       continue
         endif
         nat=nat+1
 1000    continue
 1100 continue
      if (.not.iok) then
         write(nconso,*)'Unexpected in symifo in @(#)symana.F	1.6'
         call clexit(nconso)
      endif
      return
      end
!=======================================================================
      subroutine symgen(ndir48,numlat,ngen,ngtyp,ngener,nconso)
      logical*4 iincl
      logical*4 isunit
      logical*4 ifound
      parameter (nmamax=48)
      parameter (ngemax=5)
      integer ndir48(3,3,nmamax)
      integer ndirty(nmamax)
      integer ndirau(3,3,nmamax)
      integer ngen(3,3,ngemax)
      integer ngtyp(ngemax)
      integer nrot(3,3)
      integer n2fold(48)
      integer n3fold(48)
!=======================================================================
! find the types (2-fold, 3-fold etc.)
!=======================================================================
      n2f=0
      n3f=0
      n4f=0
      n6f=0
      do 1000 nsym=1,numlat
         ndirty(nsym)=-1
         do 4650 j=1,3
            do 4640 i=1,3
               nrot(i,j)=ndir48(i,j,nsym)
 4640       continue
 4650    continue
         do 4630 i=2,6
            if (ndirty(nsym).eq.-1) then
               call symmatmul(nrot,ndir48(1,1,nsym),nrot)
               if (isunit(nrot)) then
                  ndirty(nsym)=i
               endif
            endif
 4630    continue
         if (ndirty(nsym).eq.-1) then
            write(nconso,*)'Unexpected in @(#)symana.F	1.6'
            call clexit(nconso)
         endif
         if (ndirty(nsym).eq.2) then
            n2f=n2f+1
            n2fold(n2f)=nsym
         endif
         if (ndirty(nsym).eq.3) then
            n3f=n3f+1
            n3fold(n3f)=nsym
         endif
         if (ndirty(nsym).eq.4) then
            n4f=n4f+1
         endif
         if (ndirty(nsym).eq.6) then
            n6f=n6f+1
         endif
 1000 continue
!=======================================================================
! determine how many 3-fold generators are needed (0 or 1)
!=======================================================================
      ntot=numlat
      n3tot=0
      if (mod(ntot,3).eq.0) then
         ntot=ntot/3
         n3tot=1
      endif
!=======================================================================
! determine how many 2-fold generators are needed
!=======================================================================
      n2tot=-1
      if (ntot.eq.1)  n2tot=0
      if (ntot.eq.2)  n2tot=1
      if (ntot.eq.4)  n2tot=2
      if (ntot.eq.8)  n2tot=3
      if (ntot.eq.16) n2tot=4
      if (n2tot.eq.-1) then
         write(nconso,*)'Unexpected in @(#)symana.F	1.6',ntot
         call clexit(nconso)
      endif
!=======================================================================
      write(nconso,2050)1
      write(nconso,2100)n2f-1
      if (n3f.ne.0) write(nconso,2200)n3f
      if (n4f.ne.0) write(nconso,2300)n4f
      if (n6f.ne.0) write(nconso,2350)n6f
 2050 format(1x,'SYM: The identity:               ',i3)
 2100 format(1x,'SYM: Number of 2-fold operations:',i3)
 2200 format(1x,'SYM: Number of 3-fold operations:',i3)
 2300 format(1x,'SYM: Number of 4-fold operations:',i3)
 2350 format(1x,'SYM: Number of 6-fold operations:',i3)
!=======================================================================
      ifound=.false.
      ngener=n2tot+n3tot
      do 1100 nn1=1,max(1,n3f)
         ng2ini=1
         if (n3tot.eq.1.and.(.not.ifound)) then
            call mstore(ngen(1,1,1),ndir48(1,1,n3fold(nn1)))
            ngtyp(1)=3
            ng2ini=2
            nnn1=n3fold(nn1)
         endif
         do 1200 nn2=1,max(1,n2f)
            if (n2tot.ge.1.and.(.not.ifound)) then
               ng=ng2ini
               call mstore(ngen(1,1,ng),ndir48(1,1,n2fold(nn2)))
               ngtyp(ng)=2
               nnn2=n2fold(nn2)
            endif
            do 1300 nn3=1,max(1,n2f)
               if (n2tot.ge.2.and.(.not.ifound)) then
                  ng=ng2ini+1
                  call mstore(ngen(1,1,ng),ndir48(1,1,n2fold(nn3)))
                  ngtyp(ng)=2
                  nnn3=n2fold(nn3)
               endif
               do 1400 nn4=1,max(1,n2f)
                  if (n2tot.ge.3.and.(.not.ifound)) then
                     ng=ng2ini+2
                     call mstore(ngen(1,1,ng),ndir48(1,1,n2fold(nn4)))
                     ngtyp(ng)=2
                     nnn4=n2fold(nn4)
                  endif
                  do 1500 nn5=1,max(1,n2f)
                    if (n2tot.ge.4.and.(.not.ifound)) then
                       ng=ng2ini+3
                       call mstore(ngen(1,1,ng),ndir48(1,1,n2fold(nn5)))
                       ngtyp(ng)=2
                       nnn5=n2fold(nn5)
                    endif
                    if (.not.ifound) then
!                    write(nconso,1550) nnn1,nnn2,nnn3,nnn4,nnn5
! 1550               format(1x,'trying ',5i3)
!=======================================================================
! create all possible matrices with the current generators
!=======================================================================
                     call kpt48g(ndirau,ngen,ngener,ngtyp,nmatri)
                    endif
!=======================================================================
! check that the generator do indeed generate all lattice point group
! operations
!=======================================================================
                    ifound=.true.
                    do 8630 nsym=1,numlat
                       iincl=.false.
                       do 8625 nm=1,nmatri
                          if ((.not.iincl).and.ifound) then
                             ntst=0
                             do 8620 j=1,3
                                do 8610 i=1,3
                        ntst=ntst+abs(ndirau(i,j,nm)-ndir48(i,j,nsym))
 8610                           continue
 8620                        continue
!=======================================================================
! the nsym'th point group operation was found
!=======================================================================
                             if (ntst.eq.0) iincl=.true.
                          endif
 8625                  continue
                       if (.not.iincl) then
                          ifound=.false.
                       endif
 8630               continue
                    if (ifound) go to 1800
 1500             continue
 1400          continue
 1300       continue
 1200    continue
 1100 continue
!=======================================================================
! go to here if found
!=======================================================================
 1800 continue
      if (.not.ifound) then
         write(nconso,*)'Unexpected in @(#)symana.F	1.6'
         write(nconso,*)'Failed at finding generators'
         ! call clexit(nconso)
      endif
      write(nconso,*)'SYM: Needed are ',ngener,' generators:'
      return
      end
!=======================================================================
      function isunit(ndir)
      integer ndir(3,3)
      logical*4 isunit
!=======================================================================
! find out if this matrix is the unit-matrix
!=======================================================================
      nsum=0
      do 4100 j=1,3
         do 4000 i=1,3
            nd=0
            if (i.eq.j) nd=1
            nsum=nsum+abs(ndir(i,j)-nd)
 4000    continue
 4100 continue
      isunit=.false.
      if (nsum.eq.0) isunit=.true.
      return
      end
!=======================================================================
      function isinve(ndir)
      integer ndir(3,3)
      logical*4 isinve
!=======================================================================
! find out if this matrix is the unit-matrix
!=======================================================================
      nsum=0
      do 4100 j=1,3
         do 4000 i=1,3
            nd=0
            if (i.eq.j) nd=-1
            nsum=nsum+abs(ndir(i,j)-nd)
 4000    continue
 4100 continue
      isinve=.false.
      if (nsum.eq.0) isinve=.true.
      return
      end
!=======================================================================
      subroutine symmatmul(ndir1,ndir2,ndir3)
!=======================================================================
! multiply (integer) matrices
!=======================================================================
      implicit double precision (a,b,d-h,o-z)
      integer ndir1(3,3)
      integer ndir2(3,3)
      integer ndir3(3,3)
      integer ndirt(3,3)
!=======================================================================
      do 5300 j=1,3
         do 5200 i=1,3
            ntmp=0
            do 5100 k=1,3
               ntmp=ntmp+ndir1(i,k)*ndir2(k,j)
 5100       continue
            ndirt(i,j)=ntmp
 5200    continue
 5300 continue
      do 5500 j=1,3
         do 5400 i=1,3
            ndir3(i,j)=ndirt(i,j)
 5400    continue
 5500 continue
      return
      end
!=======================================================================
      subroutine cartes(dirc,recc,ndir48,rrot)
!=======================================================================
! generate the cartesian matrices
!=======================================================================
      implicit double precision (a,b,d-h,o-z)
      real*8 dirnm(3,3)
      real*8 dirc(3,3)
      real*8 recc(3,3)
      real*8 unirot(3,3)
      integer ndir48(3,3)
      real*8 rrot(3,3)
      parameter(tpi=6.2831853072d0)
!=======================================================================
! Setup the unitary matrix
!=======================================================================
      do 9000 j=1,3
         do 9010 i=1,3
            dirnm(i,j)=0.0d0
 9010    continue
         dirnm(j,j)=1.0d0
 9000 continue
!=======================================================================
! Describe the unitary matrix in a1,a2,a3 coordinates
!=======================================================================
      do 9040 j=1,3
         do 9030 i=1,3
            dtmp=0.0d0
            do 9020 k=1,3
               dtmp=dtmp+recc(i,k)*dirnm(k,j)/tpi
 9020       continue
            unirot(i,j)=dtmp
 9030    continue
 9040 continue
!=======================================================================
! Describe the rotation matrix in x,y,z coordinates
!=======================================================================
      do 9260 j=1,3
         do 9240 i=1,3
            dtmp=0.0d0
            do 9220 k=1,3
               dtmp=dtmp+dirc(k,i)*dble(ndir48(k,j))
 9220       continue
            dirnm(i,j)=dtmp
 9240    continue
 9260 continue
!=======================================================================
! Rotate
!=======================================================================
      do 9530 j=1,3
         do 9520 i=1,3
            dtmp=0.0d0
            do 9510 k=1,3
               dtmp=dtmp+dirnm(i,k)*unirot(k,j)
 9510       continue
            rrot(i,j)=dtmp
 9520    continue
 9530 continue
      return
      end
!=======================================================================
      subroutine cartsG(dirc,recc,ndir48,rrot)
!=======================================================================
! generate the cartesian matrices
!=======================================================================
      implicit double precision (a,b,d-h,o-z)
      real*8 dirnm(3,3)
      real*8 dirc(3,3)
      real*8 recc(3,3)
      real*8 unirot(3,3)
      integer ndir48(3,3)
      real*8 rrot(3,3)
      parameter(tpi=6.2831853072d0)
!=======================================================================
! Setup the unit matrix in x,y,z coordinates
!=======================================================================
      do 9000 j=1,3
         do 9010 i=1,3
            dirnm(i,j)=0.0d0
 9010    continue
         dirnm(j,j)=1.0d0
 9000 continue
!=======================================================================
! Find its b1,b2,b3 coordinates
!=======================================================================
      do 9040 j=1,3
         do 9030 i=1,3
            dtmp=0.0d0
            do 9020 k=1,3
               dtmp=dtmp+dirc(i,k)*dirnm(k,j)
 9020       continue
            unirot(i,j)=dtmp
 9030    continue
 9040 continue
!=======================================================================
! Describe the rotation in x,y,z coordinates
!=======================================================================
      do 9260 j=1,3
         do 9240 i=1,3
            dtmp=0.0d0
            do 9220 k=1,3
               dtmp=dtmp+recc(k,i)*dble(ndir48(k,j))/tpi
 9220       continue
            dirnm(i,j)=dtmp
 9240    continue
 9260 continue
!=======================================================================
! Perform the rotation and get the x,y,z coordinates
!=======================================================================
      do 9530 j=1,3
         do 9520 i=1,3
            dtmp=0.0d0
            do 9510 k=1,3
               dtmp=dtmp+dirnm(i,k)*unirot(k,j)
 9510       continue
            rrot(i,j)=dtmp
 9520    continue
 9530 continue
      return
      end
!=======================================================================
      subroutine mstore(ngen,ndir48)
      implicit double precision (a,b,d-h,o-z)
      integer ngen(3,3)
      integer ndir48(3,3)
!=======================================================================
! store
!=======================================================================
      do 4300 j=1,3
         do 4200 i=1,3
            ngen(i,j)=ndir48(i,j)
 4200    continue
 4300 continue
      return
      end
!=======================================================================
      subroutine kpt48g(ndir48,nmatge,ngemax,ngtyp,nmatri)
!=======================================================================
! Create the (max 48) point group symmetry operations from the
! present generators
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
!=======================================================================
      integer ndir48(3,3,*)
      integer nmatge(3,3,ngemax)
      integer ngtyp(ngemax)
!=======================================================================
! Start out with the identity
!=======================================================================
      do 1100 j=1,3
         do 1000 i=1,3
            ndir48(i,j,1)=0
 1000    continue
         ndir48(j,j,1)=1
 1100 continue
!=======================================================================
! Now apply the generators to get all point group operations
!=======================================================================
      nmatri=1
      do 1900 ng=1,ngemax
         do 1800 nm=1,nmatri
!=======================================================================
! for the nm matrix and the ng generator
!=======================================================================
            do 1400 j=1,3
               do 1300 i=1,3
                  ntmp=0
                  do 1200 k=1,3
                     ntmp=ntmp+ndir48(i,k,nm)*nmatge(k,j,ng)
 1200             continue
                  ndir48(i,j,nm+nmatri)=ntmp
 1300          continue
 1400       continue
!=======================================================================
! If 3-fold rotation then apply twice
!=======================================================================
            if (ngtyp(ng).eq.3) then
              do 1700 j=1,3
                do 1600 i=1,3
                  ntmp=0
                  do 1500 k=1,3
                    ntmp=ntmp+ndir48(i,k,nm+nmatri)*nmatge(k,j,ng)
 1500             continue
                  ndir48(i,j,nm+2*nmatri)=ntmp
 1600           continue
 1700         continue
            endif
!=======================================================================
 1800    continue
         if (ngtyp(ng).eq.3) then
            nmatri=3*nmatri
         else
            nmatri=2*nmatri
         endif
 1900 continue
      return
      end
!=======================================================================
      function nback(n,ng)
      if (n.ge.0) then
         nback=mod(n,ng)
      else
         nback=mod(mod(n,ng)+ng,ng)
      endif
      return
      end
!=======================================================================
      subroutine symfft(nmsfft,mdir,ng1,ng2,ng3,nmstyp)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      integer nmsfft(ng1,ng2,ng3,*)
      integer mdir(3,3)
      integer ng1,ng2,ng3,nmstyp
      do 7200 n3=0,ng3-1
         do 7100 n2=0,ng2-1
            do 7000 n1=0,ng1-1
               m1=nback(mdir(1,1)*n1+mdir(1,2)*n2+mdir(1,3)*n3,ng1)
               m2=nback(mdir(2,1)*n1+mdir(2,2)*n2+mdir(2,3)*n3,ng2)
               m3=nback(mdir(3,1)*n1+mdir(3,2)*n2+mdir(3,3)*n3,ng3)
               nmsfft(n1+1,n2+1,n3+1,1)=(m3*ng2+m2)*ng1+m1+1
 7000       continue
 7100    continue
 7200 continue
      call sym3fl(nmsfft,ng1,ng2,ng3,nmstyp)
      return
      end
!=======================================================================
      subroutine sym3fl(nmsfft,ng1,ng2,ng3,nmstyp)
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      integer nmsfft(ng1*ng2*ng3,*)
!=======================================================================
! Treat the 3-fold rotations once more
!=======================================================================
      if (nmstyp.eq.3) then
         do 7500 np=1,ng1*ng2*ng3
            nmsfft(np,2)=nmsfft(nmsfft(np,1),1)
 7500    continue
      endif
      return
      end
!=======================================================================
      subroutine symfor(nconso,nmsfor,dirnms,fnleif,nionsp,forwrk,nions,numsym,nmstyp,nspec)
!=======================================================================
! subroutine symfor applies the point group symmetry operations to
! the non-local term in the force expression.
!=======================================================================
! in values:
! nmsfor .. the list of mirror ions
! dirnms .. the set of point group symmetry operations
! nmstyp .. the types of the point group operations
! fnleif .. the non-local contributions to the forces
! forwrk .. empty
! numsym .. the number of symmetry operations
!=======================================================================
! out values:
! fnleif .. symmetrized non-local contributions to the forces
! forwrk .. empty
! others .. untouched
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
!=======================================================================
      integer nmsfor(nions,*)
      integer nmstyp(*)
      real*8 dirnms(3,3,*)
      real*8 fnleif(3,nions,nspec)
      integer nionsp(nspec)
      real*8 forwrk(3,nions)
!=======================================================================
      nsym=1
      do 1600 ns=1,numsym
         if (nsym.le.numsym) then
            no=0
            do 1200 nsp=1,nspec
               do 1100 ni=1,nionsp(nsp)
                  no=no+1
                  do 1000 m=1,3
                     forwrk(m,no)=fnleif(m,ni,nsp)
 1000             continue
 1100          continue
 1200       continue
            no=0
            do 1500 nsp=1,nspec
               do 1400 ni=1,nionsp(nsp)
                  no=no+1
                  do 1300 m=1,3
!=======================================================================
! 2-fold point group operation
!=======================================================================
                     if (nmstyp(nsym).eq.2) then
                        fnleif(m,ni,nsp)=&
                             0.5d0*(forwrk(m,       no      )+&
                  (dirnms(m,1,nsym)*forwrk(1,nmsfor(no,nsym))&
                  +dirnms(m,2,nsym)*forwrk(2,nmsfor(no,nsym))&
                  +dirnms(m,3,nsym)*forwrk(3,nmsfor(no,nsym))))
!=======================================================================
! 3-fold point group operation
!=======================================================================
                     elseif (nmstyp(nsym).eq.3) then
                        n2=nmsfor(no,nsym)
                        n3=nmsfor(n2,nsym)
                        fnleif(m,ni,nsp)=&
                                            (forwrk(m,no)&
                        +(dirnms(m,1,nsym  )*forwrk(1,n2)&
                         +dirnms(m,2,nsym  )*forwrk(2,n2)&
                         +dirnms(m,3,nsym  )*forwrk(3,n2))&
                        +(dirnms(m,1,nsym+1)*forwrk(1,n3)&
                         +dirnms(m,2,nsym+1)*forwrk(2,n3)&
                         +dirnms(m,3,nsym+1)*forwrk(3,n3)))/3d0
!=======================================================================
! Unknown
!=======================================================================
                     else
                        write(nconso,*)&
              'Unexpected in symfor in @(#)symana.F	1.6'
                        call clexit(nconso)
                     endif
 1300             continue
 1400          continue
 1500       continue
!=======================================================================
! increase nsym with 2 if this was a three-fold symmetry
! (storage convention)
!=======================================================================
            if (nmstyp(nsym).eq.2) then
               nsym=nsym+1
            else
               nsym=nsym+2
            endif
         endif
 1600 continue
      return
      end
!=======================================================================
      subroutine symvel(nconso,nmsfor,dirnms,rvelo,forwrk,nions,numsym,nmstyp)
!=======================================================================
! subroutine symvel applies the point group symmetry operations to
! the velocities
!=======================================================================
! in values:
! nmsfor .. the list of mirror ions
! dirnms .. the set of point group symmetry operations
! nmstyp .. the types of the point group operations
! rvelo  .. the velocities
! forwrk .. empty
! numsym .. the number of symmetry operations
!=======================================================================
! out values:
! rvelo  .. symmetrized non-local contributions to the forces
! forwrk .. empty
! others .. untouched
!=======================================================================
      implicit none
!=======================================================================
      integer nconso
      integer nions, numsym
      integer nmsfor(nions,*)
      real*8 dirnms(3,3,*)
      real*8 rvelo(3,nions)
      real*8 forwrk(3,nions)
      integer nmstyp(*)
! locals
      integer nsym
      integer ns
      integer no
      integer m
      integer n2
      integer n3
!=======================================================================
      nsym=1
      do 1600 ns=1,numsym
         if (nsym.le.numsym) then
            do no=1,nions
               do m=1,3
                  forwrk(m,no)=rvelo(m,no)
               enddo
            enddo
            do no=1,nions
               do m=1,3
!=======================================================================
! 2-fold point group operation
!=======================================================================
                  if (nmstyp(nsym).eq.2) then
                     rvelo(m,no)=&
                             0.5d0*(forwrk(m,       no      )+&
                  (dirnms(m,1,nsym)*forwrk(1,nmsfor(no,nsym))&
                  +dirnms(m,2,nsym)*forwrk(2,nmsfor(no,nsym))&
                  +dirnms(m,3,nsym)*forwrk(3,nmsfor(no,nsym))))
!=======================================================================
! 3-fold point group operation
!=======================================================================
                  elseif (nmstyp(nsym).eq.3) then
                     n2=nmsfor(no,nsym)
                     n3=nmsfor(n2,nsym)
                     rvelo(m,no)=&
                                            (forwrk(m,no)&
                        +(dirnms(m,1,nsym  )*forwrk(1,n2)&
                         +dirnms(m,2,nsym  )*forwrk(2,n2)&
                         +dirnms(m,3,nsym  )*forwrk(3,n2))&
                        +(dirnms(m,1,nsym+1)*forwrk(1,n3)&
                         +dirnms(m,2,nsym+1)*forwrk(2,n3)&
                         +dirnms(m,3,nsym+1)*forwrk(3,n3)))/3d0
!=======================================================================
! Unknown
!=======================================================================
                  else
                     write(nconso,*)&
              'Unexpected in symvel in @(#)symana.F	1.6'
                     call clexit(nconso)
                  endif
               enddo
            enddo
!=======================================================================
! increase nsym with 2 if this was a three-fold symmetry
! (storage convention)
!=======================================================================
            if (nmstyp(nsym).eq.2) then
               nsym=nsym+1
            else
               nsym=nsym+2
            endif
         endif
 1600 continue
      return
      end
!=======================================================================
      subroutine symchd(nconso,nplwv,rdensr,rwork,nmsfft,numsym,nmstyp)
!=======================================================================
! this subroutine applies the set of point group operations to the
! charge density
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      integer nconso,nplwv
      real*8 rdensr(nplwv)
      real*8 rwork(nplwv)
      integer nmsfft(nplwv,*)
      integer nmstyp(*)
!     locals
      logical*4 ihome
!=======================================================================
      ihome=.true.
      nsym=1
      do 1400 ns=1,numsym
         if (nsym.le.numsym) then
!=======================================================================
! 2-fold point group operation
!=======================================================================
            if (nmstyp(nsym).eq.2) then
               if (ihome) then
                  do 1000 np=1,nplwv
                     rwork(np)=(rdensr(np)+rdensr(nmsfft(np,nsym)))/2d0
 1000             continue
                  ihome=.false.
               else
                  do 1100 np=1,nplwv
                     rdensr(np)=(rwork(np)+rwork(nmsfft(np,nsym)))/2d0
 1100             continue
                  ihome=.true.
               endif
               nsym=nsym+1
!=======================================================================
! 3-fold point group operation
!=======================================================================
            elseif (nmstyp(nsym).eq.3) then
               if (ihome) then
                  do 1200 np=1,nplwv
                     n2=nmsfft(np,nsym)
                     n3=nmsfft(np,nsym+1)
                     rwork(np)=(rdensr(np)+rdensr(n2)+rdensr(n3))/3.0d0
 1200             continue
                  ihome=.false.
               else
                  do 1300 np=1,nplwv
                     n2=nmsfft(np,nsym)
                     n3=nmsfft(np,nsym+1)
                     rdensr(np)=(rwork(np)+rwork(n2)+rwork(n3))/3.0d0
 1300             continue
                  ihome=.true.
               endif
               nsym=nsym+2
!=======================================================================
! Unknown
!=======================================================================
            else
               write(nconso,*) 'Unexpected in symchd in @(#)symana.F  1.6'
               call clexit(nconso)
            endif
         endif
 1400 continue
!=======================================================================
! if numsym is an odd number then the result is in rwork
!=======================================================================
      if (.not.ihome) then
         do 1500 np=1,nplwv
            rdensr(np)=rwork(np)
 1500    continue
      endif
      return
      end
!=======================================================================
      subroutine symcnv(dirc,recc,nspama,numspa)
!=======================================================================
! Convert the space group matrices to the reciprocal space basis
!=======================================================================
      implicit double precision (a,b,d-h,o-z)
      real*8 dirc(3,3)
      real*8 recc(3,3)
      integer nspama(3,3,numspa)
      real*8 rrot(3,3)
      real*8 unirot(3,3)
      real*8 dirnm(3,3)
      parameter(tpi=6.2831853072d0)
!=======================================================================
! loop over all numspa space group matrices
!=======================================================================
      do 1000 nspa=1,numspa
!=======================================================================
! Convert the reciprocal basis to a1,a2,a3 coordinates
!=======================================================================
      do 9040 j=1,3
         do 9030 i=1,3
            dtmp=0.0d0
            do 9020 k=1,3
               dtmp=dtmp+recc(i,k)*recc(j,k)/tpi**2
 9020       continue
            unirot(i,j)=dtmp
 9030    continue
 9040 continue
!=======================================================================
! rotate the a1,a2,a3 basis
!=======================================================================
      do 9260 j=1,3
         do 9240 i=1,3
            dtmp=0.0d0
            do 9220 k=1,3
               dtmp=dtmp+dirc(k,i)*dble(nspama(k,j,nspa))
 9220       continue
            dirnm(i,j)=dtmp
 9240    continue
 9260 continue
!=======================================================================
! Get the rotated reciprocal basis in x,y,z coordinates
!=======================================================================
      do 9530 j=1,3
         do 9520 i=1,3
            dtmp=0.0d0
            do 9510 k=1,3
               dtmp=dtmp+dirnm(i,k)*unirot(k,j)
 9510       continue
            rrot(i,j)=dtmp
 9520    continue
 9530 continue
!=======================================================================
! Get the rotated reciprocal basis in b1,b2,b3 coordinates
!=======================================================================
         do 1040 j=1,3
            do 1030 i=1,3
               dtmp=0.0d0
               do 1020 k=1,3
                  dtmp=dtmp+dirc(i,k)*rrot(k,j)
 1020          continue
               nspama(i,j,nspa)=nint(dtmp)
 1030       continue
 1040    continue
 1000 continue
      return
      end
!=======================================================================
      subroutine syminv(nspama,linvad,numspa,nmamax,nconso)
!=======================================================================
! Add the inversion if it is not already contained
! (The space group matrices are only intended for the k-point reduction)
!=======================================================================
      implicit double precision (a,b,d-h,o-z)
      integer nspama(3,3,nmamax)
      logical*4 linvad(nmamax)
!=======================================================================
! local array
!=======================================================================
      integer ninv(3,3)
      logical*4 isinve
      logical*4 iaddin
!=======================================================================
! Run through all numspa space group matrices and see if the inversion
! is there
!=======================================================================
      iaddin=.true.
      do 1000 nspa=1,numspa
         if (isinve(nspama(1,1,nspa))) iaddin=.false.
         linvad(nspa)=.false.
 1000 continue
      if (iaddin) then
         write(nconso,*)'SYM: The inversion is not contained in the space group'
         write(nconso,*)'SYM: The k-point set will be reduced via the time inversion symmetry'
         write(nconso,*)'SYM: '
         if (numspa.gt.(nmamax/2)) then
            write(nconso,*)'Unexpected in syminv()'
            call clexit(nconso)
         endif
!=======================================================================
! Setup the inversion matrix
!=======================================================================
         do 1300 j=1,3
            do 1200 i=1,3
               ninv(i,j)=0
 1200       continue
            ninv(j,j)=-1
 1300    continue
!=======================================================================
! loop over the numspa matrices, multiply and store
!=======================================================================
         do 1600 nspa=1,numspa
           call symmatmul(nspama(1,1,nspa),ninv,nspama(1,1,nspa+numspa))
           linvad(nspa+numspa)=.true.
 1600    continue
         numspa=2*numspa
      endif
      return
      end
!=======================================================================
      subroutine symcff(ng1,ng2,ng3,nplwv,nrplwv,nplwkp,nindou,nindin,&
                        nbands,&
                        matrix,lkpinv,cptwfp,cwork1,cwor12)
!=======================================================================
      implicit none
      integer ng1,ng2,ng3,nplwv,nrplwv,nplwkp
      integer nindou(nrplwv)
      integer nindin(nrplwv)
      integer nbands
      integer matrix(3,3)
      logical*4 lkpinv
      complex*WF_PRECISION cptwfp(nrplwv,nbands)
      complex*16 cwork1(nplwv)
      complex*16 cwor12(nplwv)
!=======================================================================
! Temporaries
!=======================================================================
      integer nn,nb,mm,ng1max,ng2max,ng3max,ng1min,ng2min,ng3min
      integer nloop1,nloop2,nloop3,n1,n2,n3
      integer new1,new2,new3,mmrot
!=======================================================================
! Reset an FFT grid-sized array
!=======================================================================
      do 1000 nn=1,nplwv
         cwork1(nn)=(0.0d0,0.0d0)
         cwor12(nn)=(0.0d0,0.0d0)
 1000 continue
!=======================================================================
! loop over the bands
!=======================================================================
      do 1600 nb=1,nbands
!=======================================================================
! Put the coefficients on the FFT grid (where the indexing is simple)
!=======================================================================
         do 1100 nn=1,nplwkp
            cwork1(nindin(nn))=cptwfp(nn,nb)
 1100    continue
!=======================================================================
! Rotate all coefficients on the FFT grid and store in new FFT grid
!=======================================================================
         mm=1
         ng1max=ng1/2
         ng2max=ng2/2
         ng3max=ng3/2
         ng1min=-(ng1-1)/2
         ng2min=-(ng2-1)/2
         ng3min=-(ng3-1)/2
!=======================================================================
! Loop and let (n1,n2,n3) be the G1,G2,G3 index with signs
!=======================================================================
         do 1400 nloop3=0,ng3-1
            n3=nloop3
            if (n3.gt.ng3max) n3=n3-ng3
            do 1300 nloop2=0,ng2-1
               n2=nloop2
               if (n2.gt.ng2max) n2=n2-ng2
               do 1200 nloop1=0,ng1-1
                  n1=nloop1
                  if (n1.gt.ng1max) n1=n1-ng1
!=======================================================================
! Apply the point group operation that took k to the IBZ
!=======================================================================
                  new1=matrix(1,1)*n1+matrix(1,2)*n2+matrix(1,3)*n3
                  new2=matrix(2,1)*n1+matrix(2,2)*n2+matrix(2,3)*n3
                  new3=matrix(3,1)*n1+matrix(3,2)*n2+matrix(3,3)*n3
!=======================================================================
! "Carry over" the coefficient if the new G1,G2,G3 coordinates fall
! within the reciprocal space FFT-grid
!=======================================================================
                  if (ng1min.le.new1.and.new1.le.ng1max.and.&
                      ng2min.le.new2.and.new2.le.ng2max.and.&
                      ng3min.le.new3.and.new3.le.ng3max) then
                     if (new1.lt.0) new1=new1+ng1
                     if (new2.lt.0) new2=new2+ng2
                     if (new3.lt.0) new3=new3+ng3
                     mmrot=(new3*ng2+new2)*ng1+new1+1
                     if (lkpinv) then
                        cwor12(mm)=conjg(cwork1(mmrot))
                     else
                        cwor12(mm)=cwork1(mmrot)
                     endif
                  endif
                  mm=mm+1
 1200          continue
 1300       continue
 1400    continue
!=======================================================================
! Take the coefficients within the cutoff
!=======================================================================
         do 1500 nn=1,nplwkp
            cptwfp(nn,nb)=cwor12(nindou(nn))
 1500    continue
 1600 continue
!=======================================================================
      return
      end

!-----------------------------------------------------------------------stop

      subroutine dump_symgen(ngeacc, ngemax, mgenset, mgenset_mtype,lmastr)
!====================================================================
!   Dump minimal spatial generator set to netCDF output file
!   Nothing is written, if no symmetry generators are used (ngeacc<1)
!   The unit operator is omitted (implicit)
!====================================================================
      use netcdfinterface
      use run_context
      implicit none
      integer ngeacc, ngemax
      integer mgenset(3,3,ngemax)
      integer mgenset_mtype(ngemax)
      logical*4 lmastr

! --- locals ---

      integer ncid, status, j
     
!-----------------------------------------------------------------------stop

      if (.not.lmastr) return
      if (ngeacc < 1)  return

      status = nf_open(netCDF_output_filename, NF_WRITE, ncid )
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nf_open: error")   

! ---- The dimension "number_of_symm_gen" corresponds to number of -----
! ---- accepted generators, and is less or equal to nsym           -----
! ---- (only one element in 3,4-fold cyclic groups are dumped)     -----

      status = nfputglobaldim(ncid,'number_of_symm_gen',ngeacc) 
      if ((status/=nfif_OK ).and.(status/=nfif_dimexist_butOKsize))  &
          call abort_calc(nconso,  &
               "dump_symgen->nfputglobaldim: error")   

! ---- SymmetryGenerators:    ------------------------------------------

      status = nfput(ncid,'SymmetryGenerators',mgenset(:,:,1:ngeacc),&
                     dim_name1='dim3', dim_name2='dim3', &
                     dim_name3='number_of_symm_gen') 
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nfput(SymmetryGenerators):"//&
                          ": error")   

      status = nfput(ncid,'SymmetryGenerators%Description',&
                     'Point group operators S on Bravais '//&
                     'lattice vectors: A_rot = S:A. '//&
                     'Unit operator not included. '//&
                     'Rowvise transform. vectors (c-style reading).')
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nfput"//&
                          "(SymmetryGenerators%Description): error") 

! ---- SymmetryGeneratorOrder:    --------------------------------------

      status = nfput(ncid,'SymmetryGeneratorOrder',&
                     mgenset_mtype(1:ngeacc), &
                     dim_name1='number_of_symm_gen')
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nfput(SymmetryGeneratorOrder):"&
                        //": error") 

        status = nfput(ncid,'SymmetryGeneratorOrder%Description',&
                     'S**Order = 1. Possible values  = 2,3,4')
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nfput"//&
                          "(SymmetryGeneratorOrder%Description): error") 

! ---- we are done                --------------------------------------

      status = nf_close(ncid)
      if (status /= nf_noerr) &
          call abort_calc(nconso,  &
               "dump_symgen->nf_close: error")  
      

      end subroutine dump_symgen
