#include "definitions.h"
      subroutine setuspot_id(nconso)
      write(nconso,*) '@(#)setuspot.F	1.14 7/1/99'
      return
      end
!----------------------------------------------------------------------
      subroutine setuspot(psgmax,nplwv,nrplwv,nrplwv_global,nspec,&
                          nions, nionsp,nbands,nkprun,volc,lspsi)

      use run_context 
      use van_us_data_module
      implicit  none
      include 'readvan.h'

      integer   nplwv,nrplwv,nrplwv_global,nbands,nkprun
      integer   nions,nspec,nionsp(nspec)
      real *8   posion(3,nions,nspec),dirc(3,3)
      logical*4 lspsi
      real *8   psgmax,volc
!
      real *8    g1(3),gg1(1),ylm0(lqx*lqx)
      integer    ik, na, i, np, m, l,lm, iv,jv,nkp,nhmax,&
                 l1,n,jkb,nplwkp,nsp,mu,nat,kpoint,it
      integer    IVS,IVL,JVS,JVL,LP
      real*8     rlog(nspec)

      complex*16 sk(2)

      real*8 ZERO,eps
      parameter (ZERO = 0.0d0,eps= 1.0e-8) 

!     set the flag that we are using the generalized form 
      lgenpp = .true.

!     calculate nh
!     loop over the different pseudo-potentials
      do np = 1,nspec
        if(tvanp(np))  then
           nh(np) = 0
           do n = 1,nbeta(np)
              nh(np) = nh(np) + 2*lll(n,np)+1
           enddo
!          write(nconso,*) 'nh for spec : ',np,' = ',nh(np)
!          call uflush(nconso)
        else
            nh(np) = (lmax(np)+1)*(lmax(np)+1)-(2*lloc(np)+1)
        endif
      enddo
!
!     get nhmax 
      nhmax = 0 
      nhmax = nh(1)
      if (nhmax.gt.nhm) then 
         call report_error("setuspot","nhmax>nhm",nhmax) 
      endif 

!     get the number of different kind of projectors 
      nkbp = 0 
      do it = 1,nspec  
        nkbp = nkbp + nh(it) 
      enddo  
      write(nconso,*) 'Number of different projectors : ',nkbp
      call uflush(nconso)

!     get the number of projectors 
      nkb = 0 
      do na = 1,nions
        it = ityp(na) 
        nkb = nkb + nh(it) 
      enddo  
      write(nconso,*) 'Number of projectors : ',nkb
      call uflush(nconso)

      if (nkbp.gt.nhm) &
        call report_error("setuspot","nkbb>nhm",nkbp )
      
!     initialize nkbtona , nkbtonh
      jkb = 1
      do na =1, nions
         n = 0
         do i = 1,ityp(na)-1
           n = n + nh(i)
         enddo
         do i=1, nh(ityp(na))
#ifdef BLAS2
            nkbc(na,i)   = jkb
#else
            nkbc(na,i+n)   = jkb
#endif
            nkbtona(jkb) = na
            nkbtonh(jkb) = i
!           write(*,*) n,na,jkb,ityp(na),nkbc(na,i+n)
            jkb = jkb+1
         enddo
      enddo

!     initialize nkptoit 
      jkb=1
      do it =1, nspec
         do i=1, nh(it)
            nkptoit(jkb) = it
            jkb = jkb+1
         enddo
      enddo

!     initialize Clebsch-Cordan coefficients ap,lpx,lpl,
!     used in the construction of Qnm
!     See qvan2.F 
      CALL AAINIT(lmaxx+1,2*lmaxx+1,lqx,ap,lpx,lpl)

!     initialize indv,DION

      DO np =1,nspec
        IV = 1
        DO I=1,nbeta(np)
            l = lll(i,np)
            DO M=1,2*L+1
                nhtol(IV,NP) = L
                nhtom(IV,NP) = m
                indv(IV,NP)  = i
                IV = IV+1
            END DO
        END DO
      END DO

!     initialize  dvan
      do np = 1,nspec
        call setv(nhm*nhm,ZERO,dvan(1,1,np),1)
        do iv=1,nh(np)  
         do jv=1,nh(np)
          if ( nhtol(iv,np).eq.nhtol(jv,np) .and.&
            nhtom(iv,np).eq.nhtom(jv,np) ) then
            dvan(iv,jv,np)=dion(indv(iv,np),indv(jv,np),np)
!           write(nconso,*) 'DVAN(',NP,')',IV,JV,DVAN(IV,JV,NP)
            call uflush(nconso)
          endif
         end do
        end do
      enddo

!     calculate qrad(G=0) 
      gg1(1) = 0.0d0 
      igtongl(1) = 1
      call calcqr(1,ngldim,1,nspec,volc, gg1,qrad,0,&
                  ivjv2index,maxindex)

#ifdef QRAD_SWAP
      if (nspec.gt.1) call openqrad(1)
#endif QRAD_SWAP

      do np =1,nspec

#ifdef QRAD_SWAP
        if (nspec.gt.1) call readqrad(ngldim,1,np,qrad,maxindex)
#endif QRAD_SWAP

!       initialize qnm
        call setv(nhm*nhm,ZERO,qq(1,1,np),1)
  
!       initialize lll
        do iv=1,nh(np)
           lll(indv(iv,np),np) = nhtol(iv,np)
        enddo

         
        lspsi = .true.
        if (tvanp(np)) then
!        use qvan2 to integrate  qnm (G=0 component of qrad)
!        get spherical harmonics for G=0 
         call ylmg(lqx*lqx,g1,gg1,lqx*lqx,ylm0)
!      
         DO IV=1,NH(NP)
          DO JV=1,NH(NP)
!           get G = 0 component of qrad
            call qvan2(0,1,iv,jv,np,1,sk,ylm0,qrad,nrplwv,&
                  nspec,ngldim,igtongl,nhm,indv,nhtol,nhtom,&
                  ap,lpx,lpl,ivjv2index,nbrx,nlx,mx,nbrx2dim,lqx)
            qq(iv,jv,np) = dble(sk(1))
            qq(jv,iv,np) = qq(iv,jv,np)
            if (dabs(qq(iv,jv,np)).gt.eps) lspsi = .true. 
          END DO
         END DO
      
        endif
      enddo   ! np = 1,nspec
#ifdef QRAD_SWAP
      if (nspec.gt.1) close(44)
#endif QRAD_SWAP


#ifdef DEBUG
     write 
      write(*,*)
      do np =1,nspec
        write(*,*) '    qq(',np,')'
        do iv=1,nh(np)
          write(*,'(8f9.4)') (qq(iv,jv,np),jv=1,nh(np))
        end do
      enddo

      write(*,*) '  nlinit:  nh '
      do np = 1,nspec
        write(*,*) '  nlinit:  nh(',np,') = ',nh(np)
        do iv=1,nh(np)                           
           write(*,*) ' iv indv nh2l nh2m',iv,indv(iv,np),&
                 nhtol(iv,np), nhtom(iv,np), lll(indv(iv,np),np)
        enddo
      enddo

      write(*,*)
      write(*,'(20x,a)') '    dion '
      do np = 1,nspec
        write(*,*) 'Species ',np 
        do iv=1,nbeta(np)
          write(*,*) 'Projector ',iv
          write(*,'(8f16.10)') (dion(iv,jv,np),jv=1,nbeta(np))
        end do
      enddo
#endif DEBUG

!     initialize linitvkb to true for all k-points
      do nkp = 1,nkprun
         linitvkb(nkp) = .true.
      enddo
! 
! -------------------------------------------------------------     
!     Check for qvan2 properties
!     Moved from qvan2
      do nsp = 1,nspec
       do iv = 1, nh(nsp)
        do jv = iv, nh(nsp)

        IVS = INDV(IV,nsp)
        JVS = INDV(JV,nsp)
        IVL = nhtol(IV,nsp)*nhtol(IV,nsp)+nhtom(IV,nsp)
        JVL = nhtol(jV,nsp)*nhtol(jV,nsp)+nhtom(jV,nsp)
        IF(IVL.GT.NLX) CALL REPORT_ERROR('SETUSPOT','IVL.GT.NLX ',IVL)
        IF(JVL.GT.NLX) CALL REPORT_ERROR('SETUSPOT','JVL.GT.NLX ',JVL)
        IF(IVS.GT.NBRX)CALL REPORT_ERROR('SETUSPOT','IVS.GT.NBRX',IVS)
        IF(JVS.GT.NBRX)CALL REPORT_ERROR('SETUSPOT','JVS.GT.NBRX',JVS)

        DO I=1,LPX(IVL,JVL)
         LP = LPL(IVL,JVL,I)
         if ((LP.lt.0).or.(LP.ge.26)) then
          CALL REPORT_ERROR(' SETUSPOT ','LP not in range(0:25)',LP)
         endif
        ENDDO
         
        enddo
       enddo
      enddo
!---------------------------------------------------------------

!     The Fourier components of the beta-functions 
!     (vkb calculated in cal_bec) are either all real 
!     (even inversion symmetry l=0,l=2) vkb (calculated in cal_vkb) or 
!     all complex (odd inversion symmetry l=1). 

      jkb = 1
      do np = 1,nspec
      do iv=1,nh(np)
            l = nhtol(iv,np)
            if (l.eq.0) vkbreal(iv,np) = .true.
            if (l.eq.1) vkbreal(iv,np) = .false.
            if (l.eq.2) vkbreal(iv,np) = .true.
            jkb = jkb+1
      enddo

      enddo   ! np = 1,nspec

      return
      end

