       subroutine pwunid(nconso)
       write(nconso,*) '@(#)pwunsp.F	1.9 6/15/99'
       return
       end
!=======================================================================
!   subroutines generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991).  they are keyed to the "programmable
!       expressions" in the notes of 1/23/91.
!=======================================================================
      subroutine pwunsp(lgga,lcalvx,&
           nconso,dn,volc,recc,lpctx,lpcty,lpctz,&
           enxcc,enxc,ex,vxc,&
           cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc )
!          ---------------
! if lgga: req. if lcalvx=FALSE
!          ---------------------------------------------------------
!                        required if lcalvx=TRUE
!
      use stress_module, only : xc_gga_stress
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      logical*4 lcalvx
      integer nconso,nplwv,npwxc,nspin
      integer ngx,ngy,ngz
      real*8 volc
      dimension recc(3,3)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 enxc,enxcc,enxcc1l,enxcc1g,enxcc2,ex(2)
      dimension vxc(nplwv)
      dimension dn(nplwv)
      dimension cwork1(nplwv)
      dimension dnlg0(npwxc,3)
      logical*4 lgga

! Local work arrays
! work arrays required no matter what lcalvx is
      dimension absnab(nplwv)
      dimension cab(nplwv)
! work arrays required when lcalvx is TRUE (in this case 
! npwxc==nplwv)
      dimension dnabln(npwxc,3)
      dimension df2(npwxc)
      dimension densp(npwxc)
      real*8 exclda,excgga,exlda,exgga
!=======================================================================
      data pi,thrd,thrd2/3.14159265d0,0.333333333333d0,0.666666666667d0/
      data hartre/27.2116d0/
!=======================================================================
      bohr = 0.529177d0
      angs = 1.0d0/bohr
      rconf = (3.0d0*pi**2)**thrd
      rconrs = (3.0d0/(4.0d0*pi))**thrd
      vol = volc / (bohr**3)
      recvol=1.0d0/vol
      rinplw=1.0d0/dble(nplwv)
!
      if (lgga) then
         do m=1,nplwv
            cab(m)=dn(m)*rinplw
         enddo
      endif
!
! find the density gradient
!
      if (lgga.and.lcalvx) then
!
! we have lots of workspace
!
!
! Truncate charge density dn(m) to a slightly positive value
! (even for negative densities)
! so that the functional makes sense.
! we only have the workarray, densp, if running selfconsistently
!
         do m=1,nplwv
            densp(m) = max(1.0d-10, dn(m)) * recvol
         enddo
!
         call fft3d(cab,ngx,ngy,ngz,-1)
!=======================================================================
! loop over x,y,z to get nabla n -> dnabln(1..nplwv,1..3)
! and |nabla n| -> absnab(1..nplwv)
!=======================================================================
         do 1504 i=1,3
            do 1506 m=1,nplwv
               cwork1(m)=dcmplx(0.0d0,dnlg0(m,i))*cab(m)
 1506       continue
            call fft3d(cwork1,ngx,ngy,ngz,1)
!        For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1) then
               do 1508 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=dnabln(m,i)**2
 1508          continue
            else if (i.eq. 2) then
               do 1509 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=absnab(m)+dnabln(m,i)**2
 1509          continue
            else if (i.eq. 3) then
               do 1510 m=1,nplwv
                  dnabln(m,i)=dble(cwork1(m))
                  absnab(m)=sqrt(absnab(m)+dnabln(m,i)**2)
                  if (absnab(m) .lt. 1.0d-10) absnab(m) = 1.0d-10
 1510          continue
            endif
 1504    continue
      else if (lgga.and..not.lcalvx) then
!
! we have almost no workspaces
!
         call fft3d(cab,ngx,ngy,ngz,-1)
!=======================================================================
! loop over x,y,z to get nabla n -> dnabln(1..nplwv,1..3)
! and |nabla n| -> absnab(1..nplwv)
!=======================================================================
         do i=1,3
            n=1
            do nz=1,ngz
               g3i=recc(3,i)*lpctz(nz)
               do ny=1,ngy
                  g2i=recc(2,i)*lpcty(ny)
                  do nx=1,ngx
                     g1i=recc(1,i)*lpctx(nx)
                     cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                     n=n+1
                  enddo
               enddo
            enddo
            call fft3d(cwork1,ngx,ngy,ngz,1)
!        For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1) then
               do m=1,nplwv
                  absnab(m)=dble(cwork1(m))**2
               enddo
            else if (i.eq. 2) then
               do m=1,nplwv
                  absnab(m)=absnab(m)+dble(cwork1(m))**2
               enddo
            else if (i.eq. 3) then
               do m=1,nplwv
                  absnab(m)=sqrt(absnab(m)+dble(cwork1(m))**2)
                  if (absnab(m) .lt. 1.0d-10) absnab(m) = 1.0d-10
               enddo
            endif
         enddo
      endif
!=====================================================================
!       generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991). 
!=======================================================================
      exclda = 0.0d0
      excgga = 0.0d0
      ex(1)  = 0.0d0            
      ex(2)  = 0.0d0 
      if (lcalvx) then
         enxcc1l=0.0d0
         enxcc1g=0.0d0
      endif
!=====================================================================
! loop over all real space grid points in the super cell
!=====================================================================
      do 5558 m=1,nplwv
         if (lgga.and.lcalvx) then
            d = densp(m)
         else
            d = max(1.0d-10, dn(m)) * recvol
         endif
        d13=exp(log(d)*thrd)
        fk=rconf*d13
        if (lgga) then
           drho = absnab(m)*(bohr*recvol)
        else
           drho = 0.0d0
        endif
        s=drho/(d*fk*2.d0)
        call exch1(d,d13,s,exlda,exgga,exdlda,exdgga,exdd)
        exclda=exclda+exlda
        excgga=excgga+exgga
        ex(1) = ex(1) + exlda
        ex(2) = ex(2) + exgga
        if(lcalvx) then
           enxcc1l=enxcc1l-exdlda*d
           enxcc1g=enxcc1g-exdgga*d
           if(lgga) then
              vxc(m)=exdgga*hartre
              df2(m)=exdd*hartre
           else
              vxc(m)=exdlda*hartre
           endif
        endif
         rs=rconrs / d13
         sk = sqrt(fk*(4.0d0/pi))
         t=drho/(d*sk*2.d0)

!
! local correlation
!
         call cor1lsd(d,rs,ec,ecd,eu,eurs)
!
! non-local correlation
         if (lgga) then
            call cor1gga(d,rs,fk,sk,eu,eurs,&
                 t,ec1,ec1d,ec1dd)
         endif
         exclda=exclda+ec
         if (lgga) excgga=excgga+ec+ec1

         if (lcalvx) then
            enxcc1l=enxcc1l-ecd*d
            if (lgga) then
               vxc(m)=vxc(m)+(ecd+ec1d)*hartre
               df2(m)=df2(m)+ec1dd*hartre
               enxcc1g=enxcc1g-(ecd+ec1d)*d
            else
               vxc(m)=vxc(m)+ecd*hartre
            endif
         endif
 5558 continue
!
      if (lgga.and.lcalvx) then
         enxcc2=0.0d0
         do 7010 i=1,3
            do 7020 m=1,nplwv
              cwork1(m)=-rinplw*df2(m)*dnabln(m,i)/absnab(m)
 7020       continue
            call fft3d(cwork1,ngx,ngy,ngz,-1)
            if (i .eq. 1) then
              do 7030 m=1,nplwv
                cab(m)=       dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7030         continue
            else
              do 7031 m=1,nplwv
                cab(m)=cab(m)+dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7031         continue
            endif
 7010    continue
         call fft3d(cab,ngx,ngy,ngz,1)
         do m=1,nplwv
            vxc(m)=vxc(m)+dble(cab(m))*bohr
            enxcc2=enxcc2-dble(cab(m))*(densp(m)*(1.0/recvol))
         enddo
!        calculate GGA stress contribution 
!        se Corso and Resta, PRB 50, 4327 (1994) 
!        eg. 24 second term (fist term calculated in stress.F)
!        sum(R) dfxc/d(d_x1n) * dn/dr_x2
         call xc_gga_stress(ngx,ngy,ngz, df2,dnabln,absnab,volc) 

      endif
!
! ---- normalize energies ----
!
      exclda=exclda*hartre*vol/nplwv
      excgga=excgga*hartre*vol/nplwv
      ex(1) = ex(1)*hartre*vol/nplwv
      ex(2) = ex(2)*hartre*vol/nplwv
      if (lcalvx) then
         enxcc1l=enxcc1l*hartre*vol/nplwv
         enxcc1g=enxcc1g*hartre*vol/nplwv
         if (lgga) enxcc2=enxcc2*bohr/nplwv
      endif
!
      if (lcalvx) then
         if(lgga) then
            enxc=excgga
            enxcc=enxc+enxcc1g+enxcc2
         else
            enxc=exclda
            enxcc=enxc+enxcc1l
         endif
      else
         enxcc=exclda
         enxc=excgga
      endif

      return
      end
!=======================================================================
      subroutine exch1(d,d13,s,exlda,exgga,exdlda,exdgga,exdd)
!  gga91 exchange for a spin-unpolarized electronic system
!  input d : density
!  input d13 : density**(1/3)
!  input s:  abs(grad d)/(2*kf*d)
!  output:  exchange energy per electron (ex) and ites derivatives
!           w.r.t. d (exd) and dd (exdd)
      implicit double precision (a-h,o-z)
      data a1,a2,a3,a4/0.19645d0,0.27430d0,0.15084d0,100.0d0/
      data ax,aa,b1/-0.7385588d0,7.7956d0,0.004d0/
      data thrd,thrd4/0.33333333333333d0,1.333333333333333d0/
      data thpith/3.0936677262801d0/
      fac = ax*d13
      s2 = s*s
      s3 = s2*s
      s4 = s2*s2
      p0 = 1.0d0/sqrt(1.0d0+aa*aa*s2)
      p1 = log(aa*s+1.0d0/p0)
      p2 = exp(-a4*s2)
      p3 = 1.0d0/(1.0d0+a1*s*p1+b1*s4)
      p4 = 1.0d0+a1*s*p1+(a2-a3*p2)*s2
      f = p3*p4
      exlda = fac*d
      exgga = exlda*f
      p5 = 2.0d0*(s*(a2-a3*p2)+a3*a4*s3*p2-2.0d0*b1*s3)
      p6 = (a1*(p1+aa*s*p0)+4.0d0*b1*s3)*&
           ((a2-a3*p2)*s2-b1*s4)
      fs = (p5*p3-p6*p3*p3)
      exdgga = thrd4*fac*(f-s*fs)
      exdd = ax*fs*(0.5d0/thpith)
      exdlda = thrd4*fac
      return
      end
!==============================================================
      subroutine cor1lsd(d,rs,ec,ecd,eu,eurs)
!  uniform-gas correlation of perdew and wang 1991
!  input: seitz radius (rs), relative spin polarization (zet)
!  output: correlation energy per electron (ec), up- and down-spin
!     potentials (vcup,vcdn), derivatives of ec wrt rs (ecrs) & zet (eczet)
!  output: correlation contribution (alfc) to the spin stiffness
      implicit double precision (a-h,o-z)
      data gam,fzz/0.5198421d0,1.709921d0/
      data thrd,thrd4/0.33333333333333d0,1.33333333333333d0/
! = = = = = = = = = = = = 
      call gcor1(0.0310907d0,0.21370d0,7.5957d0,3.5876d0,1.6382d0,&
          0.49294d0,1.00d0,rs,eu,eurs)
      ec = eu*d
      ecrs=eurs
      ecd = eu-thrd*rs*eurs
      return
      end
!==============================================================
      subroutine gcor1(aaa,a1,b1,b2,b3,b4,p,rs,gg,ggrs)
!  called by subroutine corlsd
      implicit double precision (a-h,o-z)
!      p1 = p + 1.0d0
      q0 = -2.0d0*aaa*(1.0d0+a1*rs)
      rs12 = sqrt(rs)
      rs32 = rs12**3
      rsp = rs
      q1 = 2.0d0*aaa*(b1*rs12+b2*rs+b3*rs32+b4*rs*rsp)
      q2 = log(1.0d0+1.0d0/q1)
      gg = q0*q2
      q3 = aaa*(b1/rs12+2.0d0*b2+3.0d0*b3*rs12+2.0d0*b4*2.0d0*rsp)
      ggrs = -2.0d0*aaa*a1*q2-q0*q3/(q1**2+q1)
      return
      end
!================================================================       
      subroutine cor1gga(d,rs,fk,sk,ec,ecrs,&
           t,ec1,ec1d,ec1dd)
!  gga91 correlation
!  input rs: seitz radius
!  input t: abs(grad d)/(d*2.*ks)
!  output hn: nonlocal part of correlation energy
!  hnd,hndd : derivatives of hn w.r.t. d and dd
      implicit double precision (a-h,o-z)
      data xnu,cc0,cx,alf/15.75592d0,0.004235d0,-0.001667212d0,0.09d0/
      data c1,c2,c3,c4/0.002568d0,0.023266d0,7.389d-6,8.723d0/
      data c5,c6,a4/0.472d0,7.389d-2,100.0d0/
      data thrd,sixth7/0.33333333333333d0,1.16666666666667d0/
      data pi/3.1415926536d0/
      bet = xnu*cc0
      beti = 1.0d0 / bet
      delt = 2.0d0*alf*beti
      pon = -delt*ec*beti
      b = delt/(exp(pon)-1.0d0)
      b2 = b*b
      t2 = t*t
      t4 = t2*t2
      t6 = t4*t2
      rs2 = rs*rs
      rs3 = rs2*rs
      q4 = 1.0d0+b*t2
      q5 = 1.0d0+b*t2+b2*t4
      q6 = c1+c2*rs+c3*rs2
      q7 = 1.0d0+c4*rs+c5*rs2+c6*rs3
      q7i = 1.0d0 / q7
      cc = -cx + q6*q7i
      r0 = (sk/fk)**2
      r1 = a4*r0
      coeff = cc-cc0-(3.0d0/7.0d0)*cx
      r2 = xnu*coeff
      r3 = exp(-r1*t2)
      h0 = (bet/delt)*log(1.0d0+delt*q4*t2/q5)
      h1 = r3*r2*t2
      h = h0+h1
      ec1 = d*h
!============================================================
      q8 = q5*q5+delt*q4*q5*t2
      q8i = 1.0d0 / q8
      h0t = 2.0d0*bet*t*(1.0d0+2.0d0*b*t2)*q8i
      h0b = -bet*t6*(2.0d0*b+b2*t2)*q8i
      h0rs = h0b*b*ecrs*(b+delt)*beti
      h1t = 2.0d0*r3*r2*t*(1.0d0-r1*t2)
      ccrs = (c2+2.d0*c3*rs)*q7i - &
           q6*(c4+2.d0*c5*rs+3.d0*c6*rs2)*(q7i**2)
      r1rs = 100.0d0*r0/rs
      h1rs = xnu*t2*r3*(ccrs - coeff*t2*r1rs)
!     = = = = = = = = = = = = 
      ht = h0t + h1t
      hrs = h0rs + h1rs
      ec1d = h-thrd*rs*hrs-sixth7*t*ht
      ec1dd = 0.5d0*ht/sk
      return
      end
