
!     @(#)pulay.F	1.14 4/29/97 

!=======================================================================
      subroutine pulay(nconso,alpha,deltim,nions,&
           nspec,nionsp,rmass,recc,dirc, &
           natdyn,posion,inudged,grion,rvelo,rmove,&
           npulay,entot,forwrk )
!=======================================================================
!
!
!    update the positions using Pulay mixing : 
! 
!        F     = sum alpha_i * F_i
!         n+1 
!        R     = sum alpha_i R_i  + 1/2 F_i (timestep)^2
!
!               
!=======================================================================
      implicit  none
      integer   nions,nspec,nconso
      integer   nionsp(nspec)
      real*8    rmass(nspec)
      real*8    recc(3,3),dirc(3,3)
      real*8    grion(3,nions*nspec),rvelo(3,nions)
      real*8    posion(3,nions,nspec),rmove(3,nions)
      real*8    deltim,alpha
      real*8    sizgri,sizpos
      integer   npulay
      real*8    entot,forwrk(3,nions)

      integer   npulay_max
      parameter(npulay_max=50) 

      integer   nat,nsp,ni,m
!=======================================================================
!      natdyn: dimension of grad and pos.
!      npulay: max number of old positions used.
!      npulay_max : max dimension for arrays
!=======================================================================
      integer natdyn,imax,ia,n_old,n_last,ndum

      integer ia1,ia2,i1,i2,id1,id2,ill,ind,inudged,i,m2
      integer maxwk(npulay_max+1)
      real*8  grad_old(3,nions,npulay_max),grad_tmp
      real*8  pos_old(3,nions,npulay_max),factor,crite
      real*8  aij(npulay_max+1,npulay_max+2),swk(npulay_max+1)
      real*8  det,eps,dcheck,posdel
      real*8  grad_tmp2
      real*8  tpi,pi 
      data    tpi,pi/6.2831853072d0,3.1415926536d0/
      character*4  tdum
      logical ltp
      real*8  v(3),e(4),s1,s2

      if (npulay.gt.npulay_max) stop 'npulay > 50' 

      factor =  0.05d0
      crite  =  0.5d0
      ltp=.false.

!==================================================================
! read old positions and forces
!==================================================================
      open(21,FILE='./av.tp',STATUS='OLD')
      n_old  = 0
      n_last = 1
 100  continue
      read(21,*,end=200,err=200)
      read(21,*)
      read(21,*)
      if(.not.ltp) then
         read(21,*)
         read(21,*)
         read(21,*)
      endif
      do ia1 = 1,natdyn
         if(ltp) then
            read(21,*) ndum,(pos_old(i,ia1,n_last),i=1,3),&
               v(1),v(2),v(3),&
              (grad_old(i,ia1,n_last),i=1,3),s1,s2,&
              e(1),e(2),e(3),e(4)
         else
            read(21,*) ndum,tdum,(pos_old( i,ia1,n_last),i=1,3),&
               v(1),v(2),v(3),&
              (grad_old(i,ia1,n_last),i=1,3),s1,s2,&
               e(1),e(2),e(3),e(4)
         endif
      enddo
6320  format(i2,      9f12.8,2f3.1,f12.5,3f3.1)
6321  format(i2,1x,a2,9f12.8,2f3.1,f12.5,3f3.1)


      if(.not.ltp) then
         do i=natdyn+1,nions
            read(21,*)
         enddo
         ltp=.true.
      endif

!==================================================================
      do nat=1,nions                                                
         do i=1,3    
            grad_old(i,nat,n_last)=&
                 grad_old(i,nat,n_last)*rmove(i,nat)
         enddo                                       
      enddo    
!==================================================================
      if(inudged.eq.1) then
!
!        grad_old(:,:,n_last) contains the current force; 
!        subtract the component of the force parallel to the 
!        constraint vector
         call bndcnst(grad_old(1,1,n_last),nions,&
                 pos_old(1,1,n_last),dirc,nconso,forwrk )

      endif
!==================================================================
      grad_tmp = 0.d0
      do ia1 = 1,natdyn
         grad_tmp = grad_tmp&
              +grad_old(1,ia1,n_last)**2&
              +grad_old(2,ia1,n_last)**2&
              +grad_old(3,ia1,n_last)**2
      end do
      grad_tmp = dsqrt(grad_tmp)
      n_last = n_last+1
      if(n_last.gt.npulay) n_last = n_last-npulay
      if(n_old .lt.npulay) n_old  = n_old+1
      go to 100

 200  continue
      n_last = n_last-1
!     if(((grad_tmp/dble(natdyn)).gt.crite).and.(n_last.eq.1)) then
!        continue with a steepest descent step
!        n_old = 1
!        write(nconso,*) 'PULAY: steepest descent |FOR|/atom=',
!    &                    grad_tmp/dble(natdyn) 
!     endif
      if(n_last.eq.0)  n_last = npulay
      write(nconso,*) 'PULAY',n_last,n_old
      if(n_old.eq.0) call clexit(nconso)
!==================================================================
! calculate the matrix aij
!==================================================================
      do i2 = 1,n_old
         do i1 = 1,n_old
            aij(i1,i2) = 0.d0
            do ia1 = 1,natdyn
               aij(i1,i2) = aij(i1,i2)&
                    + grad_old(1,ia1,i1)*grad_old(1,ia1,i2)&
                    + grad_old(2,ia1,i1)*grad_old(2,ia1,i2)&
                    + grad_old(3,ia1,i1)*grad_old(3,ia1,i2)
            end do
         end do
      end do
      do i1 = 1,n_old
         aij(i1,n_old+1) = 1.d0
         aij(n_old+1,i1) = 1.d0
      end do
      aij(n_old+1,n_old+1) = 0.d0
      do i1 = 1,n_old
         aij(i1,n_old+2) = 0.d0
      end do
      aij(n_old+1,n_old+2) = 1.d0
!==================================================================
! normalization of the matrix aij
!==================================================================
      call mnormd(aij,npulay_max+1,n_old+1,n_old+2,swk,ill)
!==================================================================
! solve the linear equation
!==================================================================
      det = 0.d0
      eps = 1.d-15
      ind = 0
      call leqlud(aij,npulay_max+1,n_old+1,aij(1,n_old+2),npulay+1&
           ,1,det,maxwk,eps,ind)
!==================================================================
! norm check
!==================================================================
      dcheck = 0.d0
      do i1 = 1,n_old
         dcheck = dcheck + aij(i1,n_old+2)
      end do
      write(nconso,300) dcheck,det,ill,ind
 300  format(' ',' dcheck should be 1.d0 ',2f12.6,i7,i7)

      if (ind.ne.0) then 
        write(nconso,*) 'PULAY : could not find aij'
        do i1 = 1,n_old   
          aij(i1,n_old+2) = 0.0d0
        end do            
          aij(n_last,n_old+2) = 1.0d0
      endif   
 
!==================================================================
! calculate the optimized positions and the optimized forces
! set the velocity from the optimized force, v = F*deltim
!==================================================================
      nat=1
      do nsp=1,nspec
         do ni=1,nionsp(nsp)
            do i1 = 1,3
               rvelo(i1,nat) = 0.d0
               if(nat.le.natdyn) then
                  posion( i1,ni,nsp) = 0.d0
                  do i2 = 1,n_old
                     rvelo(i1,nat) = rvelo(i1,nat)&
                          + aij(i2,n_old+2)*grad_old(i1,nat,i2)* &
                            alpha*deltim
                     posion( i1,ni,nsp) = posion( i1,ni,nsp)&
                          + aij(i2,n_old+2)*pos_old( i1,nat,i2)
                  end do
               endif
            end do
            nat=nat+1
         end do
      enddo
!=======================================================================
!     now add (v * timestep) to the positions
!     Update the ionic positions in a1,a2,a3 coordinates
!
      nat=1
      do nsp=1,nspec
        do ni=1,nionsp(nsp)
          do m=1,3           
             posdel=( recc(m,1)*rvelo(1,nat)&
                     +recc(m,2)*rvelo(2,nat) &
                     +recc(m,3)*rvelo(3,nat))/tpi*deltim
             posion(m,ni,nsp)=posion(m,ni,nsp)+posdel    
          enddo                                       
          nat=nat+1
        enddo       
      enddo


!     calculate the size of the step taken 
      sizpos = 0.0d0
      sizgri = 0.0d0
      nat=1
      do nsp=1,nspec
       do ni=1,nionsp(nsp)
         do m2=1,3          
          if(nat.le.natdyn) then
            do m = 1,3
              sizpos=sizpos+dirc(m,m2)*&
                (posion(m,ni,nsp)-pos_old(m,nat,n_last))**2
            enddo
          endif
          sizgri=sizgri+grad_old(m2,nat,n_last)**2
         enddo                  
        nat=nat+1              
       enddo     
      enddo       

      sizpos=sqrt(sizpos)
      sizgri=sqrt(sizgri)
      write(nconso,2400) sizpos,sizgri,entot
 2400 format(1x,'STEP,FORCE ',2f12.6,1x,f14.4)

      call write_vel(nconso,nions,rvelo)

      return 
      end


      SUBROUTINE LEQLUD(A,KA,N,X,KX,M,D,MAX,EPS,IND)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(KA,N),X(KX,M),MAX(N)
      IF(N.LT.2.OR.N.GT.KA.OR.N.GT.KX.OR.M.LT.0.OR.EPS.LE.0.) GO TO 40
!     IF(D.NE.0.) D=1.      T.Miyazaki  '94.6.3
      IF(abs(D).gt.1.d-30) D=1.d0
      IF(IND.NE.0) GO TO 20
      DO 1 J=1,N
      JM1=J-1
      IF(J.EQ.1) GO TO 12
      DO 2 I=1,JM1
      L=MAX(I)
      S=A(L,J)
      A(L,J)=A(I,J)
      IF(I.EQ.1) GO TO 2
      IM1=I-1
      DO 3 K=1,IM1
    3 S=A(I,K)*A(K,J)+S
    2 A(I,J)=S
      DO 4 I=J,N
      S=A(I,J)
      DO 5 K=1,JM1
    5 S=A(I,K)*A(K,J)+S
    4 A(I,J)=S
   12 AM=0.
      DO 7 I=J,N
      AA=DABS(A(I,J))
      IF(AA.LE.AM) GO TO 7
      AM=AA
      L=I
    7 CONTINUE
      IF(AM.LT.EPS) GO TO 30
      MAX(J)=L
      IF(L.EQ.J) GO TO 14
      DO 6 K=1,J
      W=A(L,K)
      A(L,K)=A(J,K)
    6 A(J,K)=W
      D=-D
   14 D=A(J,J)*D
      IF(J.EQ.N) GO TO 20
      JP1=J+1
      W=-A(J,J)
      DO 1 I=JP1,N
    1 A(I,J)=A(I,J)/W
   20 IF(M.EQ.0) GO TO 27
      DO 21 J=1,M
      DO 22 I=1,N
      L=MAX(I)
      S=X(L,J)
      X(L,J)=X(I,J)
      IF(I.EQ.1) GO TO 22
      IM1=I-1
      DO 23 K=1,IM1
   23 S=A(I,K)*X(K,J)+S
   22 X(I,J)=S
      X(N,J)=X(N,J)/A(N,N)
      I=N
   25 IM1=I-1
      S=-X(IM1,J)
      DO 26 K=I,N
   26 S=A(IM1,K)*X(K,J)+S
      I=IM1
      X(I,J)=-S/A(I,I)
      IF(I.GT.1) GO TO 25
   21 CONTINUE
   27 IND=0
      RETURN
   30 IND=J
      RETURN
   40 IND=30000
      RETURN
      END



      SUBROUTINE MNORMD(A,KA,N,M,S,ILL)
      REAL*8 A(KA,M),S(N),D,AM,F
      IF(N.LT.2.OR.N.GT.KA.OR.N.GT.M) GO TO 20
      F=1.0D0/DLOG(2.0D0)
      DO 1 I=1,N
!     AM=0.
      AM=0.d0
      DO 2 J=1,N
    2 AM=DMAX1(DABS(A(I,J)),AM)
!     IF(AM.EQ.0.) GO TO 10 -- T.Miyazaki '94.6.3
      IF(dabs(AM).lt.1.d-30) GO TO 10 
      NPS=DLOG(AM)*F
      S(I)=2.0D0**NPS
      D=1.D0/S(I)
      DO 1 J=1,M
    1 A(I,J)=D*A(I,J)
      ILL=0
      RETURN
   10 ILL=I
      RETURN
   20 ILL=30000
      RETURN
      END
