!=======================================================================
      subroutine potiid(nconso)
      write(nconso,*) '@(#)potion.F	1.4 6/15/99'
      return
      end
!=======================================================================
      subroutine potion(ngx,ngy,ngz,nions,nionsp,nspec,nplwv,posion,&
           lpctx,lpcty,lpctz,npspts,recc,volc,psp,psgmax,icharg,cvion)
!=======================================================================
! this subroutine calculates the local potential on a realspace grid
!
! output: cvion(r): real space local ionic potential
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension posion(3,nions,nspec)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      dimension recc(3,3)
      dimension psp(npspts,nspec)
      dimension cvion(ngx*ngy*ngz)
      dimension nionsp(nspec)
      dimension psgmax(nspec)
      dimension icharg(nspec)
!=======================================================================
      citpi=(0.0d0,6.2831853072d0)
!=======================================================================
      ng=1
      do 5000 n=1,ngz
         gzx=recc(3,1)*lpctz(n)
         gzy=recc(3,2)*lpctz(n)
         gzz=recc(3,3)*lpctz(n)
         do 4000 nn=1,ngy
            gyx=recc(2,1)*lpcty(nn)
            gyy=recc(2,2)*lpcty(nn)
            gyz=recc(2,3)*lpcty(nn)
            do 3000 nnn=1,ngx
               gxsq=(recc(1,1)*lpctx(nnn)+gyx+gzx)**2
               gysq=(recc(1,2)*lpctx(nnn)+gyy+gzy)**2
               gzsq=(recc(1,3)*lpctx(nnn)+gyz+gzz)**2
               cvion(ng)=(0.0d0,0.0d0)
               do 2000 nsp=1,nspec
                  cstrf=(0.0d0,0.0d0)
                  do 1000 nion=1,nionsp(nsp)
!=======================================================================
! add the contribution to the structure factor from the ion
!=======================================================================
                     gdz=posion(3,nion,nsp)*lpctz(n)
                     gdy=posion(2,nion,nsp)*lpcty(nn)
                     gdx=posion(1,nion,nsp)*lpctx(nnn)
                     cgdr=-citpi*(gdz+gdy+gdx)
                     cstrf=cstrf+exp(cgdr)
 1000             continue
!=======================================================================
! calculate the magnitude of the reciprocal lattice vector (since we are
! using a local pseudopotential the value of the potential depends only
! on the magnitude of g)
!=======================================================================
                  g=sqrt(gxsq+gysq+gzsq)
!=======================================================================
! calculate the formfactor
!=======================================================================

                  call calvps(g,vps,volc,psp(1,nsp),psgmax(nsp),&
                                                     icharg(nsp),npspts)
                  cvion(ng)=cvion(ng)+vps*cstrf
 2000          continue
               ng=ng+1
 3000       continue
 4000    continue
 5000 continue
!=======================================================================
! transform into real space
!=======================================================================
      call fft3d(cvion,ngx,ngy,ngz,1)
      return
      end
