!=======================================================================
      subroutine pbeid(nconso)
      write(nconso,*) '@(#)pbe.F	4.4 3/25/98'
      return
      end
!
!   subroutines generate the generalized gradient approximation for
!       the exchange-correlation energy and potential (J.P. Perdew
!       and Y. Wang, 1991).  they are keyed to the "programmable
!       expressions" in the notes of 1/23/91.
!
! The pw() is called with two flags, lcalvx and lgga:
!
!  lgga   lcalvx  E_LDA  V_LDA  E_GGA  V_GGA  
!   FALSE  TRUE    yes    yes    no     no
!   TRUE   FALSE   yes    no     yes    no
!   TRUE   TRUE    no     no     yes    yes
!
!   if ukfactor > 0 :  PBE96 or revPBE98 functionals
!   if ukfactor= 0  :  RPBE98 functional
!
      subroutine pbe(lgga,lcalvx,&
           nconso,dn,volc,recc,lpctx,lpcty,lpctz,&
           excc,exc,ex,vxc,&
           cwork1,nspin,ngx,ngy,ngz,nplwv,dnlg0,npwxc,ukfactor)
      use stress_module, only : xc_spin_gga_stress

      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      logical*4 lcalvx
      integer nconso,nplwv,nspin
      dimension dn(nplwv,nspin)
      real*8 volc
      dimension recc(3,3)
      dimension lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8 exc
      dimension vxc(nplwv,nspin)
      dimension cwork1(nplwv)
      dimension dnlg0(npwxc,3)
      logical*4 lgga
      integer ngx,ngy,ngz
! work arrays required no matter what lcalvx is
      dimension absnab(nplwv,2)
      dimension cab(nplwv)
      dimension divnab(nplwv)
! work arrays required when lcalvx is TRUE
      dimension dnabln(npwxc,nspin,3)
      dimension df2(npwxc,nspin)
      dimension dfud(npwxc)
!
! locals
!
      real*8 denmin
!
      data pi,thrd,thrd2/3.14159265d0,0.333333333333d0,0.666666666667d0/
      data hartre/27.2116d0/
!
! make sure that negative and very small densities are omitted
!
 
      if (lgga) then
         denmin=0.0d0
         do i=1,nplwv
            if (dn(i,1).le.1.0d-10) then
               denmin = min(denmin,dn(i,1))
!              vxc(i,1)=max(dn(i,2)/100.0d0,1.0d-10)
               vxc(i,1)=1.0d-10
            else
               vxc(i,1)=dn(i,1)
            endif
            if (dn(i,2).le.1.0d-10) then
               denmin = min(denmin,dn(i,2))
!              vxc(i,2)=max(dn(i,1)/100.0d0,1.0d-10)
               vxc(i,2)=1.0d-10
            else
               vxc(i,2)=dn(i,2)
            endif
         enddo
      endif
!
! if lgga: the real space density is in vxc()
!=======================================================================
! 
!=======================================================================
      bohr = 0.529177d0
      angs = 1.0d0/bohr
      rconf = (3.d0*pi**2)**thrd
      rconrs = (3.d0/(4.d0*pi))**thrd
      vol = volc / (bohr**3)
      rinplw=1.0d0/dble(nplwv)

!
! find the density gradient terms
!
      if (lgga.and.lcalvx) then
!
! we have planty of workspaces
!
! loop over spin. n(up)->dn(n,1), n(down)->dn(n,2)
!
         do 1999 ispin=1,2
            do 1500 n=1,nplwv
               cab(n)=vxc(n,ispin)*rinplw
 1500       continue
         call fft3d(cab,ngx,ngy,ngz,-1)
!
! loop over x,y,z to get nabla n(spin) -> dnabln(n,spin,1..3)
! and |nabla n(spin)|^2 -> absnab(n,spin)
!
         do 1504 i=1,3
            do 1506 n=1,nplwv
               cwork1(n)=(0.0d0,1.0d0)*dnlg0(n,i)*cab(n)
 1506       continue
            call fft3d(cwork1,ngx,ngy,ngz,1)
!           For efficiency reasons we sum up according to the value of i /OHN
            if (i.eq. 1 .and. ispin.eq.1) then
              do 1508 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=dble(cwork1(n))**2
 1508         continue
            else if (i.eq. 1 .and. ispin.eq.2) then
              do 1518 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=dble(cwork1(n))**2
 1518         continue
            else if (i.eq. 2 .and. ispin.eq.1) then
              do 1509 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
 1509         continue
            else if (i.eq. 2 .and. ispin.eq.2) then
              do 1519 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
 1519         continue
            else if (i.eq. 3 .and. ispin.eq.1) then
              do 1510 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                absnab(n,ispin)=max (1.0d-20, absnab(n,ispin))
                absnab(n,ispin)=sqrt(absnab(n,ispin))
 1510         continue
            else if (i.eq. 3 .and. ispin.eq.2) then
              do 1520 n=1,nplwv
                dnabln(n,ispin,i)=dble(cwork1(n))
                absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                absnab(n,ispin)=max (1.0d-20, absnab(n,ispin))
                absnab(n,ispin)=sqrt(absnab(n,ispin))
 1520         continue
            endif
 1504    continue
 1999 continue
!=======================================================================
! end of spin-loop
!=======================================================================
!     1 / (|nabla(up)+nabla(down)|**2)
      do 1614 n=1,nplwv
         divnab(n)=(dnabln(n,1,1)+dnabln(n,2,1))**2&
                  +(dnabln(n,1,2)+dnabln(n,2,2))**2&
                  +(dnabln(n,1,3)+dnabln(n,2,3))**2
!        Might omit this truncation ?
         divnab(n) = max (1.0d-10**2, divnab(n))
         divnab(n)=1.0d0 / sqrt(divnab(n))
 1614 continue

      else if (lgga.and..not.lcalvx) then
!
! do the same thing as above, but without workspaces, dnlg0 and dnabln
!
! loop over spin. n(up)->vx(n,1), n(down)->vx(n,2)
!
         do ispin=1,2
            do  n=1,nplwv
               cab(n)=vxc(n,ispin)*rinplw
            enddo
            call fft3d(cab,ngx,ngy,ngz,-1)
!
! loop over x,y,z to get nabla n(spin) -> dnabln(n,spin,1..3)
! and |nabla n(spin)|^2 -> absnab(n,spin)
!
            do i=1,3
               n=1
               do nz=1,ngz
                  g3i=recc(3,i)*lpctz(nz)
                  do ny=1,ngy
                     g2i=recc(2,i)*lpcty(ny)
                     do nx=1,ngx
                        g1i=recc(1,i)*lpctx(nx)
                        cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                        n=n+1
                     enddo
                  enddo
               enddo
               call fft3d(cwork1,ngx,ngy,ngz,1)
! For efficiency reasons we sum up according to the value of i /OHN
               if (i.eq. 1 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=dble(cwork1(n))**2
                  enddo
               else if (i.eq. 1 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=dble(cwork1(n))**2
                  enddo
               else if (i.eq. 2 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                  enddo
               else if (i.eq. 2 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                  enddo
               else if (i.eq. 3 .and. ispin.eq.1) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                     absnab(n,ispin)=sqrt(absnab(n,ispin))
                  enddo
               else if (i.eq. 3 .and. ispin.eq.2) then
                  do n=1,nplwv
                     absnab(n,ispin)=absnab(n,ispin)+dble(cwork1(n))**2
                     absnab(n,ispin)=sqrt(absnab(n,ispin))
                  enddo
               endif
            enddo
         enddo
!
! now calculate:   1 / (|nabla(up)+nabla(down)|**2)
!
         do n=1,nplwv
            cab(n)=(vxc(n,1)+vxc(n,2))*rinplw
         enddo
         call fft3d(cab,ngx,ngy,ngz,-1)
         do i=1,3
            n=1
            do nz=1,ngz
               g3i=recc(3,i)*lpctz(nz)
               do ny=1,ngy
                  g2i=recc(2,i)*lpcty(ny)
                  do nx=1,ngx
                     g1i=recc(1,i)*lpctx(nx)
                     cwork1(n)=(0.0d0,1.0d0)*(g1i+g2i+g3i)*cab(n)
                     n=n+1
                  enddo
               enddo
            enddo
            call fft3d(cwork1,ngx,ngy,ngz,1)
            if (i.eq.1) then
! cwork1: nabla(n(up)+n(down)_x
               do n=1,nplwv
                  divnab(n)=dble(cwork1(n))**2
               enddo
            else if (i.eq.2) then
! cwork1: nabla(n(up)+n(down)_y
               do n=1,nplwv
                  divnab(n)=divnab(n)+dble(cwork1(n))**2
               enddo
            else if (i.eq.3) then
! cwork1: nabla(n(up)+n(down)_z
               do n=1,nplwv
                  divnab(n)=divnab(n)+dble(cwork1(n))**2
! Might omit this truncation ?
                  divnab(n)=max (1.0d-10**2, divnab(n))
                  divnab(n)=1.0d0 / sqrt(divnab(n))
               enddo
            endif
         enddo
      endif

      elo=0.0d0
      enxlda=0.0d0
      enxgga=0.0d0
      enclda=0.0d0
      encgga=0.0d0
      if (lcalvx) then
         enxcc1l=0.0d0
         enxcc1g=0.0d0
      endif
!=====================================================================
! loop over all real space grid points in the super cell
!=====================================================================
      do 9000 n=1,nplwv
!=====================================================================
! exchange
!=====================================================================
!        do 1600 ispin=1,2
! Manually unrolled this loop for VPP-500 vectorization /OHN, 12-Oct-1995
         ispin = 1
            if (lgga) then
               d1=vxc(n,1)
               d2=vxc(n,2)
            else
               d1=max(1.0d-10,dn(n,1))
               d2=max(1.0d-10,dn(n,2))
            endif
            d=2.0d0*d1/vol
            dthrd=exp(thrd*log(d))
            fk=rconf*dthrd
            if (lgga) then
              s=absnab(n,ispin)/(d*vol*fk*angs)
            else
               s = 0.0d0
            endif
            call exchpbe(d,dthrd,s,exlda,exgga,exdlda,exdgga,exdd,&
                         ukfactor)
            enxlda=enxlda+exlda*0.5d0
            enxgga=enxgga+exgga*0.5d0
            if(lcalvx) then
               enxcc1l=enxcc1l-exdlda*d*0.5d0*vol
               enxcc1g=enxcc1g-exdgga*d*0.5d0*vol
               if(lgga) then
                  vxc(n,ispin)=exdgga*hartre
! df2 contains:
!                    d f_x(rho_up,|nabla rho_up|)        1
!                    ---------------------------- x ------------
!                    d |nabla rho_up|               |nabla rho_up|
                  df2(n,ispin)=exdd*hartre/absnab(n,ispin)
               else
                  vxc(n,ispin)=exdlda*hartre
               endif
            endif
         ispin = 2
            d=2.0d0*d2/vol
            dthrd=exp(thrd*log(d))
            fk=rconf*dthrd
            if (lgga) then
              s=absnab(n,ispin)/(d*vol*fk*angs)
            else
               s = 0.0d0
            endif
            call exchpbe(d,dthrd,s,exlda,exgga,exdlda,exdgga,exdd,&
                         ukfactor)
            enxlda=enxlda+exlda*0.5d0
            enxgga=enxgga+exgga*0.5d0
            if(lcalvx) then
               enxcc1l=enxcc1l-exdlda*d*0.5d0*vol
               enxcc1g=enxcc1g-exdgga*d*0.5d0*vol
               if(lgga) then
                  vxc(n,ispin)=exdgga*hartre
! df2 contains:
!                    d f_x(rho_down,|nabla rho_down|)        1
!                    -------------------------------- x ------------
!                    d |nabla rho_down|                 |nabla rho_down|
                  df2(n,ispin)=exdd*hartre/absnab(n,ispin)
               else
                  vxc(n,ispin)=exdlda*hartre
               endif
            endif
!1600    continue
!
! correlation:
!
         d=(d1+d2)/vol
         zet=(d1-d2)/(d*vol)
         rs=rconrs/exp(thrd*log(d)) 
         if (lgga) then
            fk = 1.91915829d0/rs
            sk = dsqrt(4.d0*fk/pi)
            G = (exp(THRD2*log(1.D0+ZET))&
                +exp(THRD2*log(1.D0-ZET)))/2.D0
            t=1.0d0/(divnab(n)*d*vol*2.0d0*sk*g*angs)
         endif
         call corpbe(rs,zet,eclda,vcup,vcdn,g,sk,&
                     t,h,dvcup,dvcdn,ecdd,lgga)

! local correlation

         enclda=enclda+eclda*d
         encgga=encgga+eclda*d
         if(lcalvx) then
            enxcc1l=enxcc1l-vcup*d1-vcdn*d2
            enxcc1g=enxcc1g-vcup*d1-vcdn*d2
            vxc(n,1)=vxc(n,1)+vcup*hartre
            vxc(n,2)=vxc(n,2)+vcdn*hartre
         endif

!  nonlocal correlation:

         if (lgga) then
            encgga=encgga+h*d
            if(lcalvx) then
               enxcc1g=enxcc1g-dvcup*d1-dvcdn*d2
               vxc(n,1)=vxc(n,1)+dvcup*hartre
               vxc(n,2)=vxc(n,2)+dvcdn*hartre
!
! dfud contains:
!                    d f_c(rho_up+rho_down,|nabla(rho_up+rho_down)|)
!                    -----------------------------------------------
!                    d |nabla(rho_up+rho_down)|
!                                                            1
!                                                x ----------------------
!                                                  |nabla(rho_up+rho_down)|
               dfud(n)=ecdd*hartre*divnab(n)
            endif
         endif
!
! store the positive densities in absnab
!
         if (lgga.and.lcalvx) then
            absnab(n,1)=d1
            absnab(n,2)=d2
         endif

! Lieb-Oxford bound:

         if (.not.lcalvx) then
            elo=elo+exp(4.0d0/3.0d0*log(d))
         endif

 9000 continue
!-----------------------------------------------------------------------
! Now it is time to evaluate the spin-polarized version of Eq. (10) in
! White and Bird, Phys. Rev. B 50, 4954 (1994), i.e. the two last terms
! in:
!
!              d f_x(rho_up,|nabla rho_up|)
!  v_xc,up(r)= ----------------------------
!              d rho_up
!
!              d f_c(rho_up+rho_down,|nabla (rho_up+rho_down)|)
!            + ------------------------------------------------
!              d (rho_up+rho_down)
!  
!                    d f_x(rho_up,|nabla rho_up|)   nabla rho_up
!            - nabla ---------------------------- x ------------
!                    d |nabla rho_up|               |nabla rho_up|
!
!                    d f_c(rho_up+rho_down,|nabla(rho_up+rho_down)|)
!            - nabla -----------------------------------------------
!                    d |nabla(rho_up+rho_down)|
!
!                                                  nabla(rho_up+rho_down)
!                                                x ----------------------
!                                                  |nabla(rho_up+rho_down)|
!
      if(lgga.and.lcalvx) then
         enxcc2=0.0d0
         do 7080 ispin=1,nspin
         do 7010 i=1,3
            do 7020 m=1,nplwv
               cwork1(m)=-rinplw*(&
                    df2(m,ispin)*dnabln(m,ispin,i)&
                   +dfud(m)*(dnabln(m,1,i)+dnabln(m,2,i))&
                                 )
 7020       continue
            call fft3d(cwork1,ngx,ngy,ngz,-1)
            if (i .eq. 1) then
              do 7029 m=1,nplwv
                cab(m)=dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7029         continue
            else
              do 7030 m=1,nplwv
                cab(m)=cab(m)+dcmplx(0.0d0,dnlg0(m,i))*cwork1(m)
 7030         continue
            endif
 7010    continue
         call fft3d(cab,ngx,ngy,ngz,1)
            do 7060 m=1,nplwv
               vxc(m,ispin)=vxc(m,ispin)+dble(cab(m))*bohr
               enxcc2=enxcc2-dble(cab(m))*absnab(m,ispin)
 7060       continue
 7080    enddo

!        calculate stress contribution from gradient terms
         call xc_spin_gga_stress(ngx,ngy,ngz,df2,dfud,dnabln,absnab,volc)
      endif
!=======================================================================
      enxlda=enxlda*hartre*vol/nplwv
      enxgga=enxgga*hartre*vol/nplwv
      enclda=enclda*hartre*vol/nplwv
      encgga=encgga*hartre*vol/nplwv
      if (lcalvx) then
         enxcc1l=enxcc1l*hartre/nplwv
         enxcc1g=enxcc1g*hartre/nplwv
         enxcc2=enxcc2*bohr/nplwv
      else
         elo=-1.679d0*elo*hartre*vol/nplwv
      endif
!
      if(lcalvx) then
         if (lgga) then
            exc=enxgga+encgga
            ex =enxgga
            excc=exc+enxcc1g+enxcc2
         else
            exc=enxlda+enclda
            ex =enxlda
            excc=exc+enxcc1l
         endif
      else
         if (lgga) then
            ex=enxgga
            exc=enxgga+encgga
         else
            ex=enxlda
            exc=enxlda+enclda
         endif
         excc=0.0d0
!         write(nconso,2000)ex,exc,elo
 2000    format(1x,'Lieb-Oxford: ',3f13.6)
      endif
!
      if (lgga) then
         if (denmin.lt.0.0d0.and.nconso.ne.0) then
            write(nconso,8000)denmin
         endif
 8000    format(1x,'XCPW: WARNING! Negative densities. Minimum value:',&
              f18.12)
      endif
      return
      end

!---------------------------------------------------------------------
! The P B E
!---------------------------------------------------------------------
!######################################################################
!----------------------------------------------------------------------
      SUBROUTINE EXCHPBE(rho,rhothrd,s,exlda,expbe,exdlda,exd,exdd,&
                         ukfactor)
!----------------------------------------------------------------------
!  PBE EXCHANGE FOR A SPIN-UNPOLARIZED ELECTRONIC SYSTEM
!  K Burke's modification of PW91 codes, May 14, 1996
!  Modified again by K. Burke, June 29, 1996, with simpler Fx(s)
!----------------------------------------------------------------------
!----------------------------------------------------------------------
!  INPUT rho : DENSITY
!  INPUT rhothrd : DENSITY^(1/3)
!  INPUT S:  ABS(GRAD rho)/(2*KF*rho), where kf=(3 pi^2 rho)^(1/3)
!  OUTPUT:  EXCHANGE ENERGY PER ELECTRON (EX) 
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! References:
! [a]J.P.~Perdew, K.~Burke, and M.~Ernzerhof, submiited to PRL, May96
! [b]J.P. Perdew and Y. Wang, Phys. Rev.  B {\bf 33},  8800  (1986);
!     {\bf 40},  3399  (1989) (E).
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! Formulas:
!       e_x[unif]=ax*rho^(4/3)  [LDA]
! ax = -0.75*(3/pi)^(1/3)
!       e_x[PBE]=e_x[unif]*FxPBE(s)
!       FxPBE(s)=1+uk-uk/(1+ul*s*s)                 [a](13)
! uk, ul defined after [a](13) 
!----------------------------------------------------------------------
!----------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter(thrd=1.d0/3.d0,thrd4=4.d0/3.d0)
      parameter(pi=3.14159265358979323846264338327950d0)
      parameter(ax=-0.738558766382022405884230032680836d0)
      parameter(um=0.2195149727645171d0,uk1=0.8040d0,ul1=um/uk1)
!----------------------------------------------------------------------
! construct LDA exchange energy density
      exunif=AX*rhothrd
      exlda=exunif*rho
      exdlda=exunif*thrd4
!----------------------------------------------------------------------
! construct PBE enhancement factor
      S2 = S*S
!----------------------------------------------------------------------
      if (ukfactor.gt.0.1d0) then
! These are the PBE96 and revPBE98 functionals
! scale uk with a factor
         uk = uk1*ukfactor
         ul = ul1/ukfactor 
         P0=1.d0+ul*S2
         FxPBE = 1d0+uk-uk/P0
         expbe = exlda*FxPBE
!----------------------------------------------------------------------
!  ENERGY DONE. NOW THE POTENTIAL:
!  find first derivatives of Fx w.r.t s.
!  Fs=(1/s)*d FxPBE/ ds
         Fs=2.d0*um/(P0*P0)
      elseif (dabs(ukfactor).lt.0.1d0) then  
! This is the RPBE98 functional
         P0=exp(-ul1*S2)
         FxPBE = 1d0+uk1*(1.0d0-P0)
         expbe = exlda*FxPBE
!----------------------------------------------------------------------
!  ENERGY DONE. NOW THE POTENTIAL:
!  find first derivatives of Fx w.r.t s.
!  Fs=(1/s)*d FxPBE/ ds
         Fs=2.d0*um*P0
      else 
! This are the ensemble exchange energies
         Fs = 0.0
         FxPBE = 0.0  ! do not try to calculate potential 
         index = nint(dabs(ukfactor)-7) 
         call exchange_ensemble(s,FxPBE,index)
         expbe = exlda*FxPBE
      endif
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! calculate the partial derivatives of ex wrt n and |grad(n)|
!  0.3232409194=(3*pi^2)^(-1/3)
      exd =exunif*THRD4*(FxPBE-S2*Fs)
      exdd=0.5d0*ax*0.3232409194d0*S*Fs
      RETURN
      END

!----------------------------------------------------------------------
      SUBROUTINE exchange_ensemble(s,Fx,index)
      use run_context
      implicit none
      real*8 s,Fx
      integer index
      real*8 x
!----------------------------------------------------------------------
      x = S/(1.0d0+S)
!----------------------------------------------------------------------
      if (index.eq.0) then
         Fx = 0.0d0
      elseif (index.eq.1) then
         Fx = 1.0d0
      elseif (index.eq.2) then
         Fx = x**2
      elseif (index.eq.3) then
         Fx = x**4
      else
         write(nconso,*) 'Error index out of range in exchange_ensemble'
         call clexit(nconso)
      endif


      RETURN 
      END

!----------------------------------------------------------------------
!######################################################################
!----------------------------------------------------------------------
      SUBROUTINE CORPBE(RS,ZET,EC,VCUP,VCDN,g,sk,&
                        T,H,DVCUP,DVCDN,ecdd,lgga)
!----------------------------------------------------------------------
!  Official PBE correlation code. K. Burke, May 14, 1996.
!  INPUT: RS=SEITZ RADIUS=(3/4pi rho)^(1/3)
!       : ZET=RELATIVE SPIN POLARIZATION = (rhoup-rhodn)/rho
!       : t=ABS(GRAD rho)/(rho*2.*KS*G)  -- only needed for PBE
!       : lgga=flag to do gga (0=>LSD only)
!       : lpot=flag to do potential (0=>energy only)
!  output: ec=lsd correlation energy from [a]
!        : vcup=lsd up correlation potential
!        : vcdn=lsd dn correlation potential
!        : h=NONLOCAL PART OF CORRELATION ENERGY PER ELECTRON
!        : dvcup=nonlocal correction to vcup
!        : dvcdn=nonlocal correction to vcdn
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! References:
! [a] J.P.~Perdew, K.~Burke, and M.~Ernzerhof, 
!     {\sl Generalized gradient approximation made simple}, sub.
!     to Phys. Rev.Lett. May 1996.
! [b] J. P. Perdew, K. Burke, and Y. Wang, {\sl Real-space cutoff
!     construction of a generalized gradient approximation:  The PW91
!     density functional}, submitted to Phys. Rev. B, Feb. 1996.
! [c] J. P. Perdew and Y. Wang, Phys. Rev. B {\bf 45}, 13244 (1992).
!----------------------------------------------------------------------
!----------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
! thrd*=various multiples of 1/3
! numbers for use in LSD energy spin-interpolation formula, [c](9).
!      GAM= 2^(4/3)-2
!      FZZ=f''(0)= 8/(9*GAM)
! numbers for construction of PBE
!      gamma=(1-log(2))/pi^2
!      bet=coefficient in gradient expansion for correlation, [a](4).
!      eta=small number to stop d phi/ dzeta from blowing up at 
!          |zeta|=1.
      logical*4 lgga
      parameter(thrd=1.d0/3.d0,thrdm=-thrd,thrd2=2.d0*thrd)
      parameter(sixthm=thrdm/2.d0)
      parameter(thrd4=4.d0*thrd)
      parameter(GAM=0.5198420997897463295344212145565d0)
      parameter(fzz=8.d0/(9.d0*GAM))
      parameter(gamma=0.03109069086965489503494086371273d0)
      parameter(bet=0.06672455060314922d0,delt=bet/gamma)
!     parameter(eta=1.d-12)
!     parameter(eta=1.d-10)
      parameter(eta=1.d-9)
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! find LSD energy contributions, using [c](10) and Table I[c].
! EU=unpolarized LSD correlation energy
! EURS=dEU/drs
! EP=fully polarized LSD correlation energy
! EPRS=dEP/drs
! ALFM=-spin stiffness, [c](3).
! ALFRSM=-dalpha/drs
! F=spin-scaling factor from [c](9).
! construct ec, using [c](8)
      rtrs=dsqrt(rs)
      CALL gcor2(0.0310907D0,0.21370D0,7.5957D0,3.5876D0,1.6382D0,&
          0.49294D0,rtrs,EU,EURS)
      CALL gcor2(0.01554535D0,0.20548D0,14.1189D0,6.1977D0,3.3662D0,&
          0.62517D0,rtRS,EP,EPRS)
      CALL gcor2(0.0168869D0,0.11125D0,10.357D0,3.6231D0,0.88026D0,&
          0.49671D0,rtRS,ALFM,ALFRSM)
      ALFC = -ALFM
      Z4 = ZET**4
      F=((1.D0+ZET)**THRD4+(1.D0-ZET)**THRD4-2.D0)/GAM
      EC = EU*(1.D0-F*Z4)+EP*F*Z4-ALFM*F*(1.D0-Z4)/FZZ
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! LSD potential from [c](A1)
! ECRS = dEc/drs [c](A2)
! ECZET=dEc/dzeta [c](A3)
! FZ = dF/dzeta [c](A4)
      ECRS = EURS*(1.D0-F*Z4)+EPRS*F*Z4-ALFRSM*F*(1.D0-Z4)/FZZ
      FZ = THRD4*((1.D0+ZET)**THRD-(1.D0-ZET)**THRD)/GAM
      ECZET = 4.D0*(ZET**3)*F*(EP-EU+ALFM/FZZ)+FZ*(Z4*EP-Z4*EU&
              -(1.D0-Z4)*ALFM/FZZ)
      COMM = EC -RS*ECRS/3.D0-ZET*ECZET
      VCUP = COMM + ECZET
      VCDN = COMM - ECZET
      if (.not.lgga) return
!----------------------------------------------------------------------
! PBE correlation energy
! G=phi(zeta), given after [a](3)
! DELT=bet/gamma
! B=A of [a](8)
      G3 = G**3
      PON=-EC/(G3*gamma)
      B = DELT/(DEXP(PON)-1.D0)
      B2 = B*B
      T2 = T*T
      T4 = T2*T2
      RS2 = RS*RS
      RS3 = RS2*RS
      Q4 = 1.D0+B*T2
      Q5 = 1.D0+B*T2+B2*T4
      H = G3*(BET/DELT)*DLOG(1.D0+DELT*Q4*T2/Q5)
!----------------------------------------------------------------------
!----------------------------------------------------------------------
! ENERGY DONE. NOW THE POTENTIAL, using appendix E of [b].
      G4 = G3*G
      T6 = T4*T2
      RSTHRD = RS/3.D0
      GZ=(((1.d0+zet)**2+eta)**sixthm-&
      ((1.d0-zet)**2+eta)**sixthm)/3.d0
      FAC = DELT/B+1.D0
      BG = -3.D0*B2*EC*FAC/(BET*G4)
      BEC = B2*FAC/(BET*G3)
      Q8 = Q5*Q5+DELT*Q4*Q5*T2
      Q9 = 1.D0+2.D0*B*T2
      hB = -BET*G3*B*T6*(2.D0+B*T2)/Q8
      hRS = -RSTHRD*hB*BEC*ECRS
      hZ = 3.D0*GZ*h/G + hB*(BG*GZ+BEC*ECZET)
      hT = 2.d0*BET*G3*Q9/Q8
      COMM = H+HRS-7.0d0*T2*HT/6.D0
      PREF = HZ-GZ*T2*HT/G
      COMM = COMM-PREF*ZET
      DVCUP = COMM + PREF
      DVCDN = COMM - PREF
      ecdd=0.5d0/(sk*g)*t*ht
      RETURN
      END
!----------------------------------------------------------------------
!######################################################################
!----------------------------------------------------------------------
      SUBROUTINE GCOR2(A,A1,B1,B2,B3,B4,rtrs,GG,GGRS)
! slimmed down version of GCOR used in PW91 routines, to interpolate
! LSD correlation energy, as given by (10) of
! J. P. Perdew and Y. Wang, Phys. Rev. B {\bf 45}, 13244 (1992).
! K. Burke, May 11, 1996.
      IMPLICIT REAL*8 (A-H,O-Z)
      Q0 = -2.D0*A*(1.D0+A1*rtrs*rtrs)
      Q1 = 2.D0*A*rtrs*(B1+rtrs*(B2+rtrs*(B3+B4*rtrs)))
      Q2 = DLOG(1.D0+1.D0/Q1)
      GG = Q0*Q2
      Q3 = A*(B1/rtrs+2.D0*B2+rtrs*(3.D0*B3+4.D0*B4*rtrs))
      GGRS = -2.D0*A*A1*Q2-Q0*Q3/(Q1*(1.d0+Q1))
      RETURN
      END
!----------------------------------------------------------------------
!######################################################################
!----------------------------------------------------------------------



