#include  "definitions.h"
!=======================================================================
      subroutine fft3id(nconso)
      write(nconso,*) '@(#)fft3dj.F	1.2 9/24/96'
      return
      end
!=======================================================================
      subroutine fft3d(inp,ngptar,&
                 i1fft,r1fft,r2fft,r3fft,c1fft,c2fft,isign)
!=======================================================================
! Computes the Fourier Transform
!    forward for t_inv=.f.
!    inverse for t_inv=.t.
! of a complex 	 function inp. The Fourier Transform is
! returned in inp in output (the input inp is overwritten).
!=======================================================================
      implicit double precision (a-h,o-z)
      complex*16 inp(*)
      parameter(ndim=3)
      integer ngptar(ndim)
      real*8 r1fft(i1fft,2)
      real*8 r2fft(i1fft*2)
      real*8 r3fft(*)
      complex*16 c1fft
      complex*16 c2fft
      integer isign
!=======================================================================
! Locals
!=======================================================================
      character*1  mode, init
      logical*4 t_first
      data t_first/.true./
      real*8 fac
      integer ifail
      integer n
!=======================================================================
!   INITIALISIERUNG DER FELDER AR UND AI (ZU TRANSFORMIERENDE FOLGE)
!=======================================================================
      do 1000 n=1,i1fft
        r1fft(n,1)=dble(inp(n))
        r1fft(n,2)=imag(inp(n))
 1000 continue
!=======================================================================
!   INITIALISIERUNG DER PARAMETER :
!   ES SOLL EINE 3-D FOURIERTRANSFORMATION DURCHGEFUEHRT WERDEN.
!   DIE DIMENSIONIERUNG SIEHT WIE FOLGT AUS.
!=======================================================================
!      ngptar(1)=ngx
!      ngptar(2)=ngy
!      ngptar(3)=ngz
!=======================================================================
!   AUFTRETENDE FEHLER SOLLEN AUSGEDRUCKT WERDEN :
!=======================================================================
      ifail=-10
!=======================================================================
!   ZUERST SOLLEN NUR DIE FAKTORZERLEGUNG UND DIE ERSTELLUNG
!   DER TRIGONOMETRISCHEN WERTETAFEL BERECHNET WERDEN :
!=======================================================================
      if (t_first) then
        init='t'
        mode='m'
        call fft3dm (r1fft,r1fft(1,2),ndim,ngptar,r2fft,r3fft,mode,init,&
                     ifail)
        t_first=.false.
      endif
!=======================================================================
!   INIT = 'r', DA TRIG-TAFEL UND FAKTORZERLEGUNG SCHON BERECHNET
!   WURDEN, GENUEGT MODE = 'p' oder 'm'.
!=======================================================================
      init='r'
      mode='p'
      if (isign.eq.-1) MODE = 'm'
      call fft3dm (r1fft,r1fft(1,2),ndim,ngptar,r2fft,r3fft,mode,init,&
                   ifail)
!=======================================================================
! 
!=======================================================================
         fac = sqrt(dble(i1fft))
!=======================================================================
!      if (isign.eq.-1) then
!         fac = sqrt(dble(i1fft))
!      else
!         fac = sqrt(1.0/dble(i1fft))
!      endif
!=======================================================================
      do 1200 n=1,i1fft
        inp (n) =   fac * dcmplx (r1fft(n,1),r1fft(n,2))
 1200 continue
      return
      END
