#include  "definitions.h"
      module ewald


! Module for calculating the ewald energy and force due to coulomb energy 
! between the ions. 
! The only public procedure is ewald_energy_and_force and ewalid

! global private data for the module 
      logical, save, private :: init = .true. 

!     number of cells from central cell in real and reciprocal space
      integer, save, private:: maxcx,maxcy,maxcz,maxgpx,maxgpy,maxgpz
      integer, save, private:: ncellx,ncelly,ncellz,ngptx,ngpty,ngptz
      integer, save, private:: ngpts                         
!     interpolation data from the file ewald.dat
      integer newpts
      parameter(newpts = 1000) 
      real*8, save, private :: &
        ewrlen(newpts),ewrcss(newpts),ewrlss(newpts),ewrcsi(newpts)
!     total charge and total charge squared
      integer, save, private:: nionch,nichsq

!   vvvvvv  (machine transcripted by Ewaldtranscriptor      vvvvvv
!            from /home/camp/lhansen/dacapo/data/ewald)   
           
! ========== data segment for Ewald auxillary arrays (begin) ===========

      data ewrlen(   1: 156) /&
       .00000000D+00, .00000000D+00, .00000000D+00, .00000000D+00, &
       .72852280D+02, .54389267D+02, .43311478D+02, .35926300D+02, &
       .30651215D+02, .26694931D+02, .23617844D+02, .21156204D+02, &
       .19142151D+02, .17463821D+02, .16043716D+02, .14826525D+02, &
       .13771647D+02, .12848659D+02, .12034287D+02, .11310432D+02, &
       .10662802D+02, .10079966D+02, .95526667D+01, .90733356D+01, &
       .86357155D+01, .82345934D+01, .78655920D+01, .75250063D+01, &
       .72096786D+01, .69169054D+01, .66443539D+01, .63900032D+01, &
       .61520929D+01, .59290819D+01, .57196178D+01, .55225048D+01, &
       .53366871D+01, .51612225D+01, .49952726D+01, .48380880D+01, &
       .46889944D+01, .45473862D+01, .44127159D+01, .42844887D+01, &
       .41622562D+01, .40456095D+01, .39341784D+01, .38276215D+01, &
       .37256298D+01, .36279182D+01, .35342245D+01, .34443092D+01, &
       .33579493D+01, .32749424D+01, .31950970D+01, .31182384D+01, &
       .30442057D+01, .29728460D+01, .29040213D+01, .28375988D+01, &
       .27734575D+01, .27114849D+01, .26515732D+01, .25936241D+01, &
       .25375443D+01, .24832458D+01, .24306479D+01, .23796740D+01, &
       .23302507D+01, .22823105D+01, .22357883D+01, .21906252D+01, &
       .21467638D+01, .21041498D+01, .20627317D+01, .20224628D+01, &
       .19832964D+01, .19451895D+01, .19081011D+01, .18719921D+01, &
       .18368263D+01, .18025684D+01, .17691851D+01, .17366438D+01, &
       .17049150D+01, .16739702D+01, .16437826D+01, .16143246D+01, &
       .15855713D+01, .15574999D+01, .15300875D+01, .15033121D+01, &
       .14771528D+01, .14515896D+01, .14266043D+01, .14021778D+01, &
       .13782940D+01, .13549337D+01, .13320837D+01, .13097267D+01, &
       .12878485D+01, .12664347D+01, .12454720D+01, .12249479D+01, &
       .12048483D+01, .11851625D+01, .11658783D+01, .11469841D+01, &
       .11284704D+01, .11103249D+01, .10925398D+01, .10751038D+01, &
       .10580072D+01, .10412426D+01, .10248013D+01, .10086737D+01, &
       .99285275D+00, .97732991D+00, .96209800D+00, .94714969D+00, &
       .93247807D+00, .91807628D+00, .90393776D+00, .89005607D+00, &
       .87642515D+00, .86303896D+00, .84989178D+00, .83697808D+00, &
       .82429230D+00, .81182927D+00, .79958391D+00, .78755128D+00, &
       .77572656D+00, .76410514D+00, .75268251D+00, .74145430D+00, &
       .73041630D+00, .71956432D+00, .70889443D+00, .69840264D+00, &
       .68808526D+00, .67793864D+00, .66795909D+00, .65814328D+00, &
       .64848775D+00, .63898921D+00, .62964451D+00, .62045050D+00, &
       .61140418D+00, .60250264D+00, .59374291D+00, .58512229D+00, &
       .57663804D+00, .56828749D+00, .56006807D+00, .55197722D+00/
      data ewrlen( 157: 312) /&
       .54401255D+00, .53617167D+00, .52845216D+00, .52085185D+00, &
       .51336843D+00, .50599980D+00, .49874377D+00, .49159837D+00, &
       .48456156D+00, .47763133D+00, .47080576D+00, .46408302D+00, &
       .45746124D+00, .45093870D+00, .44451356D+00, .43818420D+00, &
       .43194884D+00, .42580593D+00, .41975391D+00, .41379112D+00, &
       .40791607D+00, .40212727D+00, .39642328D+00, .39080262D+00, &
       .38526398D+00, .37980592D+00, .37442708D+00, .36912626D+00, &
       .36390203D+00, .35875326D+00, .35367864D+00, .34867704D+00, &
       .34374720D+00, .33888799D+00, .33409828D+00, .32937700D+00, &
       .32472301D+00, .32013524D+00, .31561261D+00, .31115425D+00, &
       .30675900D+00, .30242592D+00, .29815406D+00, .29394245D+00, &
       .28979015D+00, .28569633D+00, .28165996D+00, .27768028D+00, &
       .27375638D+00, .26988745D+00, .26607257D+00, .26231104D+00, &
       .25860196D+00, .25494462D+00, .25133818D+00, .24778193D+00, &
       .24427515D+00, .24081701D+00, .23740691D+00, .23404408D+00, &
       .23072785D+00, .22745752D+00, .22423244D+00, .22105193D+00, &
       .21791536D+00, .21482205D+00, .21177149D+00, .20876294D+00, &
       .20579588D+00, .20286965D+00, .19998378D+00, .19713753D+00, &
       .19433051D+00, .19156206D+00, .18883163D+00, .18613869D+00, &
       .18348277D+00, .18086332D+00, .17827982D+00, .17573178D+00, &
       .17321867D+00, .17074001D+00, .16829538D+00, .16588426D+00, &
       .16350615D+00, .16116065D+00, .15884733D+00, .15656567D+00, &
       .15431529D+00, .15209574D+00, .14990664D+00, .14774746D+00, &
       .14561790D+00, .14351755D+00, .14144593D+00, .13940275D+00, &
       .13738757D+00, .13540000D+00, .13343972D+00, .13150626D+00, &
       .12959933D+00, .12771857D+00, .12586367D+00, .12403417D+00, &
       .12222975D+00, .12045020D+00, .11869502D+00, .11696398D+00, &
       .11525679D+00, .11357301D+00, .11191237D+00, .11027461D+00, &
       .10865939D+00, .10706645D+00, .10549539D+00, .10394603D+00, &
       .10241807D+00, .10091114D+00, .99425018D-01, .97959399D-01, &
       .96514046D-01, .95088661D-01, .93683064D-01, .92296839D-01, &
       .90929806D-01, .89581788D-01, .88252425D-01, .86941481D-01, &
       .85648715D-01, .84373951D-01, .83116889D-01, .81877351D-01, &
       .80655038D-01, .79449713D-01, .78261256D-01, .77089310D-01, &
       .75933754D-01, .74794352D-01, .73670864D-01, .72563112D-01, &
       .71470857D-01, .70393920D-01, .69332063D-01, .68285108D-01, &
       .67252815D-01, .66235125D-01, .65231681D-01, .64242423D-01, &
       .63267052D-01, .62305506D-01, .61357498D-01, .60422882D-01, &
       .59501488D-01, .58593135D-01, .57697654D-01, .56814875D-01/
      data ewrlen( 313: 468) /&
       .55944625D-01, .55086739D-01, .54241057D-01, .53407416D-01, &
       .52585650D-01, .51775608D-01, .50977129D-01, .50190065D-01, &
       .49414262D-01, .48649568D-01, .47895838D-01, .47152922D-01, &
       .46420678D-01, .45698967D-01, .44987641D-01, .44286568D-01, &
       .43595608D-01, .42914625D-01, .42243488D-01, .41582063D-01, &
       .40930223D-01, .40287837D-01, .39654776D-01, .39030917D-01, &
       .38416140D-01, .37810318D-01, .37213329D-01, .36625061D-01, &
       .36045391D-01, .35474204D-01, .34911387D-01, .34356825D-01, &
       .33810407D-01, .33272024D-01, .32741565D-01, .32218926D-01, &
       .31703994D-01, .31196672D-01, .30696854D-01, .30204434D-01, &
       .29719319D-01, .29241402D-01, .28770588D-01, .28306779D-01, &
       .27849879D-01, .27399797D-01, .26956435D-01, .26519701D-01, &
       .26089508D-01, .25665764D-01, .25248379D-01, .24837267D-01, &
       .24432339D-01, .24033513D-01, .23640703D-01, .23253825D-01, &
       .22872798D-01, .22497542D-01, .22127975D-01, .21764014D-01, &
       .21405589D-01, .21052621D-01, .20705029D-01, .20362742D-01, &
       .20025685D-01, .19693784D-01, .19366968D-01, .19045167D-01, &
       .18728308D-01, .18416319D-01, .18109139D-01, .17806690D-01, &
       .17508917D-01, .17215744D-01, .16927112D-01, .16642950D-01, &
       .16363204D-01, .16087804D-01, .15816692D-01, .15549801D-01, &
       .15287079D-01, .15028462D-01, .14773890D-01, .14523309D-01, &
       .14276661D-01, .14033884D-01, .13794929D-01, .13559740D-01, &
       .13328258D-01, .13100434D-01, .12876216D-01, .12655549D-01, &
       .12438379D-01, .12224663D-01, .12014341D-01, .11807375D-01, &
       .11603706D-01, .11403289D-01, .11206079D-01, .11012029D-01, &
       .10821089D-01, .10633215D-01, .10448363D-01, .10266487D-01, &
       .10087546D-01, .99114925D-02, .97382851D-02, .95678866D-02, &
       .94002485D-02, .92353337D-02, .90731010D-02, .89135095D-02, &
       .87565184D-02, .86020939D-02, .84501952D-02, .83007813D-02, &
       .81538185D-02, .80092698D-02, .78670941D-02, .77272654D-02, &
       .75897388D-02, .74544847D-02, .73214658D-02, .71906522D-02, &
       .70620067D-02, .69354996D-02, .68110935D-02, .66887587D-02, &
       .65684654D-02, .64501800D-02, .63338764D-02, .62195174D-02, &
       .61070770D-02, .59965253D-02, .58878325D-02, .57809725D-02, &
       .56759119D-02, .55726282D-02, .54710880D-02, .53712726D-02, &
       .52731447D-02, .51766895D-02, .50818697D-02, .49886666D-02, &
       .48970543D-02, .48070103D-02, .47185011D-02, .46315119D-02, &
       .45460127D-02, .44619851D-02, .43793991D-02, .42982399D-02, &
       .42184778D-02, .41400939D-02, .40630698D-02, .39873756D-02/
      data ewrlen( 469: 624) /&
       .39129965D-02, .38399131D-02, .37680985D-02, .36975353D-02, &
       .36282034D-02, .35600830D-02, .34931547D-02, .34273991D-02, &
       .33627977D-02, .32993313D-02, .32369820D-02, .31757315D-02, &
       .31155618D-02, .30564556D-02, .29983956D-02, .29413647D-02, &
       .28853458D-02, .28303226D-02, .27762789D-02, .27231984D-02, &
       .26710653D-02, .26198642D-02, .25695795D-02, .25201961D-02, &
       .24716994D-02, .24240743D-02, .23773066D-02, .23313819D-02, &
       .22862861D-02, .22420057D-02, .21985269D-02, .21558364D-02, &
       .21139209D-02, .20727671D-02, .20323629D-02, .19926953D-02, &
       .19537518D-02, .19155203D-02, .18779887D-02, .18411453D-02, &
       .18049784D-02, .17694761D-02, .17346279D-02, .17004220D-02, &
       .16668476D-02, .16338942D-02, .16015507D-02, .15698068D-02, &
       .15386525D-02, .15080774D-02, .14780716D-02, .14486252D-02, &
       .14197286D-02, .13913724D-02, .13635471D-02, .13362435D-02, &
       .13094526D-02, .12831653D-02, .12573730D-02, .12320671D-02, &
       .12072388D-02, .11828800D-02, .11589825D-02, .11355381D-02, &
       .11125386D-02, .10899766D-02, .10678440D-02, .10461335D-02, &
       .10248374D-02, .10039485D-02, .98345941D-03, .96336333D-03, &
       .94365282D-03, .92432136D-03, .90536196D-03, .88676810D-03, &
       .86853327D-03, .85065071D-03, .83311461D-03, .81591820D-03, &
       .79905568D-03, .78252098D-03, .76630805D-03, .75041107D-03, &
       .73482445D-03, .71954238D-03, .70455950D-03, .68987021D-03, &
       .67546917D-03, .66135102D-03, .64751087D-03, .63394359D-03, &
       .62064384D-03, .60760695D-03, .59482781D-03, .58230199D-03, &
       .57002483D-03, .55799144D-03, .54619764D-03, .53463853D-03, &
       .52331015D-03, .51220809D-03, .50132815D-03, .49066590D-03, &
       .48021763D-03, .46997936D-03, .45994692D-03, .45011635D-03, &
       .44048415D-03, .43104659D-03, .42179972D-03, .41274005D-03, &
       .40386408D-03, .39516832D-03, .38664928D-03, .37830370D-03, &
       .37012831D-03, .36211964D-03, .35427487D-03, .34659053D-03, &
       .33906358D-03, .33169123D-03, .32447046D-03, .31739799D-03, &
       .31047151D-03, .30368776D-03, .29704417D-03, .29053795D-03, &
       .28416677D-03, .27792738D-03, .27181790D-03, .26583532D-03, &
       .25997730D-03, .25424128D-03, .24862518D-03, .24312668D-03, &
       .23774309D-03, .23247236D-03, .22731227D-03, .22226061D-03, &
       .21731526D-03, .21247413D-03, .20773514D-03, .20309628D-03, &
       .19855556D-03, .19411102D-03, .18976076D-03, .18550290D-03, &
       .18133558D-03, .17725701D-03, .17326539D-03, .16935900D-03, &
       .16553613D-03, .16179508D-03, .15813422D-03, .15455192D-03/
      data ewrlen( 625: 780) /&
       .15104661D-03, .14761672D-03, .14426073D-03, .14097714D-03, &
       .13776448D-03, .13462130D-03, .13154620D-03, .12853778D-03, &
       .12559468D-03, .12271556D-03, .11989912D-03, .11714408D-03, &
       .11444917D-03, .11181315D-03, .10923480D-03, .10671293D-03, &
       .10424640D-03, .10183406D-03, .99474753D-04, .97167416D-04, &
       .94910938D-04, .92704300D-04, .90546426D-04, .88436325D-04, &
       .86372980D-04, .84355430D-04, .82382699D-04, .80453858D-04, &
       .78567988D-04, .76724173D-04, .74921540D-04, .73159201D-04, &
       .71436327D-04, .69752074D-04, .68105626D-04, .66496170D-04, &
       .64922933D-04, .63385130D-04, .61882034D-04, .60412873D-04, &
       .58976948D-04, .57573532D-04, .56201927D-04, .54861463D-04, &
       .53551470D-04, .52271280D-04, .51020252D-04, .49797774D-04, &
       .48603222D-04, .47435984D-04, .46295463D-04, .45181107D-04, &
       .44092318D-04, .43028558D-04, .41989289D-04, .40973959D-04, &
       .39982042D-04, .39013044D-04, .38066457D-04, .37141785D-04, &
       .36238547D-04, .35356265D-04, .34494500D-04, .33652788D-04, &
       .32830678D-04, .32027761D-04, .31243573D-04, .30477735D-04, &
       .29729825D-04, .28999450D-04, .28286202D-04, .27589733D-04, &
       .26909634D-04, .26245558D-04, .25597139D-04, .24964029D-04, &
       .24345893D-04, .23742396D-04, .23153189D-04, .22577966D-04, &
       .22016393D-04, .21468193D-04, .20933046D-04, .20410647D-04, &
       .19900719D-04, .19402985D-04, .18917155D-04, .18442966D-04, &
       .17980157D-04, .17528451D-04, .17087616D-04, .16657388D-04, &
       .16237522D-04, .15827783D-04, .15427955D-04, .15037800D-04, &
       .14657085D-04, .14285600D-04, .13923132D-04, .13569472D-04, &
       .13224416D-04, .12887765D-04, .12559326D-04, .12238906D-04, &
       .11926318D-04, .11621380D-04, .11323915D-04, .11033747D-04, &
       .10750706D-04, .10474624D-04, .10205340D-04, .99426925D-05, &
       .96865260D-05, .94366887D-05, .91930315D-05, .89554069D-05, &
       .87236740D-05, .84976937D-05, .82773277D-05, .80624450D-05, &
       .78529147D-05, .76486094D-05, .74494046D-05, .72551784D-05, &
       .70658134D-05, .68811923D-05, .67012015D-05, .65257309D-05, &
       .63546713D-05, .61879173D-05, .60253642D-05, .58669129D-05, &
       .57124626D-05, .55619184D-05, .54151851D-05, .52721698D-05, &
       .51327834D-05, .49969376D-05, .48645461D-05, .47355252D-05, &
       .46097930D-05, .44872695D-05, .43678756D-05, .42515358D-05, &
       .41381745D-05, .40277191D-05, .39200986D-05, .38152421D-05, &
       .37130840D-05, .36135552D-05, .35165931D-05, .34221330D-05, &
       .33301139D-05, .32404741D-05, .31531572D-05, .30681031D-05/
      data ewrlen( 781: 936) /&
       .29852563D-05, .29045623D-05, .28259674D-05, .27494189D-05, &
       .26748667D-05, .26022599D-05, .25315503D-05, .24626906D-05, &
       .23956345D-05, .23303355D-05, .22667509D-05, .22048371D-05, &
       .21445521D-05, .20858542D-05, .20287034D-05, .19730614D-05, &
       .19188901D-05, .18661503D-05, .18148085D-05, .17648272D-05, &
       .17161719D-05, .16688091D-05, .16227068D-05, .15778314D-05, &
       .15341529D-05, .14916395D-05, .14502621D-05, .14099905D-05, &
       .13707977D-05, .13326553D-05, .12955361D-05, .12594137D-05, &
       .12242635D-05, .11900593D-05, .11567763D-05, .11243910D-05, &
       .10928816D-05, .10622225D-05, .10323947D-05, .10033746D-05, &
       .97514112D-06, .94767495D-06, .92095513D-06, .89496240D-06, &
       .86967771D-06, .84508264D-06, .82115901D-06, .79788919D-06, &
       .77525601D-06, .75324277D-06, .73183310D-06, .71101101D-06, &
       .69076111D-06, .67106816D-06, .65191750D-06, .63329475D-06, &
       .61518585D-06, .59757718D-06, .58045549D-06, .56380776D-06, &
       .54762137D-06, .53188398D-06, .51658373D-06, .50170877D-06, &
       .48724775D-06, .47318969D-06, .45952362D-06, .44623908D-06, &
       .43332585D-06, .42077392D-06, .40857350D-06, .39671511D-06, &
       .38518954D-06, .37398780D-06, .36310109D-06, .35252089D-06, &
       .34223888D-06, .33224700D-06, .32253723D-06, .31310202D-06, &
       .30393386D-06, .29502542D-06, .28636958D-06, .27795954D-06, &
       .26978847D-06, .26184989D-06, .25413738D-06, .24664473D-06, &
       .23936593D-06, .23229501D-06, .22542633D-06, .21875428D-06, &
       .21227339D-06, .20597844D-06, .19986425D-06, .19392576D-06, &
       .18815820D-06, .18255673D-06, .17711676D-06, .17183385D-06, &
       .16670350D-06, .16172157D-06, .15688391D-06, .15218637D-06, &
       .14762514D-06, .14319642D-06, .13889638D-06, .13472146D-06, &
       .13066818D-06, .12673308D-06, .12291281D-06, .11920423D-06, &
       .11560405D-06, .11210926D-06, .10871690D-06, .10542408D-06, &
       .10222794D-06, .99125771D-07, .96114888D-07, .93192682D-07, &
       .90356593D-07, .87604235D-07, .84933220D-07, .82341160D-07, &
       .79825838D-07, .77385039D-07, .75016601D-07, .72718535D-07, &
       .70488795D-07, .68325335D-07, .66226335D-07, .64189919D-07, &
       .62214212D-07, .60297566D-07, .58438232D-07, .56634523D-07, &
       .54884850D-07, .53187648D-07, .51541388D-07, .49944596D-07, &
       .48395830D-07, .46893689D-07, .45436817D-07, .44023896D-07, &
       .42653635D-07, .41324792D-07, .40036152D-07, .38786538D-07, &
       .37574804D-07, .36399840D-07, .35260562D-07, .34155924D-07, &
       .33084902D-07, .32046508D-07, .31039775D-07, .30063770D-07/
      data ewrlen( 937:1000) /&
       .29117583D-07, .28200333D-07, .27311160D-07, .26449232D-07, &
       .25613737D-07, .24803896D-07, .24018942D-07, .23258128D-07, &
       .22520744D-07, .21806084D-07, .21113468D-07, .20442243D-07, &
       .19791763D-07, .19161405D-07, .18550573D-07, .17958669D-07, &
       .17385133D-07, .16829411D-07, .16290965D-07, .15769270D-07, &
       .15263826D-07, .14774141D-07, .14299733D-07, .13840147D-07, &
       .13394928D-07, .12963643D-07, .12545868D-07, .12141193D-07, &
       .11749218D-07, .11369558D-07, .11001831D-07, .10645682D-07, &
       .10300752D-07, .99666977D-08, .96431876D-08, .93298986D-08, &
       .90265182D-08, .87327372D-08, .84482643D-08, .81728153D-08, &
       .79061095D-08, .76478734D-08, .73978512D-08, .71557906D-08, &
       .69214394D-08, .66945596D-08, .64749273D-08, .62623080D-08, &
       .60564886D-08, .58572596D-08, .56644147D-08, .54777516D-08, &
       .52970819D-08, .51222138D-08, .49529731D-08, .47891788D-08, &
       .46306603D-08, .44772541D-08, .43288004D-08, .41851429D-08, &
       .40461323D-08, .39116195D-08, .37814658D-08, .36555319D-08/
      data ewrcss(   1: 156) /&
       .00000000D+00, .00000000D+00, .00000000D+00, .00000000D+00, &
       .34717222D+04, .19526250D+04, .12495000D+04, .86755566D+03, &
       .63725513D+03, .48778149D+03, .38530273D+03, .31200024D+03, &
       .25776489D+03, .21651445D+03, .18441191D+03, .15893954D+03, &
       .13838979D+03, .12157133D+03, .10763263D+03, .95951904D+02, &
       .86066528D+02, .77626587D+02, .70363434D+02, .64068039D+02, &
       .58575821D+02, .53755768D+02, .49502487D+02, .45730499D+02, &
       .42369843D+02, .39362808D+02, .36661484D+02, .34225800D+02, &
       .32022034D+02, .30021637D+02, .28200378D+02, .26537460D+02, &
       .25015060D+02, .23617798D+02, .22332306D+02, .21147003D+02, &
       .20051727D+02, .19037582D+02, .18096786D+02, .17222397D+02, &
       .16408340D+02, .15649193D+02, .14940111D+02, .14276800D+02, &
       .13655405D+02, .13072472D+02, .12524892D+02, .12009868D+02, &
       .11524871D+02, .11067614D+02, .10636024D+02, .10228219D+02, &
       .98424854D+01, .94772596D+01, .91311169D+01, .88027534D+01, &
       .84909744D+01, .81946821D+01, .79128723D+01, .76446180D+01, &
       .73890648D+01, .71454258D+01, .69129744D+01, .66910381D+01, &
       .64789944D+01, .62762661D+01, .60823164D+01, .58966484D+01, &
       .57187986D+01, .55483379D+01, .53848619D+01, .52279978D+01, &
       .50773954D+01, .49327269D+01, .47936859D+01, .46599884D+01, &
       .45313635D+01, .44075603D+01, .42883425D+01, .41734877D+01, &
       .40627871D+01, .39560452D+01, .38530769D+01, .37537069D+01, &
       .36577721D+01, .35651169D+01, .34755955D+01, .33890686D+01, &
       .33054066D+01, .32244854D+01, .31461878D+01, .30704031D+01, &
       .29970264D+01, .29259586D+01, .28571043D+01, .27903738D+01, &
       .27256823D+01, .26629486D+01, .26020966D+01, .25430517D+01, &
       .24857454D+01, .24301100D+01, .23760843D+01, .23236055D+01, &
       .22726183D+01, .22230673D+01, .21749001D+01, .21280661D+01, &
       .20825186D+01, .20382118D+01, .19951010D+01, .19531460D+01, &
       .19123068D+01, .18725443D+01, .18338223D+01, .17961063D+01, &
       .17593622D+01, .17235584D+01, .16886635D+01, .16546478D+01, &
       .16214838D+01, .15891438D+01, .15576010D+01, .15268316D+01, &
       .14968100D+01, .14675140D+01, .14389210D+01, .14110098D+01, &
       .13837585D+01, .13571491D+01, .13311615D+01, .13057775D+01, &
       .12809792D+01, .12567492D+01, .12330713D+01, .12099304D+01, &
       .11873102D+01, .11651964D+01, .11435738D+01, .11224298D+01, &
       .11017513D+01, .10815248D+01, .10617371D+01, .10423784D+01, &
       .10234356D+01, .10048971D+01, .98675454D+00, .96899486D+00, &
       .95160902D+00, .93458712D+00, .91791981D+00, .90159798D+00/
      data ewrcss( 157: 312) /&
       .88561267D+00, .86995536D+00, .85461777D+00, .83959180D+00, &
       .82486975D+00, .81044400D+00, .79630733D+00, .78245252D+00, &
       .76887274D+00, .75556141D+00, .74251193D+00, .72971809D+00, &
       .71717381D+00, .70487320D+00, .69281048D+00, .68098003D+00, &
       .66937655D+00, .65799475D+00, .64682949D+00, .63587582D+00, &
       .62512892D+00, .61458415D+00, .60423696D+00, .59408283D+00, &
       .58411759D+00, .57433689D+00, .56473684D+00, .55531335D+00, &
       .54606259D+00, .53698081D+00, .52806437D+00, .51930976D+00, &
       .51071346D+00, .50227207D+00, .49398237D+00, .48584116D+00, &
       .47784531D+00, .46999174D+00, .46227753D+00, .45469987D+00, &
       .44725585D+00, .43994272D+00, .43275785D+00, .42569870D+00, &
       .41876262D+00, .41194719D+00, .40524995D+00, .39866859D+00, &
       .39220077D+00, .38584429D+00, .37959689D+00, .37345648D+00, &
       .36742097D+00, .36148828D+00, .35565650D+00, .34992355D+00, &
       .34428769D+00, .33874691D+00, .33329952D+00, .32794368D+00, &
       .32267761D+00, .31749976D+00, .31240833D+00, .30740184D+00, &
       .30247855D+00, .29763705D+00, .29287577D+00, .28819317D+00, &
       .28358793D+00, .27905858D+00, .27460372D+00, .27022201D+00, &
       .26591212D+00, .26167274D+00, .25750262D+00, .25340050D+00, &
       .24936515D+00, .24539548D+00, .24149019D+00, .23764825D+00, &
       .23386848D+00, .23014975D+00, .22649109D+00, .22289133D+00, &
       .21934956D+00, .21586472D+00, .21243584D+00, .20906192D+00, &
       .20574200D+00, .20247519D+00, .19926059D+00, .19609725D+00, &
       .19298434D+00, .18992102D+00, .18690640D+00, .18393970D+00, &
       .18102008D+00, .17814672D+00, .17531896D+00, .17253590D+00, &
       .16979682D+00, .16710109D+00, .16444784D+00, .16183650D+00, &
       .15926629D+00, .15673655D+00, .15424663D+00, .15179586D+00, &
       .14938360D+00, .14700925D+00, .14467216D+00, .14237165D+00, &
       .14010727D+00, .13787836D+00, .13568431D+00, .13352460D+00, &
       .13139868D+00, .12930596D+00, .12724596D+00, .12521815D+00, &
       .12322199D+00, .12125695D+00, .11932260D+00, .11741841D+00, &
       .11554384D+00, .11369854D+00, .11188197D+00, .11009365D+00, &
       .10833323D+00, .10660017D+00, .10489410D+00, .10321456D+00, &
       .10156119D+00, .99933445D-01, .98331094D-01, .96753597D-01, &
       .95200658D-01, .93671858D-01, .92166841D-01, .90685189D-01, &
       .89226544D-01, .87790608D-01, .86376965D-01, .84985316D-01, &
       .83615303D-01, .82266569D-01, .80938756D-01, .79631627D-01, &
       .78344822D-01, .77078044D-01, .75830936D-01, .74603200D-01, &
       .73394597D-01, .72204769D-01, .71033478D-01, .69880366D-01/
      data ewrcss( 313: 468) /&
       .68745255D-01, .67627788D-01, .66527724D-01, .65444827D-01, &
       .64378798D-01, .63329339D-01, .62296320D-01, .61279364D-01, &
       .60278270D-01, .59292801D-01, .58322717D-01, .57367779D-01, &
       .56427762D-01, .55502433D-01, .54591574D-01, .53694960D-01, &
       .52812375D-01, .51943608D-01, .51088449D-01, .50246686D-01, &
       .49418118D-01, .48602547D-01, .47799774D-01, .47009602D-01, &
       .46231844D-01, .45466308D-01, .44712808D-01, .43971166D-01, &
       .43241195D-01, .42522725D-01, .41815579D-01, .41119579D-01, &
       .40434565D-01, .39760366D-01, .39096817D-01, .38443759D-01, &
       .37801027D-01, .37168473D-01, .36545936D-01, .35933267D-01, &
       .35330318D-01, .34736935D-01, .34152977D-01, .33578303D-01, &
       .33012766D-01, .32456230D-01, .31908561D-01, .31369619D-01, &
       .30839276D-01, .30317400D-01, .29803861D-01, .29298533D-01, &
       .28801292D-01, .28312013D-01, .27830575D-01, .27356856D-01, &
       .26890744D-01, .26432123D-01, .25980871D-01, .25536884D-01, &
       .25100049D-01, .24670251D-01, .24247389D-01, .23831356D-01, &
       .23422047D-01, .23019359D-01, .22623189D-01, .22233441D-01, &
       .21850012D-01, .21472808D-01, .21101732D-01, .20736691D-01, &
       .20377591D-01, .20024344D-01, .19676857D-01, .19335043D-01, &
       .18998813D-01, .18668082D-01, .18342763D-01, .18022776D-01, &
       .17708037D-01, .17398469D-01, .17093983D-01, .16794510D-01, &
       .16499966D-01, .16210277D-01, .15925366D-01, .15645165D-01, &
       .15369590D-01, .15098579D-01, .14832057D-01, .14569957D-01, &
       .14312204D-01, .14058735D-01, .13809483D-01, .13564382D-01, &
       .13323367D-01, .13086371D-01, .12853336D-01, .12624197D-01, &
       .12398895D-01, .12177367D-01, .11959556D-01, .11745401D-01, &
       .11534847D-01, .11327837D-01, .11124317D-01, .10924228D-01, &
       .10727514D-01, .10534130D-01, .10344014D-01, .10157123D-01, &
       .99733993D-02, .97927935D-02, .96152611D-02, .94407462D-02, &
       .92692040D-02, .91005899D-02, .89348555D-02, .87719522D-02, &
       .86118355D-02, .84544644D-02, .82997903D-02, .81477724D-02, &
       .79983696D-02, .78515373D-02, .77072345D-02, .75654201D-02, &
       .74260570D-02, .72891004D-02, .71545169D-02, .70222653D-02, &
       .68923086D-02, .67646094D-02, .66391304D-02, .65158382D-02, &
       .63946918D-02, .62756650D-02, .61587133D-02, .60438104D-02, &
       .59309192D-02, .58200061D-02, .57110414D-02, .56039914D-02, &
       .54988265D-02, .53955130D-02, .52940249D-02, .51943287D-02, &
       .50963946D-02, .50001927D-02, .49056970D-02, .48128814D-02, &
       .47217123D-02, .46321638D-02, .45442134D-02, .44578314D-02/
      data ewrcss( 469: 624) /&
       .43729916D-02, .42896643D-02, .42078346D-02, .41274689D-02, &
       .40485449D-02, .39710365D-02, .38949277D-02, .38201865D-02, &
       .37467931D-02, .36747246D-02, .36039588D-02, .35344737D-02, &
       .34662478D-02, .33992599D-02, .33334885D-02, .32689136D-02, &
       .32055145D-02, .31432714D-02, .30821646D-02, .30221746D-02, &
       .29632826D-02, .29054699D-02, .28487176D-02, .27930080D-02, &
       .27383228D-02, .26846449D-02, .26319567D-02, .25802411D-02, &
       .25294817D-02, .24796615D-02, .24307645D-02, .23827748D-02, &
       .23356767D-02, .22894547D-02, .22440935D-02, .21995783D-02, &
       .21558942D-02, .21130266D-02, .20709615D-02, .20296848D-02, &
       .19891828D-02, .19494416D-02, .19104481D-02, .18721891D-02, &
       .18346517D-02, .17978232D-02, .17616909D-02, .17262429D-02, &
       .16914667D-02, .16573507D-02, .16238829D-02, .15910519D-02, &
       .15588466D-02, .15272554D-02, .14962677D-02, .14658726D-02, &
       .14360596D-02, .14068182D-02, .13781381D-02, .13500091D-02, &
       .13224217D-02, .12953661D-02, .12688322D-02, .12428111D-02, &
       .12172933D-02, .11922698D-02, .11677316D-02, .11436697D-02, &
       .11200758D-02, .10969411D-02, .10742573D-02, .10520164D-02, &
       .10302099D-02, .10088303D-02, .98786945D-03, .96731982D-03, &
       .94717368D-03, .92742383D-03, .90806279D-03, .88908337D-03, &
       .87047881D-03, .85224188D-03, .83436607D-03, .81684440D-03, &
       .79967035D-03, .78283739D-03, .76633925D-03, .75016986D-03, &
       .73432294D-03, .71879220D-03, .70357230D-03, .68865693D-03, &
       .67404052D-03, .65971725D-03, .64568198D-03, .63192914D-03, &
       .61845337D-03, .60524931D-03, .59231208D-03, .57963631D-03, &
       .56721736D-03, .55505009D-03, .54312963D-03, .53145178D-03, &
       .52001141D-03, .50880411D-03, .49782544D-03, .48707123D-03, &
       .47653681D-03, .46621822D-03, .45611104D-03, .44621155D-03, &
       .43651555D-03, .42701908D-03, .41771843D-03, .40860963D-03, &
       .39968896D-03, .39095292D-03, .38239779D-03, .37402008D-03, &
       .36581629D-03, .35778317D-03, .34991722D-03, .34221518D-03, &
       .33467403D-03, .32729027D-03, .32006111D-03, .31298352D-03, &
       .30605425D-03, .29927050D-03, .29262924D-03, .28612791D-03, &
       .27976371D-03, .27353386D-03, .26743556D-03, .26146648D-03, &
       .25562360D-03, .24990481D-03, .24430756D-03, .23882934D-03, &
       .23346767D-03, .22822031D-03, .22308495D-03, .21805934D-03, &
       .21314129D-03, .20832859D-03, .20361914D-03, .19901084D-03, &
       .19450166D-03, .19008954D-03, .18577256D-03, .18154876D-03, &
       .17741624D-03, .17337315D-03, .16941766D-03, .16554797D-03/
      data ewrcss( 625: 780) /&
       .16176232D-03, .15805900D-03, .15443632D-03, .15089262D-03, &
       .14742625D-03, .14403564D-03, .14071923D-03, .13747548D-03, &
       .13430287D-03, .13119994D-03, .12816524D-03, .12519734D-03, &
       .12229488D-03, .11945647D-03, .11668078D-03, .11396651D-03, &
       .11131236D-03, .10871707D-03, .10617942D-03, .10369817D-03, &
       .10127218D-03, .98900244D-04, .96581236D-04, .94314048D-04, &
       .92097573D-04, .89930734D-04, .87812485D-04, .85741791D-04, &
       .83717649D-04, .81739068D-04, .79805061D-04, .77914679D-04, &
       .76067008D-04, .74261116D-04, .72496128D-04, .70771144D-04, &
       .69085305D-04, .67437781D-04, .65827742D-04, .64254389D-04, &
       .62716907D-04, .61214538D-04, .59746526D-04, .58312115D-04, &
       .56910561D-04, .55541183D-04, .54203250D-04, .52896095D-04, &
       .51619048D-04, .50371440D-04, .49152630D-04, .47961992D-04, &
       .46798901D-04, .45662746D-04, .44552959D-04, .43468928D-04, &
       .42410116D-04, .41375941D-04, .40365863D-04, .39379360D-04, &
       .38415892D-04, .37474965D-04, .36556070D-04, .35658726D-04, &
       .34782424D-04, .33926728D-04, .33091172D-04, .32275289D-04, &
       .31478645D-04, .30700816D-04, .29941366D-04, .29199888D-04, &
       .28475988D-04, .27769260D-04, .27079310D-04, .26405774D-04, &
       .25748275D-04, .25106434D-04, .24479916D-04, .23868371D-04, &
       .23271452D-04, .22688822D-04, .22120163D-04, .21565153D-04, &
       .21023472D-04, .20494830D-04, .19978921D-04, .19475454D-04, &
       .18984138D-04, .18504710D-04, .18036866D-04, .17580373D-04, &
       .17134938D-04, .16700331D-04, .16276288D-04, .15862563D-04, &
       .15458922D-04, .15065129D-04, .14680953D-04, .14306170D-04, &
       .13940562D-04, .13583915D-04, .13236019D-04, .12896670D-04, &
       .12565667D-04, .12242813D-04, .11927918D-04, .11620794D-04, &
       .11321259D-04, .11029132D-04, .10744239D-04, .10466410D-04, &
       .10195477D-04, .99312756D-05, .96736467D-05, .94224351D-05, &
       .91774864D-05, .89386522D-05, .87057861D-05, .84787471D-05, &
       .82573943D-05, .80415921D-05, .78312078D-05, .76261103D-05, &
       .74261743D-05, .72312741D-05, .70412889D-05, .68560994D-05, &
       .66755920D-05, .64996511D-05, .63281677D-05, .61610326D-05, &
       .59981412D-05, .58393898D-05, .56846784D-05, .55339087D-05, &
       .53869835D-05, .52438099D-05, .51042953D-05, .49683513D-05, &
       .48358897D-05, .47068252D-05, .45810739D-05, .44585549D-05, &
       .43391892D-05, .42228985D-05, .41096064D-05, .39992392D-05, &
       .38917242D-05, .37869922D-05, .36849724D-05, .35855983D-05, &
       .34888044D-05, .33945253D-05, .33027000D-05, .32132666D-05/
      data ewrcss( 781: 936) /&
       .31261652D-05, .30413366D-05, .29587263D-05, .28782761D-05, &
       .27999331D-05, .27236447D-05, .26493590D-05, .25770241D-05, &
       .25065929D-05, .24380170D-05, .23712482D-05, .23062412D-05, &
       .22429522D-05, .21813375D-05, .21213536D-05, .20629604D-05, &
       .20061161D-05, .19507825D-05, .18969204D-05, .18444916D-05, &
       .17934608D-05, .17437915D-05, .16954482D-05, .16483973D-05, &
       .16026070D-05, .15580426D-05, .15146743D-05, .14724701D-05, &
       .14314010D-05, .13914369D-05, .13525487D-05, .13147101D-05, &
       .12778928D-05, .12420714D-05, .12072178D-05, .11733091D-05, &
       .11403199D-05, .11082257D-05, .10770036D-05, .10466310D-05, &
       .10170852D-05, .98834425D-06, .96038821D-06, .93319642D-06, &
       .90674752D-06, .88102269D-06, .85600283D-06, .83166930D-06, &
       .80800407D-06, .78498937D-06, .76260801D-06, .74084323D-06, &
       .71967872D-06, .69909845D-06, .67908695D-06, .65962905D-06, &
       .64071003D-06, .62231550D-06, .60443148D-06, .58704427D-06, &
       .57014063D-06, .55370754D-06, .53773243D-06, .52220298D-06, &
       .50710725D-06, .49243351D-06, .47817042D-06, .46430688D-06, &
       .45083215D-06, .43773565D-06, .42500716D-06, .41263678D-06, &
       .40061474D-06, .38893154D-06, .37757803D-06, .36654529D-06, &
       .35582445D-06, .34540710D-06, .33528488D-06, .32544978D-06, &
       .31589394D-06, .30660971D-06, .29758962D-06, .28882641D-06, &
       .28031303D-06, .27204266D-06, .26400852D-06, .25620415D-06, &
       .24862317D-06, .24125944D-06, .23410695D-06, .22715983D-06, &
       .22041240D-06, .21385915D-06, .20749457D-06, .20131353D-06, &
       .19531086D-06, .18948163D-06, .18382099D-06, .17832417D-06, &
       .17298669D-06, .16780399D-06, .16277176D-06, .15788584D-06, &
       .15314203D-06, .14853640D-06, .14406504D-06, .13972419D-06, &
       .13551011D-06, .13141926D-06, .12744817D-06, .12359345D-06, &
       .11985173D-06, .11621989D-06, .11269475D-06, .10927334D-06, &
       .10595272D-06, .10272993D-06, .99602232D-07, .96566907D-07, &
       .93621338D-07, .90762910D-07, .87989179D-07, .85297643D-07, &
       .82686086D-07, .80152063D-07, .77693414D-07, .75307923D-07, &
       .72993544D-07, .70748229D-07, .68569932D-07, .66456721D-07, &
       .64406720D-07, .62418167D-07, .60489185D-07, .58618088D-07, &
       .56803181D-07, .55042836D-07, .53335466D-07, .51679525D-07, &
       .50073513D-07, .48515975D-07, .47005489D-07, .45540681D-07, &
       .44120210D-07, .42742780D-07, .41407127D-07, .40112017D-07, &
       .38856264D-07, .37638706D-07, .36458221D-07, .35313711D-07, &
       .34204113D-07, .33128398D-07, .32085559D-07, .31074624D-07/
      data ewrcss( 937:1000) /&
       .30094650D-07, .29144712D-07, .28223919D-07, .27331410D-07, &
       .26466331D-07, .25627877D-07, .24815243D-07, .24027663D-07, &
       .23264391D-07, .22524691D-07, .21807864D-07, .21113216D-07, &
       .20440091D-07, .19787837D-07, .19155824D-07, .18543446D-07, &
       .17950111D-07, .17375243D-07, .16818284D-07, .16278694D-07, &
       .15755944D-07, .15249530D-07, .14758950D-07, .14283724D-07, &
       .13823392D-07, .13377495D-07, .12945595D-07, .12527266D-07, &
       .12122090D-07, .11729671D-07, .11349620D-07, .10981552D-07, &
       .10625101D-07, .10279916D-07, .99456479D-08, .96219601D-08, &
       .93085326D-08, .90050420D-08, .87111864D-08, .84266709D-08, &
       .81512006D-08, .78845019D-08, .76263014D-08, .73763360D-08, &
       .71343500D-08, .69000947D-08, .66733321D-08, .64538277D-08, &
       .62413577D-08, .60357017D-08, .58366503D-08, .56439902D-08, &
       .54575295D-08, .52770694D-08, .51024216D-08, .49334083D-08, &
       .47698521D-08, .46115787D-08, .44584212D-08, .43102233D-08, &
       .41668251D-08, .40280774D-08, .38938346D-08, .37639509D-08/
      data ewrlss(   1: 156) /&
       .00000000D+00, .00000000D+00, .00000000D+00, .00000000D+00, &
       .25643106D+06, .10818162D+06, .55388848D+05, .32053590D+05, &
       .20185227D+05, .13522414D+05, .94971250D+04, .69233125D+04, &
       .52015039D+04, .40064077D+04, .31510771D+04, .25228625D+04, &
       .20511184D+04, .16900110D+04, .14089180D+04, .11868501D+04, &
       .10090930D+04, .86512378D+03, .74728125D+03, .64989795D+03, &
       .56871948D+03, .50051099D+03, .44278198D+03, .39359497D+03, &
       .35142651D+03, .31506836D+03, .28355322D+03, .25610083D+03, &
       .23207709D+03, .21096288D+03, .19233083D+03, .17582664D+03, &
       .16115504D+03, .14806857D+03, .13635883D+03, .12584940D+03, &
       .11639038D+03, .10785373D+03, .10012973D+03, .93123932D+02, &
       .86754761D+02, .80951523D+02, .75652740D+02, .70804764D+02, &
       .66360672D+02, .62279251D+02, .58524277D+02, .55063736D+02, &
       .51869324D+02, .48915955D+02, .46181335D+02, .43645554D+02, &
       .41290894D+02, .39101440D+02, .37062988D+02, .35162720D+02, &
       .33389145D+02, .31731873D+02, .30181519D+02, .28729614D+02, &
       .27368469D+02, .26091080D+02, .24891144D+02, .23762848D+02, &
       .22700943D+02, .21700607D+02, .20757462D+02, .19867477D+02, &
       .19026947D+02, .18232498D+02, .17481003D+02, .16769623D+02, &
       .16095703D+02, .15456823D+02, .14850723D+02, .14275336D+02, &
       .13728743D+02, .13209167D+02, .12714960D+02, .12244596D+02, &
       .11796656D+02, .11369821D+02, .10962864D+02, .10574643D+02, &
       .10204095D+02, .98502264D+01, .95121117D+01, .91888847D+01, &
       .88797379D+01, .85839128D+01, .83007030D+01, .80294437D+01, &
       .77695131D+01, .75203276D+01, .72813387D+01, .70520315D+01, &
       .68319235D+01, .66205587D+01, .64175091D+01, .62223701D+01, &
       .60347633D+01, .58543282D+01, .56807289D+01, .55136452D+01, &
       .53527746D+01, .51978340D+01, .50485535D+01, .49046774D+01, &
       .47659655D+01, .46321888D+01, .45031328D+01, .43785896D+01, &
       .42583666D+01, .41422796D+01, .40301523D+01, .39218197D+01, &
       .38171225D+01, .37159109D+01, .36180439D+01, .35233831D+01, &
       .34318008D+01, .33431740D+01, .32573843D+01, .31743221D+01, &
       .30938797D+01, .30159559D+01, .29404535D+01, .28672800D+01, &
       .27963486D+01, .27275743D+01, .26608772D+01, .25961790D+01, &
       .25334072D+01, .24724922D+01, .24133663D+01, .23559647D+01, &
       .23002272D+01, .22460928D+01, .21935072D+01, .21424150D+01, &
       .20927649D+01, .20445070D+01, .19975948D+01, .19519806D+01, &
       .19076214D+01, .18644762D+01, .18225031D+01, .17816639D+01, &
       .17419224D+01, .17032404D+01, .16655865D+01, .16289244D+01/
      data ewrlss( 157: 312) /&
       .15932245D+01, .15584564D+01, .15245886D+01, .14915953D+01, &
       .14594469D+01, .14281187D+01, .13975859D+01, .13678217D+01, &
       .13388052D+01, .13105125D+01, .12829218D+01, .12560129D+01, &
       .12297649D+01, .12041578D+01, .11791744D+01, .11547947D+01, &
       .11310024D+01, .11077795D+01, .10851097D+01, .10629787D+01, &
       .10413694D+01, .10202684D+01, .99966061D+00, .97953236D+00, &
       .95987052D+00, .94066209D+00, .92189467D+00, .90355617D+00, &
       .88563496D+00, .86811978D+00, .85099965D+00, .83426404D+00, &
       .81790268D+00, .80190569D+00, .78626347D+00, .77096671D+00, &
       .75600636D+00, .74137378D+00, .72706038D+00, .71305811D+00, &
       .69935888D+00, .68595505D+00, .67283916D+00, .66000390D+00, &
       .64744228D+00, .63514745D+00, .62311274D+00, .61133182D+00, &
       .59979832D+00, .58850634D+00, .57744980D+00, .56662315D+00, &
       .55602074D+00, .54563725D+00, .53546739D+00, .52550602D+00, &
       .51574832D+00, .50618935D+00, .49682456D+00, .48764926D+00, &
       .47865915D+00, .46984988D+00, .46121728D+00, .45275730D+00, &
       .44446588D+00, .43633932D+00, .42837375D+00, .42056561D+00, &
       .41291130D+00, .40540737D+00, .39805049D+00, .39083737D+00, &
       .38376474D+00, .37682956D+00, .37002885D+00, .36335957D+00, &
       .35681891D+00, .35040402D+00, .34411222D+00, .33794075D+00, &
       .33188719D+00, .32594883D+00, .32012337D+00, .31440824D+00, &
       .30880123D+00, .30330002D+00, .29790235D+00, .29260600D+00, &
       .28740895D+00, .28230911D+00, .27730441D+00, .27239293D+00, &
       .26757270D+00, .26284188D+00, .25819862D+00, .25364107D+00, &
       .24916762D+00, .24477643D+00, .24046588D+00, .23623437D+00, &
       .23208028D+00, .22800207D+00, .22399819D+00, .22006720D+00, &
       .21620762D+00, .21241808D+00, .20869714D+00, .20504344D+00, &
       .20145571D+00, .19793266D+00, .19447297D+00, .19107544D+00, &
       .18773884D+00, .18446207D+00, .18124384D+00, .17808312D+00, &
       .17497879D+00, .17192972D+00, .16893488D+00, .16599327D+00, &
       .16310382D+00, .16026562D+00, .15747762D+00, .15473890D+00, &
       .15204847D+00, .14940554D+00, .14680916D+00, .14425850D+00, &
       .14175260D+00, .13929069D+00, .13687199D+00, .13449568D+00, &
       .13216090D+00, .12986696D+00, .12761313D+00, .12539858D+00, &
       .12322271D+00, .12108469D+00, .11898386D+00, .11691964D+00, &
       .11489123D+00, .11289805D+00, .11093944D+00, .10901475D+00, &
       .10712343D+00, .10526484D+00, .10343844D+00, .10164356D+00, &
       .99879742D-01, .98146319D-01, .96442819D-01, .94768703D-01, &
       .93123376D-01, .91506422D-01, .89917362D-01, .88355541D-01/
      data ewrlss( 313: 468) /&
       .86820662D-01, .85312128D-01, .83829463D-01, .82372308D-01, &
       .80940127D-01, .79532564D-01, .78149140D-01, .76789379D-01, &
       .75452983D-01, .74139416D-01, .72848439D-01, .71579456D-01, &
       .70332289D-01, .69106400D-01, .67901492D-01, .66717207D-01, &
       .65553188D-01, .64409018D-01, .63284457D-01, .62179096D-01, &
       .61092615D-01, .60024697D-01, .58975019D-01, .57943270D-01, &
       .56929145D-01, .55932336D-01, .54952547D-01, .53989489D-01, &
       .53042874D-01, .52112423D-01, .51197857D-01, .50298907D-01, &
       .49415305D-01, .48546795D-01, .47693111D-01, .46854008D-01, &
       .46029232D-01, .45218546D-01, .44421710D-01, .43638483D-01, &
       .42868637D-01, .42111948D-01, .41368194D-01, .40637150D-01, &
       .39918609D-01, .39212350D-01, .38518172D-01, .37835874D-01, &
       .37165247D-01, .36506098D-01, .35858233D-01, .35221465D-01, &
       .34595601D-01, .33980463D-01, .33375867D-01, .32781638D-01, &
       .32197598D-01, .31623580D-01, .31059414D-01, .30504931D-01, &
       .29959973D-01, .29424373D-01, .28897982D-01, .28380644D-01, &
       .27872201D-01, .27372509D-01, .26881419D-01, .26398789D-01, &
       .25924474D-01, .25458332D-01, .25000233D-01, .24550039D-01, &
       .24107616D-01, .23672838D-01, .23245569D-01, .22825688D-01, &
       .22413071D-01, .22007596D-01, .21609142D-01, .21217592D-01, &
       .20832829D-01, .20454742D-01, .20083219D-01, .19718144D-01, &
       .19359417D-01, .19006923D-01, .18660564D-01, .18320233D-01, &
       .17985832D-01, .17657258D-01, .17334417D-01, .17017208D-01, &
       .16705543D-01, .16399320D-01, .16098455D-01, .15802853D-01, &
       .15512429D-01, .15227094D-01, .14946762D-01, .14671348D-01, &
       .14400773D-01, .14134951D-01, .13873804D-01, .13617251D-01, &
       .13365220D-01, .13117630D-01, .12874406D-01, .12635477D-01, &
       .12400769D-01, .12170207D-01, .11943728D-01, .11721257D-01, &
       .11502728D-01, .11288073D-01, .11077233D-01, .10870133D-01, &
       .10666717D-01, .10466922D-01, .10270681D-01, .10077938D-01, &
       .98886341D-02, .97027086D-02, .95201060D-02, .93407705D-02, &
       .91646425D-02, .89916661D-02, .88217966D-02, .86549707D-02, &
       .84911436D-02, .83302595D-02, .81722699D-02, .80171265D-02, &
       .78647770D-02, .77151805D-02, .75682811D-02, .74240379D-02, &
       .72824024D-02, .71433336D-02, .70067830D-02, .68727098D-02, &
       .67410693D-02, .66118240D-02, .64849295D-02, .63603409D-02, &
       .62380284D-02, .61179437D-02, .60000531D-02, .58843158D-02, &
       .57706982D-02, .56591593D-02, .55496655D-02, .54421797D-02, &
       .53366683D-02, .52330978D-02, .51314309D-02, .50316378D-02/
      data ewrlss( 469: 624) /&
       .49336851D-02, .48375390D-02, .47431700D-02, .46505444D-02, &
       .45596361D-02, .44704117D-02, .43828413D-02, .42968988D-02, &
       .42125545D-02, .41297749D-02, .40485412D-02, .39688200D-02, &
       .38905893D-02, .38138181D-02, .37384827D-02, .36645578D-02, &
       .35920180D-02, .35208394D-02, .34509974D-02, .33824684D-02, &
       .33152292D-02, .32492566D-02, .31845281D-02, .31210217D-02, &
       .30587157D-02, .29975881D-02, .29376186D-02, .28787861D-02, &
       .28210699D-02, .27644506D-02, .27089082D-02, .26544232D-02, &
       .26009770D-02, .25485507D-02, .24971259D-02, .24466843D-02, &
       .23972087D-02, .23486812D-02, .23010846D-02, .22544025D-02, &
       .22086177D-02, .21637145D-02, .21196767D-02, .20764882D-02, &
       .20341340D-02, .19925986D-02, .19518672D-02, .19119252D-02, &
       .18727577D-02, .18343511D-02, .17966912D-02, .17597640D-02, &
       .17235568D-02, .16880557D-02, .16532477D-02, .16191206D-02, &
       .15856612D-02, .15528575D-02, .15206973D-02, .14891687D-02, &
       .14582600D-02, .14279597D-02, .13982565D-02, .13691392D-02, &
       .13405969D-02, .13126191D-02, .12851951D-02, .12583146D-02, &
       .12319675D-02, .12061435D-02, .11808330D-02, .11560265D-02, &
       .11317143D-02, .11078874D-02, .10845363D-02, .10616523D-02, &
       .10392265D-02, .10172501D-02, .99571468D-03, .97461208D-03, &
       .95393392D-03, .93367207D-03, .91381883D-03, .89436607D-03, &
       .87530655D-03, .85663260D-03, .83833677D-03, .82041207D-03, &
       .80285105D-03, .78564719D-03, .76879305D-03, .75228256D-03, &
       .73610852D-03, .72026486D-03, .70474506D-03, .68954285D-03, &
       .67465217D-03, .66006696D-03, .64578117D-03, .63178921D-03, &
       .61808503D-03, .60466351D-03, .59151882D-03, .57864562D-03, &
       .56603877D-03, .55369269D-03, .54160273D-03, .52976352D-03, &
       .51817042D-03, .50681853D-03, .49570296D-03, .48481906D-03, &
       .47416240D-03, .46372833D-03, .45351265D-03, .44351118D-03, &
       .43371925D-03, .42413292D-03, .41474798D-03, .40556071D-03, &
       .39656693D-03, .38776291D-03, .37914491D-03, .37070899D-03, &
       .36245165D-03, .35436940D-03, .34645852D-03, .33871573D-03, &
       .33113780D-03, .32372097D-03, .31646225D-03, .30935858D-03, &
       .30240673D-03, .29560341D-03, .28894586D-03, .28243125D-03, &
       .27605635D-03, .26981835D-03, .26371470D-03, .25774259D-03, &
       .25189924D-03, .24618185D-03, .24058847D-03, .23511595D-03, &
       .22976199D-03, .22452421D-03, .21940019D-03, .21438758D-03, &
       .20948410D-03, .20468750D-03, .19999557D-03, .19540614D-03, &
       .19091711D-03, .18652636D-03, .18223189D-03, .17803168D-03/
      data ewrlss( 625: 780) /&
       .17392376D-03, .16990623D-03, .16597718D-03, .16213478D-03, &
       .15837721D-03, .15470271D-03, .15110950D-03, .14759591D-03, &
       .14416027D-03, .14080091D-03, .13751624D-03, .13430469D-03, &
       .13116471D-03, .12809478D-03, .12509341D-03, .12215918D-03, &
       .11929063D-03, .11648639D-03, .11374507D-03, .11106534D-03, &
       .10844589D-03, .10588543D-03, .10338270D-03, .10093645D-03, &
       .98545483D-04, .96208620D-04, .93924667D-04, .91692520D-04, &
       .89511057D-04, .87379172D-04, .85295789D-04, .83259874D-04, &
       .81270395D-04, .79326361D-04, .77426754D-04, .75570628D-04, &
       .73757037D-04, .71985036D-04, .70253751D-04, .68562265D-04, &
       .66909721D-04, .65295259D-04, .63718049D-04, .62177278D-04, &
       .60672144D-04, .59201848D-04, .57765632D-04, .56362755D-04, &
       .54992473D-04, .53654046D-04, .52346804D-04, .51070034D-04, &
       .49823066D-04, .48605230D-04, .47415888D-04, .46254398D-04, &
       .45120149D-04, .44012530D-04, .42930929D-04, .41874780D-04, &
       .40843501D-04, .39836552D-04, .38853381D-04, .37893435D-04, &
       .36956219D-04, .36041194D-04, .35147881D-04, .34275770D-04, &
       .33424396D-04, .32593278D-04, .31781965D-04, .30989992D-04, &
       .30216950D-04, .29462375D-04, .28725874D-04, .28007009D-04, &
       .27305388D-04, .26620619D-04, .25952322D-04, .25300091D-04, &
       .24663590D-04, .24042442D-04, .23436311D-04, .22844819D-04, &
       .22267646D-04, .21704458D-04, .21154934D-04, .20618769D-04, &
       .20095627D-04, .19585234D-04, .19087267D-04, .18601451D-04, &
       .18127510D-04, .17665152D-04, .17214101D-04, .16774124D-04, &
       .16344929D-04, .15926285D-04, .15517930D-04, .15119635D-04, &
       .14731149D-04, .14352250D-04, .13982710D-04, .13622307D-04, &
       .13270826D-04, .12928057D-04, .12593791D-04, .12267828D-04, &
       .11949971D-04, .11640027D-04, .11337806D-04, .11043127D-04, &
       .10755806D-04, .10475671D-04, .10202547D-04, .99362687D-05, &
       .96766698D-05, .94235920D-05, .91768761D-05, .89363712D-05, &
       .87019262D-05, .84733965D-05, .82506367D-05, .80335103D-05, &
       .78218782D-05, .76156093D-05, .74145719D-05, .72186403D-05, &
       .70276892D-05, .68415984D-05, .66602479D-05, .64835231D-05, &
       .63113112D-05, .61435003D-05, .59799841D-05, .58206570D-05, &
       .56654153D-05, .55141600D-05, .53667918D-05, .52232153D-05, &
       .50833369D-05, .49470646D-05, .48143111D-05, .46849873D-05, &
       .45590095D-05, .44362941D-05, .43167602D-05, .42003294D-05, &
       .40869227D-05, .39764664D-05, .38688859D-05, .37641094D-05, &
       .36620668D-05, .35626908D-05, .34659124D-05, .33716688D-05/
      data ewrlss( 781: 936) /&
       .32798944D-05, .31905274D-05, .31035079D-05, .30187766D-05, &
       .29362755D-05, .28559480D-05, .27777387D-05, .27015949D-05, &
       .26274638D-05, .25552945D-05, .24850369D-05, .24166420D-05, &
       .23500634D-05, .22852537D-05, .22221684D-05, .21607630D-05, &
       .21009946D-05, .20428215D-05, .19862018D-05, .19310974D-05, &
       .18774681D-05, .18252758D-05, .17744842D-05, .17250568D-05, &
       .16769582D-05, .16301537D-05, .15846108D-05, .15402966D-05, &
       .14971783D-05, .14552252D-05, .14144080D-05, .13746958D-05, &
       .13360614D-05, .12984747D-05, .12619093D-05, .12263390D-05, &
       .11917364D-05, .11580778D-05, .11253369D-05, .10934909D-05, &
       .10625154D-05, .10323884D-05, .10030863D-05, .97458724D-06, &
       .94687192D-06, .91991780D-06, .89370525D-06, .86821473D-06, &
       .84342696D-06, .81932336D-06, .79588568D-06, .77309625D-06, &
       .75093777D-06, .72939338D-06, .70844669D-06, .68808180D-06, &
       .66828301D-06, .64903520D-06, .63032360D-06, .61213382D-06, &
       .59445182D-06, .57726390D-06, .56055683D-06, .54431752D-06, &
       .52853341D-06, .51319222D-06, .49828191D-06, .48379081D-06, &
       .46970757D-06, .45602116D-06, .44272070D-06, .42979576D-06, &
       .41723604D-06, .40503164D-06, .39317285D-06, .38165024D-06, &
       .37045453D-06, .35957686D-06, .34900847D-06, .33874090D-06, &
       .32876585D-06, .31907530D-06, .30966135D-06, .30051649D-06, &
       .29163317D-06, .28300428D-06, .27462272D-06, .26648161D-06, &
       .25857435D-06, .25089446D-06, .24343552D-06, .23619151D-06, &
       .22915640D-06, .22232433D-06, .21568974D-06, .20924699D-06, &
       .20299080D-06, .19691595D-06, .19101731D-06, .18528993D-06, &
       .17972911D-06, .17433007D-06, .16908825D-06, .16399935D-06, &
       .15905886D-06, .15426275D-06, .14960693D-06, .14508731D-06, &
       .14070019D-06, .13644171D-06, .13230823D-06, .12829628D-06, &
       .12440233D-06, .12062304D-06, .11695511D-06, .11339546D-06, &
       .10994086D-06, .10658846D-06, .10333520D-06, .10017834D-06, &
       .97115048D-07, .94142706D-07, .91258642D-07, .88460354D-07, &
       .85745341D-07, .83111217D-07, .80555651D-07, .78076425D-07, &
       .75671210D-07, .73337958D-07, .71074624D-07, .68879046D-07, &
       .66749351D-07, .64683604D-07, .62679987D-07, .60736625D-07, &
       .58851796D-07, .57023769D-07, .55250901D-07, .53531579D-07, &
       .51864230D-07, .50247341D-07, .48679425D-07, .47159045D-07, &
       .45684811D-07, .44255355D-07, .42869367D-07, .41525560D-07, &
       .40222695D-07, .38959559D-07, .37734978D-07, .36547810D-07, &
       .35396948D-07, .34281317D-07, .33199868D-07, .32151586D-07/
      data ewrlss( 937:1000) /&
       .31135485D-07, .30150606D-07, .29196020D-07, .28270822D-07, &
       .27374135D-07, .26505109D-07, .25662910D-07, .24846738D-07, &
       .24055815D-07, .23289378D-07, .22546693D-07, .21827049D-07, &
       .21129750D-07, .20454124D-07, .19799511D-07, .19165284D-07, &
       .18550825D-07, .17955532D-07, .17378827D-07, .16820152D-07, &
       .16278950D-07, .15754697D-07, .15246876D-07, .14754985D-07, &
       .14278541D-07, .13817072D-07, .13370119D-07, .12937242D-07, &
       .12518012D-07, .12112004D-07, .11718818D-07, .11338059D-07, &
       .10969345D-07, .10612307D-07, .10266589D-07, .99318349D-08, &
       .96077102D-08, .92938883D-08, .89900496D-08, .86958885D-08, &
       .84110994D-08, .81353981D-08, .78684970D-08, .76101259D-08, &
       .73600219D-08, .71179258D-08, .68835888D-08, .66567658D-08, &
       .64372259D-08, .62247452D-08, .60190963D-08, .58200662D-08, &
       .56274523D-08, .54410485D-08, .52606666D-08, .50861111D-08, &
       .49172009D-08, .47537583D-08, .45956092D-08, .44425938D-08, &
       .42945416D-08, .41512997D-08, .40127190D-08, .38786467D-08/
      data ewrcsi(   1: 156) /&
       .00000000D+00, .00000000D+00, .00000000D+00, .00000000D+00, &
       .24112640D+08, .76293940D+07, .31249990D+07, .15070400D+07, &
       .81346288D+06, .47683687D+06, .29768681D+06, .19531225D+06, &
       .13340081D+06, .94189750D+05, .68384063D+05, .50841195D+05, &
       .38579996D+05, .29802070D+05, .23384586D+05, .18605191D+05, &
       .14986781D+05, .12206781D+05, .10042504D+05, .83373164D+04, &
       .69791602D+04, .58866289D+04, .49997500D+04, .42737695D+04, &
       .36749011D+04, .31773423D+04, .27612075D+04, .24110176D+04, &
       .21146204D+04, .18623977D+04, .16466794D+04, .14613052D+04, &
       .13012942D+04, .11625935D+04, .10418865D+04, .93644312D+03, &
       .84400488D+03, .76269360D+03, .69093970D+03, .62742676D+03, &
       .57104419D+03, .52085278D+03, .47605444D+03, .43596851D+03, &
       .40001245D+03, .36768579D+03, .33855811D+03, .31225635D+03, &
       .28845850D+03, .26688330D+03, .24728662D+03, .22945447D+03, &
       .21319962D+03, .19835760D+03, .18478357D+03, .17234975D+03, &
       .16094310D+03, .15046347D+03, .14082191D+03, .13193925D+03, &
       .12374495D+03, .11617598D+03, .10917592D+03, .10269423D+03, &
       .96685532D+02, .91109009D+02, .85927887D+02, .81108994D+02, &
       .76622375D+02, .72440903D+02, .68540024D+02, .64897430D+02, &
       .61492889D+02, .58307968D+02, .55325882D+02, .52531326D+02, &
       .49910339D+02, .47450134D+02, .45139038D+02, .42966309D+02, &
       .40922165D+02, .38997543D+02, .37184189D+02, .35474457D+02, &
       .33861328D+02, .32338333D+02, .30899490D+02, .29539291D+02, &
       .28252625D+02, .27034775D+02, .25881378D+02, .24788391D+02, &
       .23752060D+02, .22768875D+02, .21835632D+02, .20949295D+02, &
       .20107086D+02, .19306381D+02, .18544754D+02, .17819931D+02, &
       .17129822D+02, .16472443D+02, .15845951D+02, .15248615D+02, &
       .14678828D+02, .14135083D+02, .13615964D+02, .13120147D+02, &
       .12646389D+02, .12193524D+02, .11760459D+02, .11346165D+02, &
       .10949675D+02, .10570080D+02, .10206525D+02, .98582058D+01, &
       .95243626D+01, .92042818D+01, .88972893D+01, .86027489D+01, &
       .83200607D+01, .80486584D+01, .77880077D+01, .75376015D+01, &
       .72969618D+01, .70656376D+01, .68431988D+01, .66292419D+01, &
       .64233818D+01, .62252550D+01, .60345163D+01, .58508396D+01, &
       .56739130D+01, .55034437D+01, .53391514D+01, .51807709D+01, &
       .50280495D+01, .48807468D+01, .47386351D+01, .46014977D+01, &
       .44691277D+01, .43413296D+01, .42179146D+01, .40987053D+01, &
       .39835329D+01, .38722334D+01, .37646542D+01, .36606464D+01, &
       .35600719D+01, .34627934D+01, .33686857D+01, .32776251D+01/
      data ewrcsi( 157: 312) /&
       .31894951D+01, .31041842D+01, .30215864D+01, .29415979D+01, &
       .28641224D+01, .27890663D+01, .27163410D+01, .26458607D+01, &
       .25775423D+01, .25113087D+01, .24470844D+01, .23847980D+01, &
       .23243790D+01, .22657633D+01, .22088861D+01, .21536875D+01, &
       .21001081D+01, .20480928D+01, .19975872D+01, .19485397D+01, &
       .19009018D+01, .18546247D+01, .18096628D+01, .17659731D+01, &
       .17235117D+01, .16822395D+01, .16421165D+01, .16031055D+01, &
       .15651703D+01, .15282755D+01, .14923887D+01, .14574776D+01, &
       .14235096D+01, .13904562D+01, .13582888D+01, .13269787D+01, &
       .12964993D+01, .12668257D+01, .12379313D+01, .12097940D+01, &
       .11823902D+01, .11556969D+01, .11296930D+01, .11043577D+01, &
       .10796709D+01, .10556145D+01, .10321674D+01, .10093136D+01, &
       .98703563D+00, .96531540D+00, .94413722D+00, .92348552D+00, &
       .90334511D+00, .88370126D+00, .86453980D+00, .84584707D+00, &
       .82760972D+00, .80981505D+00, .79245049D+00, .77550417D+00, &
       .75896436D+00, .74281991D+00, .72705984D+00, .71167362D+00, &
       .69665116D+00, .68198240D+00, .66765791D+00, .65366834D+00, &
       .64000469D+00, .62665832D+00, .61362070D+00, .60088366D+00, &
       .58843935D+00, .57628006D+00, .56439823D+00, .55278671D+00, &
       .54143852D+00, .53034675D+00, .51950490D+00, .50890648D+00, &
       .49854529D+00, .48841536D+00, .47851074D+00, .46882582D+00, &
       .45935500D+00, .45009297D+00, .44103450D+00, .43217456D+00, &
       .42350817D+00, .41503066D+00, .40673727D+00, .39862353D+00, &
       .39068508D+00, .38291764D+00, .37531710D+00, .36787939D+00, &
       .36060065D+00, .35347700D+00, .34650481D+00, .33968037D+00, &
       .33300030D+00, .32646108D+00, .32005948D+00, .31379229D+00, &
       .30765623D+00, .30164838D+00, .29576570D+00, .29000527D+00, &
       .28436428D+00, .27884007D+00, .27342987D+00, .26813108D+00, &
       .26294118D+00, .25785774D+00, .25287825D+00, .24800044D+00, &
       .24322206D+00, .23854077D+00, .23395449D+00, .22946101D+00, &
       .22505838D+00, .22074449D+00, .21651745D+00, .21237528D+00, &
       .20831621D+00, .20433831D+00, .20043987D+00, .19661921D+00, &
       .19287455D+00, .18920422D+00, .18560672D+00, .18208045D+00, &
       .17862386D+00, .17523539D+00, .17191374D+00, .16865736D+00, &
       .16546488D+00, .16233504D+00, .15926641D+00, .15625769D+00, &
       .15330774D+00, .15041518D+00, .14757895D+00, .14479780D+00, &
       .14207053D+00, .13939613D+00, .13677341D+00, .13420141D+00, &
       .13167894D+00, .12920511D+00, .12677884D+00, .12439924D+00, &
       .12206525D+00, .11977601D+00, .11753058D+00, .11532807D+00/
      data ewrcsi( 313: 468) /&
       .11316764D+00, .11104846D+00, .10896963D+00, .10693032D+00, &
       .10492980D+00, .10296732D+00, .10104203D+00, .99153221D-01, &
       .97300231D-01, .95482230D-01, .93698621D-01, .91948628D-01, &
       .90231717D-01, .88547111D-01, .86894274D-01, .85272491D-01, &
       .83681166D-01, .82119763D-01, .80587685D-01, .79084277D-01, &
       .77609062D-01, .76161504D-01, .74740946D-01, .73347032D-01, &
       .71979105D-01, .70636749D-01, .69319427D-01, .68026662D-01, &
       .66757977D-01, .65512955D-01, .64291060D-01, .63091874D-01, &
       .61915074D-01, .60760085D-01, .59626546D-01, .58514047D-01, &
       .57422191D-01, .56350581D-01, .55298831D-01, .54266568D-01, &
       .53253427D-01, .52259035D-01, .51283050D-01, .50325118D-01, &
       .49384896D-01, .48462056D-01, .47556251D-01, .46667218D-01, &
       .45794584D-01, .44938061D-01, .44097349D-01, .43272149D-01, &
       .42462174D-01, .41667137D-01, .40886763D-01, .40120777D-01, &
       .39368909D-01, .38630903D-01, .37906494D-01, .37195433D-01, &
       .36497474D-01, .35812370D-01, .35139885D-01, .34479789D-01, &
       .33831850D-01, .33195838D-01, .32571543D-01, .31958744D-01, &
       .31357225D-01, .30766785D-01, .30187219D-01, .29618323D-01, &
       .29059902D-01, .28511770D-01, .27973726D-01, .27445596D-01, &
       .26927195D-01, .26418339D-01, .25918864D-01, .25428586D-01, &
       .24947345D-01, .24474975D-01, .24011310D-01, .23556195D-01, &
       .23109470D-01, .22670984D-01, .22240587D-01, .21818131D-01, &
       .21403469D-01, .20996463D-01, .20596970D-01, .20204857D-01, &
       .19819986D-01, .19442223D-01, .19071445D-01, .18707521D-01, &
       .18350326D-01, .17999738D-01, .17655637D-01, .17317906D-01, &
       .16986430D-01, .16661093D-01, .16341783D-01, .16028393D-01, &
       .15720814D-01, .15418943D-01, .15122671D-01, .14831901D-01, &
       .14546528D-01, .14266461D-01, .13991598D-01, .13721846D-01, &
       .13457112D-01, .13197307D-01, .12942340D-01, .12692124D-01, &
       .12446567D-01, .12205593D-01, .11969116D-01, .11737052D-01, &
       .11509322D-01, .11285845D-01, .11066549D-01, .10851353D-01, &
       .10640189D-01, .10432974D-01, .10229643D-01, .10030124D-01, &
       .98343492D-02, .96422471D-02, .94537511D-02, .92687979D-02, &
       .90873241D-02, .89092627D-02, .87345541D-02, .85631348D-02, &
       .83949454D-02, .82299300D-02, .80680288D-02, .79091825D-02, &
       .77533387D-02, .76004416D-02, .74504390D-02, .73032752D-02, &
       .71589015D-02, .70172623D-02, .68783127D-02, .67419969D-02, &
       .66082738D-02, .64770952D-02, .63484088D-02, .62221736D-02, &
       .60983449D-02, .59768744D-02, .58577210D-02, .57408474D-02/
      data ewrcsi( 469: 624) /&
       .56262016D-02, .55137537D-02, .54034516D-02, .52952655D-02, &
       .51891543D-02, .50850771D-02, .49829967D-02, .48828796D-02, &
       .47846846D-02, .46883784D-02, .45939311D-02, .45012981D-02, &
       .44104569D-02, .43213665D-02, .42339973D-02, .41483194D-02, &
       .40642954D-02, .39818995D-02, .39011051D-02, .38218745D-02, &
       .37441822D-02, .36679995D-02, .35932981D-02, .35200508D-02, &
       .34482302D-02, .33778099D-02, .33087637D-02, .32410661D-02, &
       .31746917D-02, .31096158D-02, .30458141D-02, .29832630D-02, &
       .29219387D-02, .28618185D-02, .28028795D-02, .27451001D-02, &
       .26884577D-02, .26329316D-02, .25785004D-02, .25251438D-02, &
       .24728412D-02, .24215730D-02, .23713196D-02, .23220617D-02, &
       .22737805D-02, .22264577D-02, .21800750D-02, .21346146D-02, &
       .20900592D-02, .20463914D-02, .20035943D-02, .19616515D-02, &
       .19205466D-02, .18802637D-02, .18407872D-02, .18021017D-02, &
       .17641920D-02, .17270432D-02, .16906410D-02, .16549709D-02, &
       .16200191D-02, .15857713D-02, .15522146D-02, .15193354D-02, &
       .14871208D-02, .14555580D-02, .14246341D-02, .13943373D-02, &
       .13646551D-02, .13355759D-02, .13070880D-02, .12791797D-02, &
       .12518398D-02, .12250578D-02, .11988222D-02, .11731226D-02, &
       .11479489D-02, .11232905D-02, .10991374D-02, .10754799D-02, &
       .10523081D-02, .10296127D-02, .10073844D-02, .98561379D-03, &
       .96429233D-03, .94341068D-03, .92296069D-03, .90293353D-03, &
       .88332104D-03, .86411508D-03, .84530772D-03, .82689081D-03, &
       .80885668D-03, .79119811D-03, .77390717D-03, .75697689D-03, &
       .74040005D-03, .72416966D-03, .70827873D-03, .69272076D-03, &
       .67748874D-03, .66257641D-03, .64797746D-03, .63368538D-03, &
       .61969412D-03, .60599786D-03, .59259054D-03, .57946611D-03, &
       .56661945D-03, .55404450D-03, .54173591D-03, .52968832D-03, &
       .51789638D-03, .50635519D-03, .49505965D-03, .48400462D-03, &
       .47318521D-03, .46259677D-03, .45223441D-03, .44209370D-03, &
       .43217023D-03, .42245956D-03, .41295704D-03, .40365872D-03, &
       .39456016D-03, .38565765D-03, .37694699D-03, .36842399D-03, &
       .36008540D-03, .35192678D-03, .34394488D-03, .33613597D-03, &
       .32849610D-03, .32102247D-03, .31371112D-03, .30655880D-03, &
       .29956223D-03, .29271841D-03, .28602383D-03, .27947570D-03, &
       .27307076D-03, .26680599D-03, .26067859D-03, .25468576D-03, &
       .24882448D-03, .24309231D-03, .23748622D-03, .23200372D-03, &
       .22664218D-03, .22139910D-03, .21627196D-03, .21125833D-03, &
       .20635582D-03, .20156207D-03, .19687481D-03, .19229177D-03/
      data ewrcsi( 625: 780) /&
       .18781074D-03, .18342957D-03, .17914614D-03, .17495836D-03, &
       .17086421D-03, .16686170D-03, .16294885D-03, .15912380D-03, &
       .15538461D-03, .15172949D-03, .14815661D-03, .14466424D-03, &
       .14125062D-03, .13791407D-03, .13465295D-03, .13146561D-03, &
       .12835047D-03, .12530597D-03, .12233059D-03, .11942282D-03, &
       .11658123D-03, .11380434D-03, .11109078D-03, .10843914D-03, &
       .10584810D-03, .10331634D-03, .10084256D-03, .98425488D-04, &
       .96063901D-04, .93756578D-04, .91502312D-04, .89299967D-04, &
       .87148394D-04, .85046457D-04, .82993094D-04, .80987214D-04, &
       .79027785D-04, .77113771D-04, .75244170D-04, .73418007D-04, &
       .71634306D-04, .69892121D-04, .68190551D-04, .66528679D-04, &
       .64905616D-04, .63320505D-04, .61772516D-04, .60260791D-04, &
       .58784528D-04, .57342942D-04, .55935234D-04, .54560674D-04, &
       .53218508D-04, .51907991D-04, .50628412D-04, .49379101D-04, &
       .48159345D-04, .46968489D-04, .45805878D-04, .44670873D-04, &
       .43562846D-04, .42481173D-04, .41425286D-04, .40394574D-04, &
       .39388455D-04, .38406390D-04, .37447826D-04, .36512225D-04, &
       .35599049D-04, .34707802D-04, .33837961D-04, .32989046D-04, &
       .32160577D-04, .31352087D-04, .30563111D-04, .29793184D-04, &
       .29041898D-04, .28308787D-04, .27593458D-04, .26895475D-04, &
       .26214460D-04, .25550005D-04, .24901732D-04, .24269248D-04, &
       .23652203D-04, .23050219D-04, .22462962D-04, .21890082D-04, &
       .21331245D-04, .20786116D-04, .20254360D-04, .19735686D-04, &
       .19229774D-04, .18736333D-04, .18255058D-04, .17785671D-04, &
       .17327882D-04, .16881429D-04, .16446022D-04, .16021426D-04, &
       .15607351D-04, .15203590D-04, .14809862D-04, .14425941D-04, &
       .14051591D-04, .13686585D-04, .13330698D-04, .12983714D-04, &
       .12645417D-04, .12315601D-04, .11994061D-04, .11680598D-04, &
       .11375017D-04, .11077130D-04, .10786750D-04, .10503695D-04, &
       .10227790D-04, .99588597D-05, .96967360D-05, .94412544D-05, &
       .91922520D-05, .89495716D-05, .87130602D-05, .84825670D-05, &
       .82579454D-05, .80390510D-05, .78257444D-05, .76178885D-05, &
       .74153504D-05, .72179982D-05, .70257056D-05, .68383479D-05, &
       .66558032D-05, .64779533D-05, .63046828D-05, .61358769D-05, &
       .59714266D-05, .58112237D-05, .56551617D-05, .55031396D-05, &
       .53550566D-05, .52108144D-05, .50703165D-05, .49334712D-05, &
       .48001857D-05, .46703726D-05, .45439438D-05, .44208145D-05, &
       .43009031D-05, .41841286D-05, .40704108D-05, .39596744D-05, &
       .38518428D-05, .37468444D-05, .36446063D-05, .35450594D-05/
      data ewrcsi( 781: 936) /&
       .34481363D-05, .33537690D-05, .32618937D-05, .31724467D-05, &
       .30853662D-05, .30005931D-05, .29180674D-05, .28377317D-05, &
       .27595315D-05, .26834105D-05, .26093167D-05, .25371983D-05, &
       .24670035D-05, .23986840D-05, .23321909D-05, .22674776D-05, &
       .22044987D-05, .21432079D-05, .20835632D-05, .20255220D-05, &
       .19690424D-05, .19140834D-05, .18606061D-05, .18085721D-05, &
       .17579441D-05, .17086850D-05, .16607601D-05, .16141330D-05, &
       .15687719D-05, .15246414D-05, .14817115D-05, .14399493D-05, &
       .13993249D-05, .13598083D-05, .13213703D-05, .12839828D-05, &
       .12476175D-05, .12122482D-05, .11778484D-05, .11443917D-05, &
       .11118545D-05, .10802114D-05, .10494396D-05, .10195154D-05, &
       .99041608D-06, .96212079D-06, .93460733D-06, .90785454D-06, &
       .88184248D-06, .85655148D-06, .83196215D-06, .80805574D-06, &
       .78481401D-06, .76221914D-06, .74025371D-06, .71890082D-06, &
       .69814399D-06, .67796719D-06, .65835474D-06, .63929144D-06, &
       .62076248D-06, .60275335D-06, .58525001D-06, .56823876D-06, &
       .55170619D-06, .53563940D-06, .52002559D-06, .50485255D-06, &
       .49010822D-06, .47578089D-06, .46185914D-06, .44833200D-06, &
       .43518855D-06, .42241840D-06, .41001118D-06, .39795702D-06, &
       .38624614D-06, .37486916D-06, .36381692D-06, .35308034D-06, &
       .34265082D-06, .33251979D-06, .32267906D-06, .31312061D-06, &
       .30383654D-06, .29481930D-06, .28606144D-06, .27755573D-06, &
       .26929524D-06, .26127304D-06, .25348254D-06, .24591725D-06, &
       .23857092D-06, .23143735D-06, .22451064D-06, .21778493D-06, &
       .21125464D-06, .20491422D-06, .19875841D-06, .19278195D-06, &
       .18697978D-06, .18134705D-06, .17587888D-06, .17057073D-06, &
       .16541793D-06, .16041622D-06, .15556122D-06, .15084879D-06, &
       .14627489D-06, .14183559D-06, .13752702D-06, .13334545D-06, &
       .12928734D-06, .12534906D-06, .12152725D-06, .11781850D-06, &
       .11421969D-06, .11072757D-06, .10733908D-06, .10405131D-06, &
       .10086126D-06, .97766190D-07, .94763379D-07, .91850154D-07, &
       .89023843D-07, .86282000D-07, .83622183D-07, .81042003D-07, &
       .78539188D-07, .76111405D-07, .73756553D-07, .71472471D-07, &
       .69257112D-07, .67108431D-07, .65024551D-07, .63003540D-07, &
       .61043579D-07, .59142895D-07, .57299683D-07, .55512299D-07, &
       .53779100D-07, .52098500D-07, .50468941D-07, .48888928D-07, &
       .47356998D-07, .45871733D-07, .44431751D-07, .43035715D-07, &
       .41682327D-07, .40370317D-07, .39098463D-07, .37865572D-07, &
       .36670485D-07, .35512080D-07, .34389259D-07, .33300967D-07/
      data ewrcsi( 937:1000) /&
       .32246174D-07, .31223873D-07, .30233096D-07, .29272904D-07, &
       .28342374D-07, .27440620D-07, .26566781D-07, .25720013D-07, &
       .24899506D-07, .24104466D-07, .23334124D-07, .22587741D-07, &
       .21864594D-07, .21163974D-07, .20485203D-07, .19827617D-07, &
       .19190580D-07, .18573463D-07, .17975662D-07, .17396591D-07, &
       .16835681D-07, .16292375D-07, .15766140D-07, .15256450D-07, &
       .14762808D-07, .14284716D-07, .13821698D-07, .13373295D-07, &
       .12939058D-07, .12518555D-07, .12111357D-07, .11717063D-07, &
       .11335271D-07, .10965593D-07, .10607661D-07, .10261108D-07, &
       .99255857D-08, .96007504D-08, .92862713D-08, .89818286D-08, &
       .86871133D-08, .84018161D-08, .81256495D-08, .78583291D-08, &
       .75995814D-08, .73491329D-08, .71067277D-08, .68721171D-08, &
       .66450525D-08, .64253030D-08, .62126340D-08, .60068288D-08, &
       .58076672D-08, .56149467D-08, .54284577D-08, .52480083D-08, &
       .50734066D-08, .49044679D-08, .47410147D-08, .45828727D-08, &
       .44298751D-08, .42818584D-08, .41386663D-08, .40001424D-08/

! ========== data segment for Ewald auxillary arrays (end)   ===========


! ######################################################################
      contains 
! ######################################################################

!=======================================================================
      subroutine ewald_energy_and_force(&
         dirc,recc,volc,nspec,nions,nionsp,posion,icharc, &
         ewald_energy, ewald_force, nconso  )
!=======================================================================
!     ewald_energy_and_force is the only public subroutine for the 
!     ewald module. 
!     Ewald energy and force due to coulomb energy between the ions.                                                         
!     input: 
!         dirc  : unitcell
!         recc  : reciprocal lattice unitcell
!         volc  : volume
!         nspec,nions,nionsp,posion : number and position of atoms
!         icharc : the charge on the ions
!     output: 
!         ewald_energy   
!         ewald_force
!     
!=======================================================================
      implicit none

      real*8 dirc(3,3),recc(3,3),volc
      integer nspec,nions,nionsp(nspec) 
      real*8  posion(3,nions,nspec)
      integer icharc(nions)
      real*8  ewald_energy, ewald_force(3,nions,nspec)
      integer nconso

!     locals
      real*8  posic(3,nions),ewifc(3,nions)
      integer nindx,nsp,m,ni
      
!=======================================================================

!     init global data for the module 
      if (init) then 
         call initialize(dirc,nspec,nions,nionsp,icharc,nconso)
      endif 

      nindx=1
      do 3190 nsp=1,nspec
        do 3191 ni=1,nionsp(nsp)
          do 3192 m=1,3
            posic(m,nindx)=posion(m,ni,nsp)
 3192     continue
          nindx=nindx+1
 3191   continue
 3190 continue

      call ewaltr(nions,nions,posic,&
           dirc,recc,volc,icharc,ewald_energy,ewifc,&
           init,nconso)

      nindx=1
      do 3193 nsp=1,nspec
        do 3194 ni=1,nionsp(nsp)
          do 3195 m=1,3
            ewald_force(m,ni,nsp)=ewifc(m,nindx)
 3195     continue
          nindx=nindx+1
 3194   continue
 3193 continue

      init = .false.

      end subroutine ewald_energy_and_force

!=======================================================================
      subroutine ewaltr(nions,nionst,posion,&
           dirc,recc,volc,icharc,tewen,ewifc,&
           init,nconso )
!=======================================================================
! this subroutine calculates the ewald energy due to coulomb energy
! between the ions and the neutralising background. the coulomb forces
! on the ions due to coulomb interaction with the other ions and the
! stress on the unit cell that is related to the change in the ewald
! energy on changing the size of the cell
!=======================================================================
! the ewald method of performing coulomb sums over a lattice is
! explained in many texts, one is 'dynamical theory of crystal lattices'
! by born and huang. the only thing to be careful about is that in a
! total energy calculation the ewald energy includes the energy of
! interaction between the ions and a neutralising background.
! the ewald method works by writing the coulomb energy as a sum of a
! real space part (which is summed over all space) and a reciprocal
! space part (which is summed over all the reciprocal lattice points).
! this part of the method is exact and doesn't reduce the amount of
! work needed to perform the summation. however, the real space
! contributions fall off rapidly with increasing distance so that only
! a finite number of unit cells need to be included in the sum and the
! reciprocal space contributions fall off rapidly with the magnitude of
! the reciprocal lattice vector so that only a finite number of
! reciprocal lattice points need to be included in the reciprocal space
! sum
! a variable (scale in this program) determines how rapidly the ewald
! sums fall off with increasing distance in real and reciprocal space.
! the number of real space cells summed over is determined by maxcx,y,z
! and the number of reciprocal space cells by maxgpx,y,z. the value of
! scale should be chosen to minimise the total number of operations
! needed to compute the coulomb lattice sums.
!=======================================================================
! rather than compute the values of the ewald integrals this program
! interpolates the values of the integrals from a set of data arrays
! ewrlen,ewrcss,ewrlss and ewrcsi
!=======================================================================
      implicit none
!=======================================================================
!
!             terms in the parameter statement
!
! maxcx,maxcy,maxcz = the number of cells in each direction from the
! central cell included in the evaluation of the real space ewald sums
! the values of these parameters should be chosen so that
! maxcx(y,z)*sqrt(pi)*sizex(y,z)/min(sizex,sizey,sizez) are all greater
! than 3, (the larger the value the closer to the correct coulomb sum)
! maxgpx,maxgpy,maxgpz = the number of reciprocal lattice points in each
! direction from g=0 included in the evaluation of the reciprocal space
! ewald sums. the values of these parameters should be chosen so that
! ngptx(y,z)*min(sizex,sizey,sizez)/(sqrt(pi)*sizex(y,x) are all greater
! than 3, (the larger the value the closer to the correct coulomb sum)
! argmre is the argument corresponding to the last element in the real
! space ewald integral data arrays
! argmrc is the argument corresponding to the last element in the
! reciprocal space ewald integral data arrays
! newpts is the number of values in the ewald integral data arrays
!=======================================================================
      integer   nions,nionst
      real*8    posion(3,nions)
      real*8    dirc(3,3),recc(3,3),volc
      integer   icharc(nions)
      real*8    tewen,ewifc(3,nions)
      logical   init 
      integer   nconso
!=======================================================================
!
!                  dimension statements
!
! rforce(l,a,b) = the contribution to the total coulomb force in the 'l'
!        direction on ion a from the periodic array of ions b
!        from the part of the ewald sums performed in real space
! cforce(l,a,b) = the contribution to the total coulomb force in the 'l'
!        direction on ion a from the periodic array of ions b
!        from the part of the ewald sums performed in reciprocal space
! forceg = the reciprocal space lattice vector multiplied by an ewald
!        integral (used for calculating the forces on the ions)
! energ = the ewald integral used to calculate the contribution to the
!        total energy from the reciprocal space part of the ewald sum
!=======================================================================
      real*8 argmre,argmrc
      parameter(argmre=4.0d0,argmrc=4.0d0)
!     automatic work arrays (some with dimension given from global data)
      real*8    rforce(3,nions,nions),forceg(3,ngpts)
      real*8    energ((ngptx+2)*(ngpty+2)*(ngptz+2))
      complex*16 cphfx(ngptx+2),cphfy(ngpty+2),cphfz(ngptz+2)
      complex*16 cforce(3,nions,nions)
!=======================================================================
! elect = (the charge on the ion * the electronic charge)/(4*pi * the
!          permittivity of free space)
!=======================================================================
      real*8   pi,elect,tpi,half,sixth,one
      complex*16 citpi
      data pi / 3.1415926536d0/
      data elect /14.39976868d0 /
      data tpi /6.2831853072d0/
      data half,sixth / 0.5d0,0.166666666667d0 /
      data one /1.0d0/
      data citpi /(0.0d0,6.2831853072d0)/

      integer ni,nni,ichsq,n,nn,nnn,i,ng,naddr,m
      real*8  scale,sizmin,rewen,a1diff,a2diff,a3diff
      real*8  xdiff,ydiff,zdiff,v1,v2,v3,v4,t0,t1,t2,t3
      real*8  g1x,g1y,g1z,g2x,g2y,g2z,g3x,g3y,g3z,gx,gy,gz
      real*8  ewsi,gscale,gsisc1,gsisc2 ,ewrl,value,dcount
      real*8  pidsca,arg,garg,ewrc,rensca,gensca,rscale,rem
      complex*16 cewen,cphfzy ,cexphf,cphf, cyphf,czphf,cxphf
!=======================================================================
! If first call of subroutine then calculate the energy for cells
! 1 shell further away from the origin
!
! For comments please see the subsequent section where the energy
! and the forces and stresses are calculated
!=======================================================================
      if (init) then

!        write(nconso,*) 'ewald : total charge on ions      ',nionch
        tewen=0.0d0
        rewen=0.0d0
        cewen=(0.0d0,0.0d0)
        sizmin=sqrt(min( (dirc(1,1)**2+dirc(1,2)**2+dirc(1,3)**2),&
                         (dirc(2,1)**2+dirc(2,2)**2+dirc(2,3)**2),&
                         (dirc(3,1)**2+dirc(3,2)**2+dirc(3,3)**2) ))
        scale=sqrt(pi)/sizmin*1.0d0
        write(nconso,1858) scale
 1858   format(1x,'ewald: eta = ',f12.6)
        pidsca=pi/scale
        do 7010 ni=1,nionst
!          write(nconso,*) 'ewald : icharc(',ni,')',icharc(ni)
          do 7011 nni=ni,nionst
            ichsq=icharc(ni)*icharc(nni)
            if(nni.eq.ni) then
              dcount=0.5d0*ichsq
            else
              dcount=1.0d0*ichsq
            endif
            a1diff=posion(1,ni)-posion(1,nni)+(maxcx+1)
            a2diff=posion(2,ni)-posion(2,nni)+(maxcy+1)
            a3diff=posion(3,ni)-posion(3,nni)+(maxcz+1)
          xdiff=dirc(1,1)*a1diff+dirc(2,1)*a2diff+dirc(3,1)*a3diff
          ydiff=dirc(1,2)*a1diff+dirc(2,2)*a2diff+dirc(3,2)*a3diff
          zdiff=dirc(1,3)*a1diff+dirc(2,3)*a2diff+dirc(3,3)*a3diff
            do 7100 n=1,ncellz+2
              do 7101 nn=1,ncelly+2
                do 7102 nnn=1,ncellx+2
                  if (n.eq.1.or.n.eq.(ncellz+2).or.&
                      nn.eq.1.or.nn.eq.(ncelly+2).or.&
                      nnn.eq.1.or.nnn.eq.(ncellx+2)) then
                    arg=sqrt(xdiff**2+ydiff**2+zdiff**2)*scale
                    if(arg.lt.3.98d0) then
                      arg=(arg*newpts/argmre)+2.0d0
                      naddr=int(arg)
                      rem=mod(arg,one)
                      v1=ewrlen(naddr-1)
                      v2=ewrlen(naddr)
                      v3=ewrlen(naddr+1)
                      v4=ewrlen(naddr+2)
                      t0=v2
                      t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
                      t2=(v1+v3-(2*v2))*half
                      t3=(v4-v1+(3*(v2-v3)))*sixth
                    value=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
                      rewen=rewen+value*dcount
                    endif
                  endif
                  xdiff=xdiff-dirc(1,1)
                  ydiff=ydiff-dirc(1,2)
                  zdiff=zdiff-dirc(1,3)
                  a1diff=a1diff-1
 7102           continue
                xdiff=xdiff+dirc(1,1)*(ncellx+2)-dirc(2,1)
                ydiff=ydiff+dirc(1,2)*(ncellx+2)-dirc(2,2)
                zdiff=zdiff+dirc(1,3)*(ncellx+2)-dirc(2,3)
                a1diff=a1diff+(ncellx+2)
                a2diff=a2diff-1
 7101         continue
              xdiff=xdiff+dirc(2,1)*(ncelly+2)-dirc(3,1)
              ydiff=ydiff+dirc(2,2)*(ncelly+2)-dirc(3,2)
              zdiff=zdiff+dirc(2,3)*(ncelly+2)-dirc(3,3)
              a2diff=a2diff+(ncelly+2)
              a3diff=a3diff-1
 7100       continue
 7011     continue
 7010   continue
        rscale=(scale**3)*4.0d0*elect/sqrt(pi)
        rensca=scale*2.0d0*elect/sqrt(pi)
        g1x=-(recc(1,1)*(maxgpx+1))/tpi
        g1y=-(recc(1,2)*(maxgpx+1))/tpi
        g1z=-(recc(1,3)*(maxgpx+1))/tpi
        g2x=-(recc(2,1)*(maxgpy+1))/tpi
        g2y=-(recc(2,2)*(maxgpy+1))/tpi
        g2z=-(recc(2,3)*(maxgpy+1))/tpi
        g3x=-(recc(3,1)*(maxgpz+1))/tpi
        g3y=-(recc(3,2)*(maxgpz+1))/tpi
        g3z=-(recc(3,3)*(maxgpz+1))/tpi
        gx=g1x+g2x+g3x
        gy=g1y+g2y+g3y
        gz=g1z+g2z+g3z
        ng=1
        do 7200 n=1,ngptz+2
          do 7201 nn=1,ngpty+2
            do 7202 nnn=1,ngptx+2
              ewrc=0.0
              if (n.eq.1.or.n.eq.(ngptz+2).or.&
                  nn.eq.1.or.nn.eq.(ngpty+2).or.&
                  nnn.eq.1.or.nnn.eq.(ngptx+2)) then
                gx=g1x+g2x+g3x
                gy=g1y+g2y+g3y
                gz=g1z+g2z+g3z
                garg=sqrt(gx**2+gy**2+gz**2)*pidsca
                if(garg.lt.3.98d0) then
                  garg=(garg*newpts/argmrc)+2.0d0
                  naddr=int(garg)
                  rem=mod(garg,one)
                  v1=ewrcss(naddr-1)
                  v2=ewrcss(naddr)
                  v3=ewrcss(naddr+1)
                  v4=ewrcss(naddr+2)
                  t0=v2
                  t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
                  t2=(v1+v3-(2*v2))*half
                  t3=(v4-v1+(3*(v2-v3)))*sixth
                  ewrc=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
                endif
              endif
              energ(ng)=ewrc
              ng=ng+1
              g1x=g1x+recc(1,1)/tpi
              g1y=g1y+recc(1,2)/tpi
              g1z=g1z+recc(1,3)/tpi
 7202       continue
            g1x=-(recc(1,1)*(maxgpx+1))/tpi
            g1y=-(recc(1,2)*(maxgpx+1))/tpi
            g1z=-(recc(1,3)*(maxgpx+1))/tpi
            g2x=g2x+recc(2,1)/tpi
            g2y=g2y+recc(2,2)/tpi
            g2z=g2z+recc(2,3)/tpi
 7201     continue
          g2x=-(recc(2,1)*(maxgpy+1))/tpi
          g2y=-(recc(2,2)*(maxgpy+1))/tpi
          g2z=-(recc(2,3)*(maxgpy+1))/tpi
          g3x=g3x+recc(3,1)/tpi
          g3y=g3y+recc(3,2)/tpi
          g3z=g3z+recc(3,3)/tpi
 7200   continue
        do 7300 ni=1,nionst
          do 7301 nni=ni,nionst
            ichsq=icharc(ni)*icharc(nni)
            if(ni.eq.nni) then
              dcount=0.5d0*ichsq
            else
              dcount=1.0d0*ichsq
            endif
            cxphf=(posion(1,ni)-posion(1,nni))*citpi
            cyphf=(posion(2,ni)-posion(2,nni))*citpi
            czphf=(posion(3,ni)-posion(3,nni))*citpi
            cphf=-cxphf*(maxgpx+1)
            do 7330 n=1,ngptx+2
              cphfx(n)=exp(cphf)
              cphf=cphf+cxphf
 7330       continue
            cphf=-cyphf*(maxgpy+1)
            do 7331 n=1,ngpty+2
              cphfy(n)=exp(cphf)
              cphf=cphf+cyphf
 7331       continue
            cphf=-czphf*(maxgpz+1)
            do 7332 n=1,ngptz+2
              cphfz(n)=exp(cphf)
              cphf=cphf+czphf
 7332       continue
            ng=1
            do 7310 n=1,ngptz+2
              do 7311 nn=1,ngpty+2
                cphfzy=cphfy(nn)*cphfz(n)
                do 7312 nnn=1,ngptx+2
                  cexphf=cphfx(nnn)*cphfzy
                  cewen=cewen+(energ(ng)*cexphf)*dcount
                  ng=ng+1
 7312           continue
 7311         continue
 7310       continue
 7301     continue
 7300   continue
        gensca=2.0d0*pi*elect/(volc*scale**2)
        tewen=rensca*rewen+dble(cewen)*gensca
        write(nconso,1859) tewen
 1859   format(1x,'ewald: energy error (one shell) = ',f12.6)
      endif
!=======================================================================
! end of special action on first call
!=======================================================================
!=======================================================================
! initialise the values of the data arrays
!=======================================================================
      do 5001 n=1,nionst
        do 5002 nn=1,nionst
          do 5003 m=1,3
            cforce(m,nn,n)=(0.0d0,0.0d0)
            rforce(m,nn,n)=0.0d0
 5003     continue
 5002   continue
 5001 continue
      do 5004 n=1,nionst
        do 5005 m=1,3
          ewifc(m,n)=0.0d0
 5005   continue
 5004 continue
      tewen=0.0d0
      rewen=0.0d0
      cewen=(0.0d0,0.0d0)
!=======================================================================
! choose the variable 'scale' that determines the rate of decay of the
! real and reciprocal parts of the ewald sums. the choice of scale used
! below is good for systems where the lengths of the lattice vectors
! are similar, for odder shape systems a different choice for the value
! of scale may reduce the amount of work involved in calculating the
! coulomb lattice sums. dont forget that whatever value is used for
! scale the values of maxcx,y,z and maxgpx,y,z must be sufficiently
! large to obtain the level of convergence desired
!=======================================================================
      sizmin=sqrt(min( (dirc(1,1)**2+dirc(1,2)**2+dirc(1,3)**2),&
                       (dirc(2,1)**2+dirc(2,2)**2+dirc(2,3)**2),&
                       (dirc(3,1)**2+dirc(3,2)**2+dirc(3,3)**2) ))
      scale=sqrt(pi)/sizmin*1.0d0
      pidsca=pi/scale
!=======================================================================
! calculate the contribution to the total energy, the forces on the ions
! and the forces on the unit cell due to the real space part of the
! ewald sums
!=======================================================================
      do 5010 ni=1,nionst
        do 5011 nni=ni,nionst
          ichsq=icharc(ni)*icharc(nni)
!=======================================================================
! the energy of interaction between each pair of ions must be divided
! equally between the two ions. since the loops over the ions give the
! energy of interation of ion ni with the periodic array of ions nni
! where the index nni is greater than or equal to ni we include half
! the energy if ni is equal to nni but all of of it if nni is greater
! than ni to account for energy due to ion nni interacting with the
! array of ions ni
!=======================================================================
          if(nni.eq.ni) then
            dcount=0.5d0*ichsq
          else
            dcount=1.0d0*ichsq
          endif
!=======================================================================
! initialise the distances in the x,y,z directions between ion ni and io
! nni in the corner cell of the block of unit cells included in the real
! space part of the ewald sum
!=======================================================================
          a1diff=posion(1,ni)-posion(1,nni)+maxcx
          a2diff=posion(2,ni)-posion(2,nni)+maxcy
          a3diff=posion(3,ni)-posion(3,nni)+maxcz
          xdiff=dirc(1,1)*a1diff+dirc(2,1)*a2diff+dirc(3,1)*a3diff
          ydiff=dirc(1,2)*a1diff+dirc(2,2)*a2diff+dirc(3,2)*a3diff
          zdiff=dirc(1,3)*a1diff+dirc(2,3)*a2diff+dirc(3,3)*a3diff
!=======================================================================
! calculate the real space contribution to the total energy etc by
! summing the contributions due to ion ni interacting with all the
! ions nni in the block of unit cells retained in the real space sum
!=======================================================================
          do 5100 n=1,ncellz
            do 5101 nn=1,ncelly
              do 5102 nnn=1,ncellx
!=======================================================================
! convert the distance between the ions into a dimensionless form by
! multiplying by 'scale'
!=======================================================================
                arg=sqrt(xdiff**2+ydiff**2+zdiff**2)*scale
!=======================================================================
! convert the dimensionless distance to an address in the ewald integral
! arrays to interpolate the values of the ewald integrals, if the
! distance is outside the range of values in the ewald integral data
! arrays move onto ion nni in the next unit cell
!=======================================================================
                if(arg.gt.3.98d0) go to 5103
                arg=(arg*newpts/argmre)+2.0d0
                naddr=int(arg)
                rem=mod(arg,one)
!=======================================================================
! interpolate the value of the ewald integral used in the real space
! part of the ewald summation for the forces on the ions and the unit
! cell
!=======================================================================
                v1=ewrlss(naddr-1)
                v2=ewrlss(naddr)
                v3=ewrlss(naddr+1)
                v4=ewrlss(naddr+2)
                t0=v2
                t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
                t2=(v1+v3-(2*v2))*half
                t3=(v4-v1+(3*(v2-v3)))*sixth
                ewrl=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
!=======================================================================
! add the contribution to the total force on ion ni due to the periodic
! array of ions nni from ion nni in the present real space cell
!=======================================================================
                rforce(1,nni,ni)=rforce(1,nni,ni)+xdiff*ewrl
                rforce(2,nni,ni)=rforce(2,nni,ni)+ydiff*ewrl
                rforce(3,nni,ni)=rforce(3,nni,ni)+zdiff*ewrl
!=======================================================================
! interpolate the value of the ewald integral used in the real space
! part of the ewald summation for the forces on the ions and the unit
! cell
!=======================================================================
                v1=ewrlen(naddr-1)
                v2=ewrlen(naddr)
                v3=ewrlen(naddr+1)
                v4=ewrlen(naddr+2)
                t0=v2
                t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
                t2=(v1+v3-(2*v2))*half
                t3=(v4-v1+(3*(v2-v3)))*sixth
                value=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
!=======================================================================
! add the contribution to the total energy due to the coulomb
! interaction between ion ni and ion nni in the present real space cell
!=======================================================================
                rewen=rewen+value*dcount
 5103         continue
!=======================================================================
! move onto ion nni in the next real space cell in the a1 direction
!=======================================================================
              xdiff=xdiff-dirc(1,1)
              ydiff=ydiff-dirc(1,2)
              zdiff=zdiff-dirc(1,3)
              a1diff=a1diff-1
 5102       continue
!=======================================================================
! move onto the next row of cells in the a2 direction and back to the
! first cell in the row
!=======================================================================
            xdiff=xdiff+dirc(1,1)*ncellx-dirc(2,1)
            ydiff=ydiff+dirc(1,2)*ncellx-dirc(2,2)
            zdiff=zdiff+dirc(1,3)*ncellx-dirc(2,3)
            a1diff=a1diff+ncellx
            a2diff=a2diff-1
 5101     continue
!=======================================================================
! move onto the next plane of cells in the a3 direction and back to the
! first cell in the plane
!=======================================================================
          xdiff=xdiff+dirc(2,1)*ncelly-dirc(3,1)
          ydiff=ydiff+dirc(2,2)*ncelly-dirc(3,2)
          zdiff=zdiff+dirc(2,3)*ncelly-dirc(3,3)
          a2diff=a2diff+ncelly
          a3diff=a3diff-1
 5100   continue
!=======================================================================
! end of the loop over ion nni, move onto the next ion
!=======================================================================
 5011 continue
!=======================================================================
! end of the loop over ion ni, move onto the next ion
!=======================================================================
 5010 continue
!=======================================================================
! calculate the scaling factors that will be used to convert the values
! of the forces and the energy calculated above to real forces and
! energies. the factors take account of the numerical constants
! introduced by the ewald separation of the coulomb lattice sums, the
! rescaling of all of the ewald integrals onto the range zero to one
! as well putting in the electrostatic constants via 'elect'
!=======================================================================
      rscale=(scale**3)*4.0d0*elect/sqrt(pi)
      rensca=scale*2.0d0*elect/sqrt(pi)
!=======================================================================
!
!                      ***********
! now move onto the reciprocal space part of the ewald summations
!                      ***********
!
!=======================================================================
! initialise the x,y,z reciprocal lattice vectors to the reciprocal
! lattice point at the corner of the grid used for the reciprocal space
! contributions to the ewald sums
!=======================================================================
      g1x=-(recc(1,1)*maxgpx)/tpi
      g1y=-(recc(1,2)*maxgpx)/tpi
      g1z=-(recc(1,3)*maxgpx)/tpi
      g2x=-(recc(2,1)*maxgpy)/tpi
      g2y=-(recc(2,2)*maxgpy)/tpi
      g2z=-(recc(2,3)*maxgpy)/tpi
      g3x=-(recc(3,1)*maxgpz)/tpi
      g3y=-(recc(3,2)*maxgpz)/tpi
      g3z=-(recc(3,3)*maxgpz)/tpi
      gx=g1x+g2x+g3x
      gy=g1y+g2y+g3y
      gz=g1z+g2z+g3z
!=======================================================================
! calculate the scaling factors that will be used to calculate the
! forces on the unit cell. the factors take account of the numerical
! constants introduced by the ewald separation of the coulomb lattice
! sums, the rescaling of all of the ewald integrals onto the range zero
! to one as well as putting in the electrostatic constants via 'elect'
!=======================================================================
      gsisc1=-4.0d0*(pi**3)*elect/(volc*scale**4)
      gsisc2=2.0d0*pi*elect/(volc*scale**2)
!=======================================================================
! ng is an index used to label the reciprocal lattice vectors
! initialise to one
!=======================================================================
      ng=1
!=======================================================================
! interpolate the values of the reciprocal space ewald integrals at the
! grid of reciprocal lattice points and calculate functions of the ewald
! integrals and reciprocal lattice vectors to be used for calulating the
! forces on the ions and the unit cell and the total energy
!=======================================================================
      do 5200 n=1,ngptz
        do 5201 nn=1,ngpty
          do 5202 nnn=1,ngptx
!=======================================================================
! calculate the dimensionless length of the reciprocal lattice vector
!=======================================================================
            gx=g1x+g2x+g3x
            gy=g1y+g2y+g3y
            gz=g1z+g2z+g3z
            garg=sqrt(gx**2+gy**2+gz**2)*pidsca
!=======================================================================
! convert the dimensionless length to an address in the ewald integral
! arrays to interpolate the values of the ewald integrals, if the
! distance is outside the range of values in the ewald integral data
! arrays set the values of the ewald integrals to zero
!=======================================================================
            if(garg.gt.3.98d0) then
              ewrc=0.0
              ewsi=0.0
            else
              garg=(garg*newpts/argmrc)+2.0d0
              naddr=int(garg)
              rem=mod(garg,one)
!=======================================================================
! interpolate the values of the ewald integrals used in the reciprocal
! space part of the ewald summation
!=======================================================================
              v1=ewrcss(naddr-1)
              v2=ewrcss(naddr)
              v3=ewrcss(naddr+1)
              v4=ewrcss(naddr+2)
              t0=v2
              t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
              t2=(v1+v3-(2*v2))*half
              t3=(v4-v1+(3*(v2-v3)))*sixth
              ewrc=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
              v1=ewrcsi(naddr-1)
              v2=ewrcsi(naddr)
              v3=ewrcsi(naddr+1)
              v4=ewrcsi(naddr+2)
              t0=v2
              t1=((6*v3)-(2*v1)-(3*v2)-v4)*sixth
              t2=(v1+v3-(2*v2))*half
              t3=(v4-v1+(3*(v2-v3)))*sixth
              ewsi=(t0+(t1*rem)+(t2*(rem**2))+(t3*(rem**3)))
            endif
!=======================================================================
! using the values of the ewald integrals for this reciprocal lattice
! vector calculate the functions of the reciprocal lattice vector and
! the ewald integrals used to calculate the forces etc
!=======================================================================
            forceg(1,ng)=gx*ewrc
            forceg(2,ng)=gy*ewrc
            forceg(3,ng)=gz*ewrc
            energ(ng)=ewrc
!=======================================================================
! increase the index ng by one for the next reciprocal lattice vector
!=======================================================================
            ng=ng+1
!=======================================================================
! move onto the next reciprocal lattice point in the x direction
!=======================================================================
            g1x=g1x+recc(1,1)/tpi
            g1y=g1y+recc(1,2)/tpi
            g1z=g1z+recc(1,3)/tpi
 5202     continue
!=======================================================================
! move onto the next row of reciprocal lattice vectors in the y
! direction and back to the first point in the row
!=======================================================================
          g1x=-(recc(1,1)*maxgpx)/tpi
          g1y=-(recc(1,2)*maxgpx)/tpi
          g1z=-(recc(1,3)*maxgpx)/tpi
          g2x=g2x+recc(2,1)/tpi
          g2y=g2y+recc(2,2)/tpi
          g2z=g2z+recc(2,3)/tpi
 5201   continue
!=======================================================================
! move onto the next plane of reciprocal lattice vectors in the z
! direction and back to the point in the corner of the plane
!=======================================================================
        g2x=-(recc(2,1)*maxgpy)/tpi
        g2y=-(recc(2,2)*maxgpy)/tpi
        g2z=-(recc(2,3)*maxgpy)/tpi
        g3x=g3x+recc(3,1)/tpi
        g3y=g3y+recc(3,2)/tpi
        g3z=g3z+recc(3,3)/tpi
 5200 continue
!=======================================================================
! using the functions computed above calculate the forces on the ions
! and on the unit cell and the contribution to the total energy which
! arises from the reciprocal space part of the ewald summation
!=======================================================================
!======================================================================
! the following are the loops to calculate the forces between all pairs
! of atoms in the unit cell and the energy
!=======================================================================
      do 5300 ni=1,nionst
        do 5301 nni=ni,nionst
          ichsq=icharc(ni)*icharc(nni)
!=======================================================================
! as before, dcount accounts for the energy of interaction between pairs
! of ions for the restricted sum nni greater or equal to ni
!=======================================================================
          if(ni.eq.nni) then
            dcount=0.5d0*ichsq
          else
            dcount=1.0d0*ichsq
          endif
!=======================================================================
! cx,y,zphf are the changes in phase factors on moving one reciprocal
! lattice vector in the x,y,z directions, respectively
!=======================================================================
          cxphf=(posion(1,ni)-posion(1,nni))*citpi
          cyphf=(posion(2,ni)-posion(2,nni))*citpi
          czphf=(posion(3,ni)-posion(3,nni))*citpi
!=======================================================================
! initialise the total phase factor to the value for the reciprocal
! lattice point at the corner of the reciprocal lattice grid and
! initialise the reciprocal lattice vector index to one
!=======================================================================
          cphf=-cxphf*maxgpx
          do 5330 n=1,ngptx
            cphfx(n)=exp(cphf)
            cphf=cphf+cxphf
 5330     continue
          cphf=-cyphf*maxgpy
          do 5331 n=1,ngpty
            cphfy(n)=exp(cphf)
            cphf=cphf+cyphf
 5331     continue
          cphf=-czphf*maxgpz
          do 5332 n=1,ngptz
            cphfz(n)=exp(cphf)
            cphf=cphf+czphf
 5332     continue
          ng=1
!=======================================================================
! for each pair of atoms sum the forces and the contribution to the
! total energy over the grid of reciprocal lattice points
!=======================================================================
          do 5310 n=1,ngptz
            do 5311 nn=1,ngpty
              cphfzy=cphfy(nn)*cphfz(n)
              do 5312 nnn=1,ngptx
!=======================================================================
! calculate the exponential of the phase factor
!=======================================================================
                cexphf=cphfx(nnn)*cphfzy
!=======================================================================
! calculate the contribution to the force between ion ni and ions nni,
! from the reciprocal lattice part of the ewald sum at the present
! k point
!=======================================================================
                do 5320 m=1,3
                  cforce(m,nni,ni)=cforce(m,nni,ni)+forceg(m,ng)*cexphf
 5320           continue
!=======================================================================
! calculate the contribution to the total energy due to the interaction
! between ion ni and ions nni from the reciprocal space part of the
! ewald sum at the present k point
!=======================================================================
                cewen=cewen+(energ(ng)*cexphf)*dcount
!=======================================================================
! increase the reciprocal lattice point index by one and change the
! phase factor by the phase corresponding to moving one reciprocal
! lattice vector in the x direction, ie to the next reciprocal lattice
! point in the x direction
!=======================================================================
                ng=ng+1
 5312         continue
!=======================================================================
! move to the next row of reciprocal lattice points in the y direction
! and the first reciprocal lattice point in the row
!=======================================================================
 5311       continue
!=======================================================================
! move to the next plane of reciprocal lattice points in the z direction
! and the reciprocal lattice point at the corner of the plane
!=======================================================================
 5310     continue
!=======================================================================
! move onto the next ion nni
!=======================================================================
 5301   continue
!=======================================================================
! move onto the next ion ni
!=======================================================================
 5300 continue
!=======================================================================
! use inversion through a point midway between ion ni and nni to obtain
! the forces on ion nni due to interaction with the periodic array of
! ions nni. its basically newton's third law but slightly subtler
!=======================================================================
      do 5400 ni=1,nionst
        do 5401 nni=1,ni-1
          do 5402 m=1,3
            cforce(m,nni,ni)=-cforce(m,ni,nni)
            rforce(m,nni,ni)=-rforce(m,ni,nni)
 5402     continue
 5401   continue
 5400 continue
!=======================================================================
! calculate the scaling factors that will be used to convert the values
! of the forces and the energy calculated above to real forces and
! energies. the factors take account of the numerical constants
! introduced by the ewald separation of the coulomb lattice sums, the
! rescaling of all of the ewald integrals onto the range zero to one
! as well putting in the electrostatic constants via 'elect'
!=======================================================================
      gensca=2.0d0*pi*elect/(volc*scale**2)
      gscale=((2.0d0*pi)**2)*elect/(volc*scale**2)
!=======================================================================
! calculate the total forces on the ions
!=======================================================================
      do 5410 ni=1,nionst
        do 5411 nni=1,nionst
          ichsq=icharc(ni)*icharc(nni)
          do 5412 m=1,3
            ewifc(m,ni)=ewifc(m,ni)+((rforce(m,nni,ni)*rscale+&
                       dimag(cforce(m,nni,ni))*gscale)*ichsq)
 5412     continue
 5411   continue
 5410 continue
!=======================================================================
! calculate the total coulomb energy per cell including the energy due
! the interaction between the ions and the uniform neutralising
! background (given by the final two terms in the sum below)
!=======================================================================
      tewen=rensca*rewen+dble(cewen)*gensca-(nionch**2*gensca/4.0d0)&
         -(scale*elect*nichsq/sqrt(pi))

      end subroutine ewaltr

!=======================================================================
      subroutine initialize(dirc,nspec,nions,nionsp,icharc,nconso)

!     initialize the global dimension and variables for the module
!     ewrlen, ewrcss, ewrlss, ewrcsi
!     maxcx(yz),maxgpx(y,z)
!     ncellx(yz),ngptx(yz)

      implicit none
      real*8 dirc(3,3)
      integer nions,nspec,nionsp(nspec),icharc(nions),nconso

!     locals 
      real*8 sizex,sizey,sizez,pi,minsize
      integer defaultcell,nsp,i,n,ni
      parameter(defaultcell=9,pi = 3.14159d0)
      

!c      > use internal data segment <
!c================== read in data from external units (ewald.dat) =======
!c      open(10,FILE='fort.10',STATUS='OLD')
!c     read(10,*) (ewrlen(i),i=1,newpts)
!c      read(10,*) (ewrcss(i),i=1,newpts)
!c      read(10,*) (ewrlss(i),i=1,newpts)
!c      read(10,*) (ewrcsi(i),i=1,newpts)
!c      close (unit=10)


!     make estimates for ncellx(yz),maxgpx(yz), see also doc. in subroutine ewaltr
!     maxcx(yz) :
!         maxcx(y,z)*sqrt(pi)*sizex(y,z)/min(sizex,sizey,sizez) > 5
!     ngptx(yz) : 
!         ngptx(y,z)*min(sizex,sizey,sizez)/(sqrt(pi)*sizex(y,x)  > 5

      sizex = sqrt(dirc(1,1)**2 + dirc(1,2)**2 + dirc(1,3)**2)
      sizey = sqrt(dirc(2,1)**2 + dirc(2,2)**2 + dirc(2,3)**2)
      sizez = sqrt(dirc(3,1)**2 + dirc(3,2)**2 + dirc(3,3)**2)
      minsize = min(sizex,sizey,sizez) 

      maxcx=max(nint(float(defaultcell)/sqrt(pi) * minsize/sizex),1)
      maxcy=max(nint(float(defaultcell)/sqrt(pi) * minsize/sizey),1)
      maxcz=max(nint(float(defaultcell)/sqrt(pi) * minsize/sizez),1)

      maxgpx=max(nint(float(defaultcell)/sqrt(pi) * sizex/minsize),1)
      maxgpy=max(nint(float(defaultcell)/sqrt(pi) * sizey/minsize),1)
      maxgpz=max(nint(float(defaultcell)/sqrt(pi) * sizez/minsize),1)

!     calculate the total charge on the ions, nionch, 
!     and the sum of the squares of the charges on the ions, nichsq
      nionch=0
      nichsq=0
      n = 1
      do  nsp=1,nspec
        do ni = 1,nionsp(nsp) 
          nionch=nionch+icharc(n)
          nichsq=nichsq+(icharc(n)**2)
          n = n +1
        enddo 
      enddo                                    

!     set the 
      ncellx=(2*maxcx)+1
      ncelly=(2*maxcy)+1
      ncellz=(2*maxcz)+1
      ngptx=(2*maxgpx)+1
      ngpty=(2*maxgpy)+1
      ngptz=(2*maxgpz)+1
      ngpts=ngptx*ngpty*ngptz                                           

      write(nconso,1856) maxcx,maxcx,maxcy,maxcy,maxcz,maxcz
      write(nconso,1857) maxgpx,maxgpx,maxgpy,maxgpy,maxgpz,maxgpz
 1856 format(1x,'ewald: real space cells      : ',&
             '(-',i3,',',i3,')x(-',i3,',',i3,')x(-',i3,',',i3,')')
 1857 format(1x,'ewald: reciprocal space cells: ',&
             '(-',i3,',',i3,')x(-',i3,',',i3,')x(-',i3,',',i3,')')
      call uflush(nconso)                                                             

      end subroutine initialize

                                                                                     
!=======================================================================
      subroutine ewalid(nconso)
      write(nconso,*) 'Module %W% %G%'

      end subroutine ewalid                                                                               

      end module ewald


