
! @(#)dacapo.F	1.42 7/1/99
 
       program dacapo
       use van_us_data_module
       use read_structure_netcdf_module
       use tmp_read_netcdf_module
       use kp_analysis
       use fftdimensions
       use g_vectors
       use run_context


#include "definitions.h"


! Array dimensions and constants/flags

      implicit none

!     init out-file (from now on : nconso defined in run_context)
!     integer nconso
!     parameter (nconso=18)

!     The name of the wavefunction input/output file
      character*32 wffile

      parameter (wffile = 'wf')

      integer   ngx,ngy,ngz,nplwv,ngxs,ngys,ngzs 
      integer   nrplwv,nrplwv_global
      integer   npspts,mmaxx
      integer   npwxc,nspin,nions,nspec
      integer   nbands,nsymax,idebug,nkprun,nkpmem
      integer   iscxc

!    iscxc = 1 : PZ   (Perdew Zunger)          LDA  
!    iscxc = 2 : VWN  (Vosko Wilk Nusair)      LDA 
!    iscxc = 3 : PW91 (Perdew Wang 91)         GGA 
!    iscxc = 4 : PBE  (Perdew Burke Ernzerhof) GGA
!    iscxc = 5 : revPBE                        GGA
!    iscxc = 6 : RPBE                          GGA


#ifdef PARAL
#include PARAL_DECL
#endif


      logical*4 lmastr
#ifdef PARAL
      parameter (slvexe = 'dacapo.ftn')
      integer, pointer :: kphost(:)
#endif

!     Fixed dimension
      parameter(npspts=16001,mmaxx=1200)

      integer ndcbyt
#ifdef CRAY
      parameter(ndcbyt=16)
#else
      parameter(ndcbyt=WF_PRECISION)
#endif

! genbop 
      integer, pointer ::  ipwpad(:,:,:)
      real*8 , pointer ::  dnlg(:,:,:,:),dnlkg(:,:,:,:)
      real*8 , pointer ::  pwkine(:,:,:)


      integer   nkpnum,numlat,numsym,numspa

! k-point analysis
      integer    nmamax
      parameter (nmamax=48)
!     nlatma,nspama and linvad are local to dacapo.F
      integer   nlatma(3,3,nmamax)
      integer   nspama(3,3,nmamax)
      logical*4   linvad(nmamax)                   


!     arrays for symmetry
      integer, pointer :: nmstyp(:)
      real*8 , pointer :: dirnms(:,:,:)

!     nmsfft(r,ns): symmetry operation indices
      integer, pointer :: nmsfft(:,:)
      integer,pointer  :: nmsfor(:,:)


!     nkpibz: The k-point within the IBZ that represent this k-point
      integer, pointer ::  nkpibz(:)
!     nkpunf: The point group operation, that brings this k-point into the IBZ
      integer,pointer  ::  nkpunf(:,:,:)
!     lkpinv: True if the nkpunf has been added the inversion without this
!         being present in the space group            
      logical*4, pointer :: lkpinv(:)
      logical*4, pointer :: ldonkp(:,:) 


      integer, pointer ::  nplwkp(:,:)
      integer,pointer   :: kspin(:,:)

      integer, pointer ::  lpctx(:),lpcty(:),lpctz(:)
!     integer   lpctfx(ngx),lpctfy(ngy),lpctfz(ngz)

! gkp123: Coordinates of the k-point in G1,G2,G3-units
      real*8 ,pointer :: gkp123(:,:)                                   
      real*8, pointer ::  vkpt(:,:,:), wtkpt(:,:)

! atoms 
      integer         :: sphericalcnstr(2),icoordsystem  ! spherical atoms in ionmov 
      real*8 ,pointer :: rmove (:,:)
      real*8 ,pointer :: rvelo (:,:)
      real*8 ,pointer :: posion(:,:,:)
      integer,pointer :: atomic_number(:)
      integer,pointer :: nionsp(:)

      real*8    recc(3,3),reci(3,3),dirc(3,3),diri(3,3)
      real*8    ecut_dense,ecut_soft


! Locals

      logical*4 redmem
      integer magic
      integer nkp,ispin
      character*999 outfil


! ------------------------------------------------------------------------

#ifdef SERIAL
      lmastr = .true.
      call init_run_context(lmastr)
!     The program writes to the filename: ASCII_output_filename, if
!     ASCII_output_filename_provided  == true, otherwise no file association

      if (ASCII_output_filename_provided) &
        open (nconso, FILE=ASCII_output_filename , FORM='FORMATTED')

!     Print out start-message and module versions
      call libprt (nconso)
!     For the parallel code, the above is done in msinit()                         
#endif

#ifdef PARAL
!     Initialize message-passing ("par_process" is the parallel-ID)
      idebug = 0
      call msinit (lmastr,idebug,&
#include PARAL_ARGS
        )                                
#endif

#ifdef REDUCE_MEM
      redmem=.TRUE.
#else
      redmem=.FALSE.
#endif

!     copy data 
      if (lmastr .and. netCDF_make_restricted_copy)&
         call MakeRestrictedSetCopy(&
               nconso,netCDF_input_filename,netCDF_output_filename)


      call uflush(nconso)
!     read structural data
      call read_structure(nions, nspec, atomic_number, nionsp, &
                          dirc, recc, diri, reci, &
                          posion, rvelo, rmove, &
                          sphericalcnstr,icoordsystem,lmastr)

!     read some other parameters from a temporary module
      call tmp_read(nspin, nbands,iscxc, &
                    nsymax,idebug,lmastr)

#ifdef PARAL
!     The slave processes write to the fileroot.slave<identifier>
!     Only if idebug>0
      if (.not. lmastr) then
        if ((ASCII_output_filename_provided).and.(idebug>0)) then
          write (outfil, '(2a,i6.6)') trim(ASCII_output_filename),&
                                     ".slave", par_process
          open (nconso,FILE=outfil,FORM='FORMATTED')
        endif
      endif
#endif


!     setup 3D FFT grid dimensions ngx,ngy,ngz (dense grid) and
!     ngxs,ngys,ngzs
      call setup_fft_grid(recc,ecut_soft,ngxs,ngys,ngzs,&
                          ecut_dense,ngx,ngy,ngz,lmastr)

      nplwv = ngx*ngy*ngz

!     find the symmetry  (nsymax is read by tmp_read
      allocate(nmstyp(      max(nsymax,1)))
      allocate(dirnms(3,3,  max(nsymax,1)))
      allocate(nmsfft(ngx*ngy*ngz,max(nsymax,1)))
      allocate(nmsfor(nions,      max(nsymax,1)))
      call symana(posion,dirc,nspec,nionsp,nions,recc,&
                        nconso,nmsfft,ngx,ngy,ngz,numsym,nmstyp,nsymax,&
                        dirnms,nmsfor,nlatma,numlat,nspama,linvad,&
                        numspa,nmamax,lmastr)                         

!     Analyse the set of k-points and find the number of irreducibles kpoints: nkprun
!     and the total number of k-point : nkpnum
      call kptana(dirc,numlat,nlatma,&
                        numspa,nspama,linvad,nkprun,vkpt,wtkpt,&
                        gkp123,nkpnum,nkpibz,nkpunf,lkpinv,nspin,&
                        kspin,idebug,nkpmem,lmastr,nconso)


!     distribute nodes over groups
      allocate(ldonkp(nspin,nkprun))
#ifdef SERIAL
      do ispin = 1,nspin
        do nkp=1,nkprun 
          ldonkp(ispin,nkp) = .true. 
        enddo 
      enddo 
#else
      allocate(kphost(nspin*nkprun))
      call par_distribute (nspin*nkprun,nkpmem,kphost,ldonkp,&
#include PARAL_ARGS
        ,idebug)              
#endif

!     soft grid setup; 
      nplwv = ngxs*ngys*ngzs
      call gvectors(recc,reci,ngxs,ngys,ngzs,&
          nplwv,nkprun,4.0d0*ecut_soft,&
          lpctx,lpcty,lpctz,ngdens,ngdens_soft,ngldim,&
          g,gg,ipwpadG_soft,igtongl,goffs&
#ifdef PARAL
          ,&
#include PARAL_ARGS
#endif
          ,nconso ) 

!     find the number of planewaves for each k-point (nplwkp), the
!     dimension, max nplwkp(nkprun) (nrplwv) and define a number of
!     arrays over nrplwv : ipwpad, pwkine, dnlg,dnlkg,g_soft
      allocate(nplwkp(nspin,nkprun))
      call genbop(nrplwv,ngxs,ngys,ngzs,nplwkp,ecut_soft,&
          vkpt,recc,reci,wtkpt,nkprun,nspin,&
          ngdens,ngdens_soft,g,gg,g_soft,&
          ipwpad, ipwpadG_soft, pwkine, dnlg,dnlkg,&
          lmastr)

!     dense grid setup             
      nplwv = ngx*ngy*ngz
      call gvectors(recc,reci,ngx,ngy,ngz,&
          nplwv,nkprun,4.0d0*ecut_dense,&
          lpctx,lpcty,lpctz,ngdens,ngdens_max,ngldim,&
          g,gg,ipwpadG,igtongl,goffs&
#ifdef PARAL
          ,&
#include PARAL_ARGS
#endif
          ,nconso ) 

      ngl = ngldim
      nrplwv_global = nrplwv

#ifdef PARAL
!     Define the distribution of a single wavefunction band across
!     parallel processors, so cptwfp can be defined local in libtos
      call par_defwf (nrplwv,nrplwv_global,&
#include PARAL_ARGS
        )
#endif PARAL
!     max number of projectors
      nkbmax =nkbpmaxatom*nions
!     max number of different projectors
      nhm=nkbpmaxatom*nspec                
      npwxc = nplwv

!     the effective number of k-points is doubled if the 
!     calculation is spin-polarized (nspin=2)
      nkprun = nspin*nkprun

!     initialize number_kpoints_per_process from run_context
!     for parallel case this is done in par_distribute
#ifdef SERIAL
      number_kpoints_per_process = nkprun 
#endif

 



      magic = 12345678
      call libtos(iscxc,  &
           ngx,ngy,ngz,ngxs,ngys,ngzs,nions,nspec,nbands,nrplwv, &
           nsymax, &
           nrplwv_global, & 
           nspin, npwxc, nkpnum,nkprun, &
           idebug,nplwv,nkpmem,npspts,mmaxx, &
!          arrays initialized in dacapo.F 
           ipwpad,dnlg,dnlkg,pwkine, &
           numsym,nmstyp,dirnms,nmsfft,nmsfor, &
           nkpibz,nkpunf,lkpinv, &
           nplwkp,kspin,lpctx,lpcty,lpctz, &
           vkpt,wtkpt,gkp123,rmove,rvelo,posion,nionsp,atomic_number, &
           recc,reci,dirc,diri,ecut_dense,ndcbyt,ldonkp, &
           sphericalcnstr,icoordsystem &
#ifdef PARAL
            ,lmastr,kphost,&
#include    PARAL_ARGS
#endif PARAL
           ,wffile,magic)

      end
