#include "definitions.h"
      subroutine corec_id(nconso)
      write(nconso,*) '@(#)corec.F	1.12 10/31/97'
      return
      end
!     
!---------------------------------------------------------------------
      SUBROUTINE READVAN(IS,iunit,nconso,typep,nlnum,ifpcor)
!---------------------------------------------------------------------
!
!     READ PSEUDO POTENTIAL 
!
!     COMMENTS EXPLAINING THE MEANING OF VARIABLES ARE GIVEN
!     AT END OF PROGRAM, TOGTHER WITH THE FORMAT FOR THE 
!     PSEUDO-POTENTIAL FILE. THE INPUT FORMAT IS GENERAL 
!     FOR A VANDERBILT ULTRA-SOFT PSEUDOPOTENTIAL.`]

!     parameters for reading pseudo-potential
      use van_us_data_module
      include 'readvan.h'

      integer is,typep
      integer nlnum

      CHARACTER*20 LINE,XCTIT,psd(NPSX)
      integer iunit,nconso,NNLZ(nchix),idmy(3)
      real*8 WWNL(nchix),EE(nchix),EEE(nbrx),&
           DDD(nbrx,nbrx),ru(0:ndm,NPSX)


! declaration of implicit defined quantities
      integer keyps,i,lp,j,k,l,nblock,ios,ifpcor
      real*8 z,exfact,etotpseu,aad,deltax,rcloc,rpcor
! new variables 
      integer irel
      real*8 qtryc,eloc

! new in 7.1
      integer npf,iptype(50)
      real*8  ptryc         

      character*3  :: no_yes(0:1) = (/" no", "yes"/)
!
!     ------------------------------------------------------------
!     READ UNFORMATTED INPUT PSEUDOPOTENTIAL FILE
!     ------------------------------------------------------------
!
! Vanderbildt US is always in numerical form
      numeric(is) = .true.

      REWIND iunit
!      WRITE (nconso,981) iunit
!  981 FORMAT ('BEGIN UNFORMATTED READ FROM FILE',i4,'  ...')
!
      if (typep .eq. 3)  then
! the old vanderbildt pseudofiles
         iver(1,is) =1
         iver(2,is) =0
         iver(3,is) =0
         tlog(is) = .false.
      else
         read(iunit)(iver(i,is),i=1,3),(idmy(i),i=1,3)
         tlog(is) = .true.
      endif
      read (iunit) line,z,zp(is),exfact,nvales(is),mesh(is),etotpseu
!      write(nconso,*) line,z,zp(is)
      if (nvales(is) .gt. nchix) &
        call report_error(' readvan','nvales(is).gt.nchix',nvales(is))
      if (mesh(is) .gt. ndm) &
           call report_error(' readvan','mesh(is) .gt. ndm',mesh(is))
      psd(is) = line(1:2)
      read (iunit) (nnlz(i),wwnl(i),ee(i),i=1,nvales(is))
      read (iunit) keyps,ifpcor,rinner(1,is)

      if ( keyps .ne. 3 )&
           call report_error('readvan','keyps .ne. 3',keyps)

      if ( iver(1,is) .ge. 3 ) then
         read(iunit) lmax(is),lloc(is),eloc,ifqopt(is),nqf(is),qtryc
      endif
!     write(nconso,*) 'readvan: Local potential is ',lloc(is)
!
      if ( iver(1,is) .eq. 1 ) then
!         no distinction between lmax and nvales(is)
          lmax(is) = nvales(is)
!         no optimisation of q_ij so 3 term taylor series
          nqf(is) = 3
          nqlc(is) = 5
      else if ( iver(1,is) .eq. 2 ) then
!     no distinction between lmax and nvales(is)
           lmax(is) = nvales(is)
!     no optimisation of q_ij so 3 term taylor series
           nqf(is) = 3
           nqlc(is) = 2 * nvales(is) - 1
      else
           nqlc(is) = 2 * lmax(is) - 1
      endif
      if (typep .eq. 3) rinner(1,is) = .0

      if (10*iver(1,is)+iver(2,is).ge.51) then
         read (iunit) (rinner(i,is),i=1,lmax(is)*2-1)
      else
         if (lmax(is).gt.1) then
            do i=2,2*lmax(is)-1
               rinner(i,is)=rinner(1,is)
            end do
         endif
      endif
      if ( iver(1,is) .ge. 4 ) then
         read(iunit) irel
      endif

!
!     set the number of angular momentum terms in q_ij to read in
      if (lmax(is).gt.lmaxx+1) &
           call report_error(' readvan',' lmax.gt.lmaxx+1',lmax(is))
      if (nqf(is).gt.nqfm) &
           call report_error(' readvan',' nqf.gt.nqfm',nqf(is))
      if (nqlc(is).gt.lqx) &
           call report_error(' readvan',' nqlc.gt.lqx',nqlc(is))

      read (iunit) (rc(i,is),i=1,lmax(is))
      read (iunit) nbeta(is),kkbeta(is)
      if(nbeta(is) .gt. nbrx) &
           call report_error('readvan','nbeta gt nbrx', nbeta(is))
      do 446 j=1,nbeta(is)
         read (iunit) lll(j,is),eee(j),(betar(i,j,is),i=1,kkbeta(is))
         do 446 k=j,nbeta(is)
            read (iunit) dion(j,k,is),ddd(j,k),qqq(j,k,is),&
                 (qfunc(i,j,k,is),i=1,kkbeta(is)),&
                 ((qfcoef(i,lp,j,k,is),i=1,nqf(is)),lp=1,nqlc(is))

            dion(j,k,is)=dion(j,k,is)/rydb1_eva1
            dion(k,j,is)=dion(j,k,is)

            ddd (k,j)=ddd (j,k)
            qqq (k,j,is)=qqq (j,k,is)
            do 445 i=1,kkbeta(is)
               qfunc(i,k,j,is)=qfunc(i,j,k,is)
 445        continue
             do lp=1,nqlc(is)
             enddo
            do 446 i=1,nqf(is)
               do 446 lp=1,nqlc(is)
                  qfcoef(i,lp,k,j,is)=qfcoef(i,lp,j,k,is)
 446  continue
! 7.1 addition
      if (10*iver(1,is)+iver(2,is).ge.72) then
         read(iunit) (iptype(j),j=1,nbeta(is)),npf,ptryc
      endif        
      read (iunit) rcloc,(vnl(i,0,is),i=1,mesh(is))
              
      if (ifpcor.gt.0) then 
         nlcc(is) = .true.
         read (iunit) rpcor
         read (iunit) (rho_atc(i,is),i=1,mesh(is))
      else 
         rpcor = 0.0 
      endif
         
!
      read (iunit) (ru(i,is),i=1,mesh(is))
      read (iunit) (rho_at(i,is),i=1,mesh(is))
!
      if (tlog(is)) then
         read(iunit)(r(i,is),i=1,mesh(is))
         read(iunit)(rab(i,is),i=1,mesh(is))
      else
!     ------------------------------------------------------
!     PROGRAMS USE ORIGINAL HERMAN SKILLMAN MESH:
!     MESH IS ALWAYS = INTEGER * 40 + 1
!     (Z IS THE ATOMIC NUMBER AS ABOVE)
!
         nblock = (mesh(is))/40
         i=1
         r(i,is)=0.0
         dx(is)=0.88534138/z**(1.0/3.0)
         deltax=0.0025*dx(is)
         do 180 j=1,nblock
            do 179 k=1,40
               i=i+1
179        r(i,is)=r(i-1,is)+deltax
180      deltax=deltax+deltax
      endif
      r(0,is) = -r(2,is)
      do i = 1, nbeta(is)
         betar(0,i,is) = betar(1,i,is)-betar(2,i,is)
      enddo

!     converting Ryd-bohr to eV-A 
      do i = 1, nbeta(is) 
         do j = 1,kkbeta(is) 
           betar(j,i,is) = rydb2_eva2*betar(j,i,is)  
         enddo 
      enddo
          
      
      if (iver(1,is) .ge. 6) then
         if (iver(1,is).ge.7) then 
           read (iunit) nchi(is)
         else
           nchi(is) = nvales(is)
         endif
         read(iunit)((chi(i,j,is),i=1,mesh(is)),j=1,nchi(is))
         do i =1,nchi(is)
            j = nnlz(i) /100
            lchi(i,is) = nnlz(i)/10 - j * 10
            chi(0,i,is) = chi(1,i,is)-chi(2,i,is)
         enddo
#ifdef DEBUG4
         do j = 1, nchi(is)
            do i =1,mesh(is)
             write(nconso,*) r(i,is),&
                             chi(i,j,is),sqrt(rho_at(i,is)/zp(is))
            enddo
         enddo
#endif DEBUG4
      else
         nchi(is) = lmax(is)
         do i=1,nchi(is)
            lchi(i,is) = i -1
         enddo
! crude guess for the wave functions
         do j=1,nchi(is)
            do i=1,mesh(is)
               chi(i,j,is) = sqrt(rho_at(i,is)/zp(is))
            enddo
            chi(0,j,is) = chi(1,j,is)-chi(2,j,is)
         enddo
#ifdef DEBUG4
         do j = 1, nchi(is)
            do i =1,mesh(is)
             write(nconso,*) r(i,is),&
                             chi(i,j,is),sqrt(rho_at(i,is)/zp(is))
            enddo
         enddo
#endif DEBUG4
      endif

      close(iunit)

! setup quantities to be consistent with stefanos program
!     put rucore in vion
!     lloc(is) = 0
      do  i=2,mesh(is)
         vnl(i,lloc(is),is)=vnl(i,0,is)/r(i,is)
      enddo
      vnl(1,lloc(is),is)=vnl(2,lloc(is),is)

!     set the max angular momentum to be use outside this routine
      nlnum = lmax(is)
      lmax(is) = lmax(is) -1


!------------------------------------------------------------------------------
!                  GENERATE REPORT OF PSEUDOPOTENTIAL WRITTEN
!------------------------------------------------------------------------------
      IF (exfact.EQ. 0.) XCTIT = '      CEPERLEY-ALDER'
      IF (exfact.EQ.-1.) XCTIT = '              WIGNER'
      IF (exfact.EQ.-2.) XCTIT = '     HEDIN-LUNDQVIST'
      IF (exfact.EQ.-3.) XCTIT = ' GUNNARSON-LUNDQVIST'
      IF (exfact.GT.0.)  XCTIT = '      SLATER X-ALPHA'
      IF (exfact.EQ. 1.) XCTIT = ' C-A + B88gx + LYPgc'
      IF (exfact.EQ. 2.) XCTIT = ' C-A + B88gx'
      IF (exfact.EQ. 2.) XCTIT = ' C-A + B88gx'
      IF (exfact.EQ. 4.) XCTIT = ' Perdew Wang 1991   '

      WRITE (nconso,81) IS
   81 FORMAT (/4X,60(1H=)/4X,'|  PSEUDOPOTENTIAL REPORT',&
              ' FOR ATOMIC SPECIES:',I3,11X,'|')

      write(nconso,82) 'pseudo potential version', iver(1,is), &
           iver(2,is),iver(3,is)
 82   FORMAT (4X,'|  ',1A30,3I4,13x,' |' /4X,60(1H-))
      
      WRITE (nconso,83) LINE,XCTIT
   83 FORMAT (4X,'|  ',2A20,' EXCHANGE-CORR  |')

      WRITE (nconso,85) Z,IS,Zp(IS)
   85 FORMAT (4X,'|  Z(nuclear) =',F5.0,4X,'Z(valence)\(',I2,'\) =',&
              F5.0, 14X,'|')

      WRITE (nconso,86) no_yes(ifpcor),rpcor
   86 FORMAT (4X,'|  Non linear core correction included: ',a3,16X,'|',&
            / 4X,'|  Core radius non lin core corr.(RPCOR) =',&
                     F10.5,3X,'a.u.','|')

      WRITE(nconso,1030) etotpseu
 1030 FORMAT (4X,'|  ATOMIC ENERGY = ',F14.9,' Ry',23X,'|')

      WRITE (nconso,87)
   87 FORMAT(4X,'|  Self consistent all electron atomic config:',13X,&
                '|',/4X,'|  INDEX    ORBITAL      OCCUPATION      ENERGY(Ry)',8X,'|')

      WRITE (nconso,88) (I,NNLZ(I),WWNL(I),EE(I),I=1,NVALES(IS))
   88 FORMAT(4X,'|',I5,I11,5X,F10.2,4X,F14.9,9X,'|')

      WRITE (nconso,90)  (rinner(i,is),i=1,lmax(is)*2+1)
   90 FORMAT(4X,'|  Radii for conservation of augmentation charge moments:',2X,'|',/4X,'|  RINNER(a.u.) = ',5F8.4,20X,'|')
   
      WRITE (nconso,91)
   91 FORMAT(4X,'|  (see Phys Rev B 47 10142 (1993), Eq.28)',17X,'|')

      WRITE (nconso,71)
 71   FORMAT(4X,'|  NEW GENERATION SCHEME:',34X,'|')

      WRITE (nconso,78)
 78   FORMAT(4X,'|  Partial wave set used to generate projectors:',&
            11X,'|') 

      WRITE (nconso,72) NBETA(IS),KKBETA(IS),RCLOC
 72   FORMAT(4X,'|  Number of radial partial waves (NBETA) = ',i6,9X,&
            '|',/4X,'|  Number of radial gridpts per wave (KKBETA) = ',i6,&
            5x,'|',/4X,'|  Pseudiz. radius for the local pspot (RCLOC) = ',f5.2,' a.u.',&
      '|',/4X,'|  Partial wave set for generating the pseudopot: ',9X,&
      '|',/4X,'|    IBETA   L        EPSILON(Ry)   RCUT(a.u.)',13X,'|')

      DO 700 J=1,NBETA(IS)
         LP=LLL(J,is)+1
         WRITE (nconso,73) J,LLL(J,is),EEE(J),rc(LP,IS)
 73      FORMAT(4X,'|',5X,I2,4X,I2,4X,F14.9,F9.2,18X,'|')
 700  CONTINUE

      WRITE (nconso,99)
   99 FORMAT (4X,60(1H=))

!     plot partial core correction
!     open(22,file='partialcore.dat',status='unknown' )
!     rewind(22)
!     do i = 1,mesh(is)
!        write(22,*) r(i,is),rho_atc(i,is),rho_at(i,is)
!     enddo
!     close(22)


      RETURN
      END
!     ------------------------------------------------------------
!     explanatory comments
!     ------------------------------------------------------------
!
!     Description of variables : 
!
!     line    name of chemical element (character*20)
!     z        atomic number of element
!     zp        pseudo atomic number (net charge of bare ion core)
!     exfact   encodes type of exchange-correlation to use
!        if (exfact.eq.-1.) xctit='              wigner'
!        if (exfact.eq.-2.) xctit='     hedin-lundqvist'
!        if (exfact.eq.-3.) xctit=' gunnarson-lundqvist'
!        if (exfact.gt.0.)  xctit='      slater x-alpha'
!     nvales   number of l states to include
!        nvales=1  -->  s
!        nvales=2  -->  s,p
!        nvales=3  -->  s,p,d
!     mesh     number of radial mesh points
!     etotpseu     total energy of pseudo atom in reference config
!     nnlz     100's place --> n quantum number
!               10's place --> l quantum number
!                1's place --> (m quantum number) (really always 0)
!     wwnl     occupation
!     ee       eigenvalue
!     Note: nnlz,wwnl,ee give info on pseudo eigenstates; these are
!           always listed in the order s, p, d in current version
!     mesh     number of radial mesh points
!     keyps    encoding of type of pseudopotential:
!            0 --> standard hsc pseudopotential with exponent 4.0
!            1 --> standard hsc pseudopotential with exponent 3.5
!            2 --> vanderbilt modifications using defaults
!            3 --> new generalized eigenvalue pseudopotentials
!            4 --> frozen core all-electron case
!     ifpcor   1 if "partial core correction" of louie, froyen,
!                 & cohen to be used; 0 otherwise
!     rinner   radius at which to cut off partial core or q_ij
!     For true frozen core case, use keyps=4, ifpcor=1, rinner=0.
!
!     For keyps = 3 :
!
!     rc       cutoff radii for s,p,d respectively
!     nbeta    number of beta functions (sum over all l)
!     kkbeta   last radial mesh point used to describe functions
!                 which vanish outside core
!     lll      lll(j) is l quantum number of j'th beta function
!     eee      energy at which construction was done
!     beta     beta function
!     ddd0     bare pseudopotential matrix (ionic and screening
!                parts subtracted out)
!     ddd      screened pseudopotential matrix (reference config)
!     qqq      Q_ij matrix
!     qfunc    Q_ij(r) function
!     qfcoef   coefficients to pseudize qfunc for different total
!                angular momentum (see below)
!     rcloc    cutoff radius used to construct local potential
!     rucore   bare local potential (see note below)
!     rho_atc   partial core charge
!     ru       screened local potential (see note below)
!     rho_at   charge density of pseudo atom (reference config)
!
!     Note:    For consistency with HSC pseudopotentials etc., the
!              program carries a bare local potential rucore for
!              each l value.  For keyps=3 they are all the same.
!              In general, ru is the screened s potential (again
!              for keyps=3 it doesn't matter).
!
!     ------------------------------------------------------
!     Important:
!     ------------------------------------------------------
!     potentials, e.g. rucore, are really r*v(r)

!     wave funcs, e.g. snl, are really proportional to r*psi(r)
!       and are normalized so int dr (snl**2) = 1
!     thus psi(r-vec)=(1/r)*snl(r)*y_lm(theta,phi)
!     conventions carry over to beta, etc
!     charge dens, e.g. rscore, really 4*pi*r**2*rho
!     ------------------------------------------------------
!
!     ------------------------------------------------------
!     Notes on qfunc and qfcoef:
!     ------------------------------------------------------
!     Since Q_ij(r) is the product of two orbitals like
!     psi_{l1,m1}^star * psi_{l2,m2}, it can be decomposed by
!     total angular momentum L, where L runs over | l1-l2 | ,
!     | l1-l2 | +2 , ... , l1+l2.  (L=0 is the only component
!     needed by the atomic program, which assumes spherical
!     charge symmetry.)
!
!     Recall  qfunc(r) = y1(r) * y2(r)  where y1 and y2 are the
!     radial parts of the wave functions defined according to
!
!       psi(r-vec) = (1/r) * y(r) * Y_lm(r-hat)  .
!
!     For each total angular momentum L, we pseudize qfunc(r)
!     inside rc as:
!
!       qfunc(r) = r**(L+2) * [ a_1 + a_2*r**2 + a_3*r**4 ]
!
!     in such a way as to match qfunc and its 1'st derivative at
!     rc, and to preserve
!
!       integral dr r**L * qfunc(r)   ,
!
!     i.e., to preserve the L'th moment of the charge.  The array
!     qfunc has been set inside rc to correspond to this pseudized
!     version using the minimal L, namely L = | l1-l2 | (e.g., L=0
!     for diagonal elements).  The coefficients a_i (i=1,2,3)
!     are stored in the array qfcoef(i,L+1,j,k) for each L so that
!     the correctly pseudized versions of qfunc can be reconstructed
!     for each L.  (Note that for given l1 and l2, only the values
!     L = | l1-l2 | , | l1-l2 | +2 , ... , l1+l2 are ever used.)
!     ------------------------------------------------------
!
!     Note that some of the variables included in the pseudo
!     file (e.g. rc, wwnl) will not be used by the solid state
!     program, but are included to help identify the pseudopo-
!     tential (i.e. they are printed out in subroutine psrprt).
!
!     Also arrays like ru, ddd, and rho_at are non-essential,
!     but are provided so that they can be used for generating
!     a starting guess at the potential.




!
!----------------------------------------------------------------------
      subroutine setlocal(ip, pscore, psp, npspts,psgmax)
!----------------------------------------------------------------------
!
!   this subroutine calculates the local-potential fourier coefficients
!
      use van_us_data_module
      implicit none
      include 'readvan.h'
      complex*16 aux(ndm) 
      real *8 aux1(ndm) 
      real*8 rcut, vlcp, g2a, gx, arg, e2,gg1,argscm
!     Should be changed
      real*8 xp(4,4)
      integer  lp, l, i, ng, na, np, nt, msh
! cutoff for numeric integration - avoids spurious large-r tails
      parameter (rcut=10.0,nt=1,e2=2.0d0)

      integer ip, npspts
      real *8 pscore,  psp(npspts),psgmax
      external erfc
      real*8   erfc 

!     xp(1,1) = 1.0d0 
!     xp(2,2) = 1.0d0

      argscm = psgmax*bohr/dble(npspts-1)
      do i = 1,npsx 
        tvanp(i) = .true.
      enddo

!
!
!  calculate the fourier coefficients of the local part of the bare
!  pseudopotential
!
! Pseudopotentials in numerical form (Vnl(lloc) contain the local part)
! NB: in order to perform the Fourier transform, a term erf(r)/r is
!    subtracted in real space and added again in G space

               do i=1,mesh(ip)
                  if (r(i,ip).gt.rcut) then
                     msh=i
                     go to 5
                  end if
               end do
               msh = mesh(ip)
 5             msh = 2*((msh+1)/2)-1
! force msh to be odd for simpson integration
               l = lloc(ip)
               do i = 1,msh
                  aux1(i) = r(i,ip)*(r(i,ip)*vnl(i,l,ip)+zp(ip)*e2)
               enddo
! simpsons integration of aux1
               if (tlog(ip)) then
                  if(tvanp(ip)) then
                     call radlg1(msh,aux1,rab(1,ip),vlcp)
                  else
                     call radlg(msh,aux1,r(1,ip),dx(ip),vlcp)
                  endif
               else
                  call radin(msh,dx(ip),aux1,vlcp)
               endif
               psp(1) = fpi*&
                    (vlcp+ zp(ip)*e2*r(1,ip)**2/2.0)

! the second term estimates the integral from 0 to r(1,ip)

! G .ne. 0 term
               do ng=2,npspts
                  gg1 = (argscm*dble(ng-1))**2
                  gx = sqrt(gg1)
                  do i = 1,msh
                      aux1(i) = sin(gx*r(i,ip))/gx*&
                      (r(i,ip)*vnl(i,l,ip)+zp(ip)*e2*&
                      (1.0d0-erfc(r(i,ip))) )
                  enddo
                  if (tlog(ip)) then
                      if(tvanp(ip)) then
                         call radlg1(msh,aux1,rab(1,ip),vlcp)
                      else
                         call radlg(msh,aux1,r(1,ip),dx(ip),vlcp)
                      endif
                  else
                      call radin(msh,dx(ip),aux1,vlcp)
                  endif
                  vlcp = fpi*(vlcp - &
                         e2*zp(ip)*exp(-gg1/4.0)/gg1)
                  psp(ng) =  vlcp
               end do
!
      pscore = psp(1)

      return
      end

!
!----------------------------------------------------------------------
      subroutine dvloc_of_g (nplwv,dnlg0,volc,dvloc,ip)
!----------------------------------------------------------------------
!
      use van_us_data_module 
      implicit none
      integer, intent(in)   :: nplwv 
      real*8, intent(in)    :: dnlg0(nplwv,3) 
      real*8, intent(in)    :: volc 
      real*8, intent(inout) :: dvloc(nplwv) ! dVloc/dG
      integer,intent(in)    :: ip   ! specie for which dV(G^2)/dG^2 is calculated
      include 'readvan.h'

!----------------------------------------------------------------------
      real*8 rcut, vlcp, g2a, gx
      real*8 ertemp
! cutoff for numeric integration - avoids spurious large-r tails
      parameter (rcut=10.0)

      integer i, ng, l, msh
      real*8, allocatable :: temp(:) 
      real*8              :: gabs,gabsold
      external erfc
      real*8   erfc

      allocate(temp(mesh(ip)))

      l = lloc(ip) ! vnl(:,l,ip) contains local part of pseudopotential

! the  G=0 component is not computed anyway

      dvloc(1)=0.0
      gabsold = sum((bohr*dnlg0(1,1:3))**2)

! Pseudopotentials in numerical form (Vnl(lloc) contain the local part)
! NB: in order to perform the Fourier transform, a term erf(r)/r is
!    subtracted in real space and added again in G space

         do i=1,mesh(ip)
            if (r(i,ip).gt.rcut) then
               msh=i
               go to 5
            end if
         end do
         msh = mesh(ip)
 5       msh = 2*((msh+1)/2)-1
! force msh to be odd for simpson integration

         do ng=2,nplwv
            gabs = sum((bohr*dnlg0(ng,1:3))**2)
            if ((gabs.gt.1.0e-8).and. &
                (abs(gabs-gabsold).gt.1.0e-8)) then
               gabsold = gabs
               gx = sqrt(gabs)     ! r,rab is in bohr
! DV(g)/Dg = Integral of r (Dj_0(gr)/Dg) V(r) dr
               do i=1,msh
                  if (r(i,ip) .lt. 1e-9) then
                     ertemp = 2.d0/dsqrt(pi)
                  else
                     ertemp = (1-erfc(r(i,ip  )))/r(i,ip  )
                  endif
                  temp(i) = r(i ,ip ) *  &
              ( r(i,ip)*cos(gx*r(i,ip))/gx-sin(gx*r(i,ip))/gx**2)* &
              ( vnl(i,l,ip) + zp(ip)*2.0d0*ertemp ) 
               end do
               if (tlog(ip)) then
                  if(tvanp(ip)) then
                     call radlg1(msh,temp,rab(1,ip),vlcp) 
                  else
                     call radlg(msh,temp,r,dx,vlcp) 
                  endif
               else
                  call radin(msh,dx,temp,vlcp)
               endif   

! DV(g^2)/Dg^2 = (DV(g)/Dg)/2g
               vlcp = fpi/volc/2.0/gx*vlcp
! subtract the long-range term
               g2a = gabs/4.0
               vlcp = vlcp + fpi/volc*zp(ip)*2.0d0*exp(-g2a)*(g2a+1.0) &
                    /(gabs)**2

            end if
            dvloc(ng) = vlcp
         end do
      return
      end

!----------------------------------------------------------------------
      subroutine dncore_dg2(nplwv,dnlg0,volc,dncore,ip)
!----------------------------------------------------------------------
!
!     calculate d(n_core(G))/d|G|^2
!     n_core is the partial core rho_atc
!
!----------------------------------------------------------------------

      use van_us_data_module 
      implicit none
      integer, intent(in)    :: nplwv 
      real*8,  intent(in)    :: dnlg0(nplwv,3) 
      real*8,  intent(in)    :: volc 
      real*8,  intent(inout) :: dncore(nplwv)
      integer, intent(in)    :: ip  ! specie for which d(n_core(G))/d|G|^2  
                                    ! is calculated
      include  'readvan.h'

!----------------------------------------------------------------------
      real*8 rcut, vlcp, g2a, gx
! cutoff for numeric integration - avoids spurious large-r tails
      parameter (rcut=10.0)

      integer i, ng, l, msh
      real*8, allocatable :: temp(:) 
      real*8              :: gabs,gabsold
      external erfc
      real*8   erfc

      allocate(temp(mesh(ip)))

! the  G=0 component is not computed anyway

      dncore(1)=0.0
      gabsold = sum((bohr*dnlg0(1,1:3))**2)

      do i=1,mesh(ip)
            if (r(i,ip).gt.rcut) then
               msh=i
               go to 5
            end if
      end do
      msh = mesh(ip)

! force msh to be odd for simpson integration
5     msh = 2*((msh+1)/2)-1

      do ng=2,nplwv
            gabs = sum((bohr*dnlg0(ng,1:3))**2)
            if ((gabs.gt.1.0e-8).and. &
                (abs(gabs-gabsold).gt.1.0e-8)) then
               gabsold = gabs
               gx = sqrt(gabs)     ! r,rab is in bohr
! DV(g)/Dg = Integral of r (Dj_0(gr)/Dg) V(r) dr
               do i=1,msh
                  if (r(i,ip).lt.1.0e-12) then 
                     temp(i)  = rho_atc(i,ip)
                  else   
                     temp(i) =  &
              (cos(gx*r(i,ip))/gx-sin(gx*r(i,ip))/(r(i,ip)*gx*gx))* &
              ( rho_atc(i,ip)) 
                  endif 
               end do
               if (tlog(ip)) then
                  if(tvanp(ip)) then
                     call radlg1(msh,temp,rab(1,ip),vlcp) 
                  else
                     call radlg(msh,temp,r,dx,vlcp) 
                  endif
               else
                  call radin(msh,dx,temp,vlcp)
               endif   

! DV(g^2)/Dg^2 = (DV(g)/Dg)/2g
               vlcp = vlcp/(gx*2.0d0)

            end if
            dncore(ng) = vlcp
      end do
      return
      end
!----------------------------------------------------------------------
      subroutine setlocal1(ip,nplwv,dnlg0,volc,vloc)
!----------------------------------------------------------------------
!
      use van_us_data_module
      implicit none
      integer, intent(in)   :: nplwv
      real*8, intent(in)    :: dnlg0(nplwv,3)
      real*8, intent(in)    :: volc
      real*8, intent(inout) :: vloc(nplwv) ! dVloc/dG
      integer,intent(in)    :: ip
      include 'readvan.h'       
!
!   this subroutine calculates the local-potential fourier coefficients
      complex*16 aux(ndm) 
      real *8 aux1(ndm) 
      real*8 rcut, vlcp, g2a, gx, arg, e2,gabs,argscm
      integer  lp, l, i, ng, na, np, nt, msh
! cutoff for numeric integration - avoids spurious large-r tails
      parameter (rcut=10.0,nt=1,e2=2.0d0)

      integer npspts
      real *8 psgmax
      external erfc
      real*8   erfc 

      do i = 1,npsx 
        tvanp(i) = .true.
      enddo

!
!  calculate the fourier coefficients of the local part of the bare
!  pseudopotential
!
! Pseudopotentials in numerical form (Vnl(lloc) contain the local part)
! NB: in order to perform the Fourier transform, a term erf(r)/r is
!    subtracted in real space and added again in G space
               do i=1,mesh(ip)
                  if (r(i,ip).gt.rcut) then
                     msh=i
                     go to 5
                  end if
               end do
               msh = mesh(ip)
 5             msh = 2*((msh+1)/2)-1
! force msh to be odd for simpson integration
               l = lloc(ip)
               do i = 1,msh
                  aux1(i) = r(i,ip)*(r(i,ip)*vnl(i,l,ip)+zp(ip)*e2)
               enddo
! simpsons integration of aux1
               if (tlog(ip)) then
                  if(tvanp(ip)) then
                     call radlg1(msh,aux1,rab(1,ip),vlcp)
                  else
                     call radlg(msh,aux1,r(1,ip),dx(ip),vlcp)
                  endif
               else
                  call radin(msh,dx(ip),aux1,vlcp)
               endif
               vloc(1) = fpi* &
                    (vlcp+ zp(ip)*e2*r(1,ip)**2/2.0)

! the second term estimates the integral from 0 to r(1,ip)

! G .ne. 0 term
               do ng=2,nplwv
                  gabs = sum((bohr*dnlg0(ng,1:3))**2)
                  gx = sqrt(gabs)
                  if (gabs.gt.1.0d-10) then 
                    do i = 1,msh
                        aux1(i) = sin(gx*r(i,ip))/gx* &
                        (r(i,ip)*vnl(i,l,ip)+zp(ip)*e2* &
                        (1.0d0-erfc(r(i,ip))) )
                    enddo
                    if (tlog(ip)) then
                        if(tvanp(ip)) then
                           call radlg1(msh,aux1,rab(1,ip),vlcp)
                        else
                           call radlg(msh,aux1,r(1,ip),dx(ip),vlcp)
                        endif
                    else
                        call radin(msh,dx(ip),aux1,vlcp)
                    endif
                    vlcp = fpi*(vlcp - e2*zp(ip)*exp(-gabs/4.0)/gabs)
                    vloc(ng) =  vlcp
                  else 
                    vloc(ng) = 0.0d0 
                  endif
               end do

      return
      end


!======================================================================

      subroutine getvan(iznuc,pscore,psgmax,&
                     icharg,nlnum,psp,volc,&
                     mmax,rlog,&
                     radius,phiatm,rho_rad,&
                     mmaxx,npspts,iunit,&
                     nkprun,nbands,nplwv,nrplwv,nrplwv_global,nions,&
                     nsp,nspec,nionsp, lspsi, nconso) 


!     GETVAN reads the pseudo-potential. 
!     Then nsp = nspec all pseudo-potentials has been read into the
!     readvan.h variables and setuspot is called to initialize the 
!     ultra-soft potential.

!     The file format for the pseudo-potential is generel for 
!     a Vanderbildt ultra-soft pseudo-potential. See readvan.F.
!     

!     Unit for the psuedo-potential is Rydberg-a0, working in these 
!     units until returning to dacapo, there working in eV,Angstrom.

!     Output 
!       pscore  : G = 0 component of the local pseudo-potential
!       psp     : local potential
!       phiatm  : atomic wavefunctions 
!       rho_rad : pseudo-core density in reciprocal space
!       
!       + the variables given in van_us_decl.h 

!      readvan.h variables are used only to read the pseudo-potential. 

!=======================================================================
      use van_us_data_module
!=======================================================================
      implicit none
!=======================================================================
      include   'readvan.h'

      integer   iznuc, mmaxx,npspts,iunit,mmax,nlnum,icharg,nconso
      integer   nkprun,nbands,nplwv,nrplwv,nrplwv_global
      integer   nions,nsp,nspec,nionsp(nspec) 
      integer   ifpcor,ng,ir,msh,l
      real *8   volc
      real *8   psp(npspts),rlog
      real *8   rho_rad(npspts)
      real *8   pscore,psgmax
      real *8   radius(mmaxx)
      real *8   phiatm(mmaxx,0:2)
      real *8   arg,q1,simps
!=======================================================================
      logical*4 lskip, lspsi
!     locals 
      real *8   worint(mmaxx)
      real *8   eps,rcut,argscm  
      parameter(rcut = 6.0d0)
      parameter(eps = 1d-7)
      integer   typep,i,j ,n
      integer   npseudoinit
      data      npseudoinit/0/
      save      npseudoinit
!=======================================================================
!     check npsx
      if (nspec.gt.npsx) stop 'Error nspec>npsx='

      npseudoinit = npseudoinit + 1
      typep = 2
!     read pseudo-potential 
      call READVAN(nsp,iunit,nconso,typep,nlnum,ifpcor)
      icharg = zp(nsp) 
! 
      mmax  = mesh(nsp)

      do i = 1,mmax 
        radius(i) = r(i,nsp) 
      enddo

      nlnum = min(nchi(nsp),3)

      iznuc = zp(nsp)

!     find pscore and local-pseudo potential psp 
      call setlocal(nsp,pscore,psp,npspts,psgmax)
!     pscore and psp now has unit Ry a0^3
      pscore = rydb3_eva3*pscore 
      do i = 1,npspts 
        psp(i) = rydb3_eva3*psp(i)
      enddo
 
      argscm = psgmax*bohr/dble(npspts-1)

!     r(i) = exp(-a + (i-1)/b) -exp(-a) 
!     extract b from rab(i) and r(i)
      rlog = (rab(10,nsp)-rab(1,nsp))/r(10,nsp)

!     set phiatm 
      do n = 1,nchi(nsp)
        do i = 1,mesh(nsp)
          phiatm(i,lchi(n,nsp)) = chi(i,n,nsp)
          worint(i) = phiatm(i,lchi(n,nsp))*phiatm(i,lchi(n,nsp))
        enddo
        call radlg1(mesh(nsp),worint,rab(1,nsp),q1)
        call radlg(mesh(nsp),worint,radius,rlog,q1)
      enddo
!
!     phiatm is now (sqrt(4 pi) r phi) change into (sqrt(4 pi) phi)
      do n = 1,nchi(nsp)
        do i = 2,mesh(nsp) 
          phiatm(i,lchi(n,nsp)) = phiatm(i,lchi(n,nsp))/radius(i) 
        enddo 
        phiatm(1,lchi(n,nsp)) = phiatm(2,lchi(n,nsp))
      enddo 
      call radlg(mesh(nsp),worint,radius,rlog,q1)
      

      argscm = psgmax*bohr/dble(npspts-1)
      if (ifpcor.gt.0) then 
!       Fourier transform partial core density
        do ir=1,mesh(nsp)
           if (r(ir,nsp).gt.rcut) then
               msh=ir
               go to 5
            end if
         end do
         msh = mesh(nsp)
5        msh = 2*((msh+1)/2)-1

        do ng = 1,npspts
          do ir = 1,msh
            arg = r(ir,nsp)*argscm*dble(ng-1) 
            if (arg.lt.eps) then
              worint(ir) = rho_atc(ir,nsp)
            else
              worint(ir) = sin(arg)/arg * rho_atc(ir,nsp)
            endif                                
          enddo   
          call radlg1(msh,worint,rab(1,nsp),q1)
!         q1 now contains fourier transform of rho_rad
          rho_rad(ng) = q1                          
        enddo                 
        write(nconso,*) 'NCORE: ',nsp,rho_rad(1)
      else 
        do ng = 1,npspts 
          rho_rad(ng) = 0.0d0
        enddo 
      endif

      if (npseudoinit.eq.nspec) then 
!       all pseudo-potentials has been read by readvan
!       set a number of variables from van_us_decl.h :
!       nh,nkbtona,nkbtonh,nhtom,indv,dvan
        call setuspot(psgmax,nplwv,nrplwv,nrplwv_global,nspec,&
                     nions,nionsp,nbands,nkprun,volc,lspsi)
      endif

      return 
      end


!
! ---------------------------------------------------------------
      SUBROUTINE RADIN(MESH,C,FUNC,ASUM)
! ---------------------------------------------------------------
!     SIMPSONS RULE INTEGRATION FOR HERMAN SKILLMAN MESH
!     MESH - # OF MESH POINTS
!     C    - 0.8853418/Z**(1/3.)
!
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION FUNC(mesh)
      A1=0.0
      A2E=0.0
      ASUM=0.0
      H=0.0025*C
      NBLOCK=MESH/40
      I=1
!      FUNC(1)=0.0
      DO 39 J=1,NBLOCK
      DO 38 K=1,20
      I=I+2
      I1=I-1
      A2ES=A2E
      A2O=FUNC(I1)/12.0
      A2E=FUNC(I)/12.0
      A1=A1+5.0*A2ES+8.0*A2O-A2E
!      FUNC(I1)=ASUM+A1*H
      A1=A1-A2ES+8.0*A2O+5.0*A2E
!      FUNC(I)=ASUM+A1*H
      fi = ASUM+A1*H
   38 CONTINUE
!      ASUM=FUNC(I)
      asum = fi
      A1=0.0
   39 H=H+H
!
      RETURN
      END
!
!-----------------------------------------------------------------------
      subroutine radlg(mesh,func,r,dx,asum)
!-----------------------------------------------------------------------
!
!     simpson's rule integrator for function stored on the
!     radial logarithmic mesh
!
!.....logarithmic radial mesh information
      IMPLICIT REAL*8 (A-H,O-Z)
      dimension r(mesh)
!.....function to be integrated
      dimension func(mesh)
!
!.....variable for file = 0
!
!     routine assumes that mesh is an odd number so run check
      if ( mesh - ( mesh / 2 ) * 2 .ne. 1 ) then
        write(*,*) '***error in subroutine radlg'
        write(*,*) 'routine assumes mesh is odd but mesh =',mesh
        stop
      endif

      asum = func(1)*r(1)+func(mesh)*r(mesh)
      do  i = 2,mesh-1,2
         asum = asum + 4.0d0*func(i)*r(i)+2.0d0*func(i+1)*r(i+1)
      enddo
      asum = asum*dx/3.0d0
      return
      end

!
!-----------------------------------------------------------------------
      subroutine radlg1(mesh,func,rab,asum)
!-----------------------------------------------------------------------
!
!     simpson's rule integrator for function stored on the
!     radial logarithmic mesh
!
!.....logarithmic radial mesh information
      IMPLICIT REAL*8 (A-H,O-Z)
      dimension rab(mesh)
!.....function to be integrated
      dimension func(mesh)
!
!.....variable for file = 0
!
!     routine assumes that mesh is an odd number so run check
      if ( mesh - ( mesh / 2 ) * 2 .ne. 1 ) then
        write(*,*) '***error in subroutine radlg'
        write(*,*) 'routine assumes mesh is odd but mesh =',mesh
        stop
      endif

      asum = 0.0d0
      r12 = 1.0d0 / 12.0d0
      f3  = func(1) * rab(1) * r12
!      func(1) = 0.0d0

      do 100 i = 2,mesh-1,2
        f1 = f3
        f2 = func(i) * rab(i) * r12
        f3 = func(i+1) * rab(i+1) * r12
        asum = asum + 5.0d0*f1 + 8.0d0*f2 - 1.0d0*f3
!        func(i) = asum
        asum = asum - 1.0d0*f1 + 8.0d0*f2 + 5.0d0*f3
!        func(i+1) = asum
100   continue
      return
      end
!-------------------------------------------------------------------------
      SUBROUTINE BESS(XG,L,MMAX,R,JL)
!-------------------------------------------------------------------------
!     CALCULATES SPHERICAL BESSEL FUNCTIONS  j_l(Gr)
!
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(EPS=1.E-8)
      REAL*8   JL(MMAX),R(MMAX)
 
      IF(L.EQ.1) THEN                      !   S  PART
        IF(XG.LT.EPS) THEN
         DO 41 IR=1,MMAX
 41        JL(IR)=1.D0
        ELSE
          JL(1)=1.D0
          DO 42 IR=2,MMAX
            XRG=R(IR)*XG
            JL(IR)=SIN(XRG)/XRG
 42       CONTINUE
        ENDIF
      ENDIF
 
      IF(L.EQ.2) THEN                      !   P  PART
        IF(XG.LT.EPS) THEN
        DO 43 IR=1,MMAX
 43        JL(IR)=0.D0
        ELSE
          JL(1)=0.
          DO 44 IR=2,MMAX
            XRG=R(IR)*XG
            JL(IR)=(SIN(XRG)/XRG-COS(XRG))/XRG
 44       CONTINUE
        ENDIF
      ENDIF
 
      IF(L.EQ.3) THEN                      !   D  PART
        IF(XG.LT.EPS) THEN
        DO 45 IR=1,MMAX
 45       JL(IR)=0.D0
        ELSE
          JL(1)=0.D0
          DO 46 IR=2,MMAX
           XRG=R(IR)*XG
           JL(IR)=(SIN(XRG)*(3./(XRG*XRG)-1.)&
                   -3.*COS(XRG)/XRG) /XRG
 46       CONTINUE
        ENDIF
      ENDIF
 
      IF(L.EQ.4) THEN                      !   F  PART
        IF(XG.LT.EPS) THEN
        DO 47 IR=1,MMAX
 47        JL(IR)=0.D0
        ELSE
          JL(1)=0.D0
          DO 48 IR=2,MMAX
           XRG=R(IR)*XG
           XRG2=XRG*XRG
           JL(IR)=( SIN(XRG)*(15./(XRG2*XRG)-6./XRG)&
                   +COS(XRG)*(1.-15./XRG2) )/XRG
 48       CONTINUE
        ENDIF
      ENDIF
 
      IF(L.EQ.5) THEN                      !   G  PART
        IF(XG.LT.EPS) THEN
        DO 49 IR=1,MMAX
 49        JL(IR)=0.D0
        ELSE
          JL(1)=0.D0
          DO 50 IR=2,MMAX
           XRG=R(IR)*XG
           XRG2=XRG*XRG
           JL(IR)=( SIN(XRG)*(105./(XRG2*XRG2)-45./XRG2+1.)&
                   +COS(XRG)*(10./XRG-105./(XRG2*XRG)) )/XRG
 50       CONTINUE
        ENDIF
      ENDIF
 
      RETURN
      END

!
!-------------------------------------------------------------------------
      SUBROUTINE DBESS(XG,L,MMAX,R,DJL)
!-------------------------------------------------------------------------
!     CALCULATES DERIVATIVES OF SPHERICAL BESSEL FUNCTIONS  j_l(Gr)
!     WITH RESPECT TO h_alpha,beta (WITHOUT THE FACTOR GAGK(KK,IG)*HTM1)
!     I.E. -x * D(jl(x))/dx
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER(EPS=1.E-8)
      REAL*8   DJL(MMAX),R(MMAX)
 
      IF(L.EQ.1) THEN                      !   S  PART
        IF(XG.LT.EPS) THEN
          DO IR=1,MMAX
            DJL(IR) = 0.D0
          END DO
        ELSE
          DJL(1) = 0.D0
          DO IR=2,MMAX
            XRG=R(IR)*XG
            DJL(IR) = SIN(XRG)/XRG-COS(XRG)
          END DO
        ENDIF
      ENDIF
 
      IF(L.EQ.2) THEN                      !   P  PART
        IF(XG.LT.EPS) THEN
          DO IR=1,MMAX
            DJL(IR) = 0.D0
          END DO
        ELSE
          DJL(1) = 0.D0
          DO IR=2,MMAX
            XRG=R(IR)*XG
            DJL(IR) = 2.D0*(SIN(XRG)/XRG-COS(XRG))/XRG - SIN(XRG)
          END DO
        ENDIF
      ENDIF
 
      IF(L.EQ.3) THEN                      !   D  PART
        IF(XG.LT.EPS) THEN
          DO IR=1,MMAX
            DJL(IR) = 0.D0
          END DO
        ELSE
          DJL(1) = 0.D0
          DO IR=2,MMAX
            XRG=R(IR)*XG
            DJL(IR) = ( SIN(XRG)*(9.D0/(XRG*XRG)-4.D0) -&
                      9.D0*COS(XRG)/XRG ) /XRG + COS(XRG)
          END DO
        ENDIF
      ENDIF

      IF(L.EQ.4) THEN                      !   F  PART
        IF(XG.LT.EPS) THEN
          DO IR=1,MMAX
            DJL(IR) = 0.D0
          END DO
        ELSE
          DJL(1) = 0.D0
          DO IR=2,MMAX
            XRG=R(IR)*XG
            XRG2=XRG*XRG
            DJL(IR)=SIN(XRG)*(60.D0/(XRG2*XRG2)-27.D0/XRG2+1.d0)&
                 -COS(XRG)*(60.D0/XRG2-7.D0)/XRG
          END DO
        ENDIF
      ENDIF

      IF(L.EQ.5) THEN                      !   G  PART
        IF(XG.LT.EPS) THEN
          DO IR=1,MMAX
            DJL(IR) = 0.D0
          END DO
        ELSE
          DJL(1) = 0.D0
          DO IR=2,MMAX
            XRG=R(IR)*XG
            XRG2=XRG*XRG
            DJL(IR)=SIN(XRG)*(525.D0/(XRG2*XRG2)-240.D0/XRG2+11.D0)/XRG&
                 -  COS(XRG)*(525.D0/(XRG2*XRG2)-65.D0/XRG2+1.D0)
          END DO
        ENDIF
      ENDIF
 
      IF(L.LE.0 .OR. L.GE.6) THEN
        CALL REPORT_ERROR('DBESS',' L NOT PROGRAMMED, L= ',L)
      END IF

      RETURN
      END



!----------------------------------------------------------------------
      subroutine setv(n,sa,sx,incx)
!----------------------------------------------------------------------
!
      implicit real*8 (a-h, o-z)

      real*8 sa, sx(*)
      do 10 i = 1, (n-1)*incx+1, incx
  10  sx(i) = sa
      return
      end
!=======================================================================
      subroutine partialcoreiid(nconso)
      write(nconso,*) '@(#)partialcore.F	0.0 4/3/96'
      return
      end
!=======================================================================
      subroutine partialcore(ngx,ngy,ngz,nions,nionsp,nspec,nplwv,&
           posion,&
           lpctx,lpcty,lpctz,npspts,recc,volc,rho_rad,psgmax,rho_core,&
           mmax,cwork1  )
!=======================================================================
! this subroutine calculates the partial core charge on the real space grid
!
! input : rho_rad 
!         partial core charge on grid of reciprocal lattice vectors
! output: rho_core 
!         real space partial core charge
!
! Multiply the fourier transform of the partialcore charge (rho_rad) with 
! the structure factor and back transform to get the charge density on the 
! real space grid.
         
!=======================================================================
      use run_context
      implicit none

      integer    npspts,nplwv,nions,nspec,ngx,ngy,ngz,nion,ng,mmax
      integer    magic
      integer    n,nn,nnn,nsp
      real*8     rho_rad(npspts,nspec)
      real*8     rho_core(nplwv),nelec,himag,neg
      real*8     vout,g, gxsq,gysq,gzsq ,gdx,gdy,gdz
      real*8     posion(3,nions,nspec),psgmax(nspec),volc
      real*8     gyx,gyy,gyz,gzx,gzy,gzz
      integer    lpctx(ngx),lpcty(ngy),lpctz(ngz)
      real*8     recc(3,3)
      integer    nionsp(nspec)
      integer    ngxh,ngyh,ngzh
      complex*16 cwork1(nplwv)

!     locals
      complex*16 citpi,cstrf,cgdr
      real*8     eps,small,zero
!=======================================================================
      parameter(citpi=(0.0d0,6.2831853072d0),eps=1.d-6,small=1.d-30, &
                zero=0.0d0 )
!=======================================================================
      ngxh = (ngx/2)+1
      ngyh = (ngy/2)+1
      ngzh = (ngz/2)+1

      do ng = 1,nplwv
        rho_core(ng) = 0.0d0 
        cwork1(ng)   = (0.0d0,0.0d0) 
      enddo 

      ng = 1
!     Setup the structure factor
      do 5000 n=1,ngz
         gzx=recc(3,1)*lpctz(n)
         gzy=recc(3,2)*lpctz(n)
         gzz=recc(3,3)*lpctz(n)
         do 4000 nn=1,ngy
            gyx=recc(2,1)*lpcty(nn)
            gyy=recc(2,2)*lpcty(nn)
            gyz=recc(2,3)*lpcty(nn)
            do 3000 nnn=1,ngx
               gxsq=(recc(1,1)*lpctx(nnn)+gyx+gzx)**2
               gysq=(recc(1,2)*lpctx(nnn)+gyy+gzy)**2
               gzsq=(recc(1,3)*lpctx(nnn)+gyz+gzz)**2
               if (((n.ne.ngzh).and.(nn.ne.ngyh))&
                    .and.(nnn.ne.ngxh)) then
                do 2000 nsp=1,nspec
                  cstrf=(0.0d0,0.0d0)
                  do 1000 nion=1,nionsp(nsp)
!=======================================================================
! add the contribution to the structure factor from the ion
!=======================================================================
                     gdz=posion(3,nion,nsp)*lpctz(n)
                     gdy=posion(2,nion,nsp)*lpcty(nn)
                     gdx=posion(1,nion,nsp)*lpctx(nnn)
                     cgdr=-citpi*(gdz+gdy+gdx)
                     cstrf=cstrf+exp(cgdr)
 1000             continue
!=======================================================================
! calculate the magnitude of the reciprocal lattice vector 
!=======================================================================
                  g=sqrt(gxsq+gysq+gzsq)
!=======================================================================
! rho_rad has too be interpolated to find value at g
!=======================================================================
                  call interpolate(g,rho_rad(1,nsp),nspec,&
                                   psgmax(nsp),npspts,vout)
                  cwork1(ng)=cwork1(ng)+vout*cstrf

 2000           continue
               endif
               ng=ng+1
 3000       continue
 4000    continue
 5000 continue

!=======================================================================
! transform into real space
!=======================================================================
      call fft3d(cwork1,ngx,ngy,ngz,1)

      nelec = 0.0d0
      himag  = 0.0d0
      neg   = 0.0d0
      do ng = 1,nplwv
        rho_core(ng) =max(dble(cwork1(ng)),small)
        nelec = nelec + dble(cwork1(ng))
!       check negative or imaginary part   
        himag = himag + abs(dble(cwork1(ng)*cmplx(0.0d0,-1.0d0)))
        neg  = neg  + min(zero,dble(cwork1(ng)))
      enddo

      nelec = nelec/dble(nplwv)
      himag  = himag/dble(nplwv)
      neg   = neg/dble(nplwv)
!      write(nconso,*) 'NCORE: nelec=',nelec

      if ((neg.lt.-1.d-6).or.(himag.gt.1.d-6)) &
         write(nconso,*) 'NCORE: Warning : negative or '//&
                         'imaginary core charge' ,neg,himag  

6000  continue

      return
      end



!=======================================================================
      subroutine interpolate(ginput,vin,nspec,psgmax,npspts,vout) 
!=======================================================================
! this subroutine finds the value for a point g on the reciprocal-grid the 
! value vout from an array vin, which is an array on the radial grid of 
! reciprocal lattice vectors

      implicit none 
      integer   nspec,npspts,naddr,npspt2   
      real*8    psgmax,ginput,vin(npspts)
      real*8    v1,v2,v3,v4,t0,t1,t2,t3
      real*8    argsc,arg,vout,rem
      real*8    sixth
      parameter(sixth=0.166666666666667d0)

!     scaling factor that converts the magnitude of a reciprocal 
!     lattive vector to the corresponding position in the 
!     grid
      npspt2=npspts-2
      argsc=dble(npspts-1)/psgmax

      arg=( argsc*ginput)+1.0d0
      naddr=int(arg)        
      rem=arg - naddr
      if (naddr.gt.npspt2) then                         
        vout = 0.0d0   
      else         
        if (naddr.eq.1) then
           vout = vin(1)
        else
           v1=vin(naddr-1)
           v2=vin(naddr  )
           v3=vin(naddr+1)
           v4=vin(naddr+2)
           t0=v2
           t1=((6.0d0*v3)-(2.0d0*v1)-(3.0d0*v2)-v4)*sixth
           t2=(v1+v3-(2.0d0*v2))*0.5d0
           t3=( v4 - v1+(3.0d0*(v2-v3) ) )*sixth
           vout = (t0+rem*( t1+rem*(t2+rem*t3) ) )
        endif
      endif

      return 
      end
