!***********************************************************************
!     @(#)bastr.f	3.2 12/4/90
!***********************************************************************
      subroutine basid(nconso)
      write(nconso,*) '@(#)bastr.F	1.3 11/11/96'
      return
      end
!=======================================================================
      subroutine bastr(dir,rec,vol)
!=======================================================================
! this subroutine calculates the set of basis vectors in reciprocal
! space.
!
! in real space the basis vectors a1, a2 and a3 are stored in dir(i,j):
!
!                ( dir(1,1) dir(2,1) dir(3,1) )   ( |  |  | )
!     dir(i,j) = ( dir(1,2) dir(2,2) dir(3,2) ) = ( a1 a2 a3)
!                ( dir(1,3) dir(2,3) dir(3,3) )   ( |  |  | )
!
!     a1 = ( dir(1,1) , dir(1,2) , dir(1,3) )
!     a2 = ( dir(2,1) , dir(2,2) , dir(2,3) )
!     a2 = ( dir(3,1) , dir(3,2) , dir(3,3) )
!
! the volume of the unit cell is given by:
!
!     vol = | a1*( a2 x a3) |
!
! the basisvectors in reciprocal space will be given by:
!
!     b1 = 2*pi*( a2 x a3 ) / vol
!     b2 = 2*pi*( a3 x a1 ) / vol
!     b3 = 2*pi*( a1 x a2 ) / vol
!
! which is stored in rec(i,j):
!
!                ( rec(1,1) rec(2,1) rec(3,1) )   ( |  |  | )
!     rec(i,j) = ( rec(1,2) rec(2,2) rec(3,2) ) = ( b1 b2 b3)
!                ( rec(1,3) rec(2,3) rec(3,3) )   ( |  |  | )
!
!=======================================================================
      implicit complex*16 (c)
      implicit double precision (a,b,d-h,o-z)
      dimension dir(3,3)
      dimension rec(3,3)
      data tpi /6.2831853072d0/
!
      rec(1,1)=dir(2,2)*dir(3,3)-dir(3,2)*dir(2,3)
      rec(1,2)=dir(2,3)*dir(3,1)-dir(3,3)*dir(2,1)
      rec(1,3)=dir(2,1)*dir(3,2)-dir(3,1)*dir(2,2)
      rec(2,1)=dir(3,2)*dir(1,3)-dir(1,2)*dir(3,3)
      rec(2,2)=dir(3,3)*dir(1,1)-dir(1,3)*dir(3,1)
      rec(2,3)=dir(3,1)*dir(1,2)-dir(1,1)*dir(3,2)
      rec(3,1)=dir(1,2)*dir(2,3)-dir(2,2)*dir(1,3)
      rec(3,2)=dir(1,3)*dir(2,1)-dir(2,3)*dir(1,1)
      rec(3,3)=dir(1,1)*dir(2,2)-dir(2,1)*dir(1,2)
      vol=dir(1,1)*rec(1,1)+dir(1,2)*rec(1,2)+dir(1,3)*rec(1,3)
      do 100 i=1,3
        do 50 j=1,3
        rec(i,j)=(tpi*rec(i,j))/vol
50      continue
100   continue
      vol=abs(vol)
      return
      end
