#!/usr/bin/env python

from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms

bulk = ListOfAtoms([Atom('Si', (0,    0,     0)),
                    Atom('Si', (0.25, 0.25, 0.25))])

#Use experimental lattice constant
a0 = 5.43
b = a0/2.
bulk.SetUnitCell([(0, b, b),
                  (b, 0, b),
                  (b, b, 0)])

calc = Dacapo(kpts=(8,8,8),           # set the k-points Monkhorst-Pack
              planewavecutoff=340,    # planewavecutoff in eV
              densitycutoff=500,      # density cutoff in eV
              nbands=12,              # set the number of electronic bands
              usesymm=True,           # use symmetry to reduce the k-point set
              out='Si-diamond.nc',    # define the out netcdf file
              txtout='Si-diamond.txt')# define the out ASCII file


calc.SetElectronicTemperature(0.1)
calc.StayAliveOff()


bulk.SetCalculator(calc)

energy = calc.GetPotentialEnergy()
