from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms


a = 2.87
bulk = ListOfAtoms([Atom('Fe', (0,   0,   0),   magmom=0.0),
                    Atom('Fe', (a/2, a/2, a/2), magmom=0.0)],
                   cell=(a, a, a))

calc = Dacapo(spinpol=True,
              kpts=(8, 8, 8),
              planewavecutoff=300,
              densitycutoff=500,
              nbands=17,
              usesymm=True,
              out='non.nc',
              txtout='non.txt')

bulk.SetCalculator(calc)

print bulk.GetPotentialEnergy()
