from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms

bulk = ListOfAtoms([Atom('Al', (0,    0,     0))] )
a0 = 4.05
b = a0/2.
bulk.SetUnitCell([(0, b, b),
                  (b, 0, b),
                  (b, b, 0)])

calc = Dacapo(kpts=(10,10,10),           # set the k-points Monkhorst-Pack
              planewavecutoff=340,       # planewavecutoff in eV
              nbands=8,                  # set the number of electronic bands
              usesymm=True,              # use symmetry to reduce the k-point set
              out='Al-fcc.nc',           # define the out netcdf file
              txtout='Al-fcc.txt')

calc.StayAliveOff()
calc.SetDensityCutoff(500)

bulk.SetCalculator(calc)

energy = calc.GetPotentialEnergy()
