#!/usr/bin/env python
from glob import glob
from os.path import join, basename, split
from distutils.dep_util import newer

from ASE.Utilities.BuildCAMPWebPages import Builder
import Color


class ASEBuilder(Builder):
    def Hook(self, dir, files):
        update = False
        if dir == './manual':
            reST = join(dir, 'manual.html')
            for f in files:
                if f.endswith('.txt') and newer(join(dir, f), reST):
                    update = True
                    break
            del files[:]
            files.append('manual.txt')
            
        return update

corner = """\
<a href="HOME/index.html">
  <img src="HOME/dacapo.gif" align="top" width="150"
       height="55" alt="[ASE]" border="0"/>
</a>"""


top = [('Dacapo introduction', 'intro.html'),
       ('documentation', 'documentation.html'),
       ('manual', 'manual/manual.html'),
       ('examples', 'examples/examples.html'),
       ('tutorials', 'tut/tutorials.html'),
       ('faq', 'faq.html')]

side = [('download', 'download.html'),
        ('mailing lists', 'lists.html'),
        ('publications', 'publications.html'),
        ('quick ref','Essential.html'),
        ('pseudo pot','pseudopotentials.html'),
        ('api', '../epydoc/Dacapo/index.html')]


figures = ["""\
           <a href="http://www.fysik.dtu.dk">
             <img src="HOME/../../images/template/logo-sml.gif"
                  align="top" width="125"
                  alt="[CAMP]" border="0"/>
           </a>""",
           """\
           <a href="http://www.fysik.dtu.dk/CAMPOS/ASE">
             <img src="HOME/../ASE/ASE-powered1.gif" align="top"
                  width="55"
                  height="22" alt="[ASE Powered]" border="0"/>
           </a>""",
           """\
           <a href="http://validator.w3.org/check/referer">
             <img src="http://www.w3.org/Icons/valid-xhtml10"
                  alt="Valid XHTML 1.0!" height="31" width="88"
                  border="0"/>
           </a>"""]

builder = ASEBuilder(corner, top, side, figures)
builder.Build()

for f in glob(join('..', 'Dacapo', 'Examples', '*.py')):
    target = join('examples', basename(f)[:-2] + 'html')
    if newer(f, target):
        print 'Coloring:', f, '->', target
        Color.Parser(f, basename(f), file(target, 'w')).format(None, None)

