""" testing if atoms can be removed from loa """

import os
from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms

if os.path.isfile('O2_in_a_box.nc'):

     # start calculator from file
     atoms = Dacapo.ReadAtoms(filename='O2_in_a_box.nc')
     calc = atoms.GetCalculator()

else: 
     atoms = ListOfAtoms([Atom('O', (0, 0, 0),magmom=1.0),
                     Atom('O', (1.1, 0, 0),magmom=1.0)],
                     cell=(4, 4, 4), periodic=1)

     calc = Dacapo(planewavecutoff=300,    # in eV
                   densitycutoff = 500,
	      nbands=10,              # 5 extra empty bands
              spinpol = True, 
              usesymm = True,
	      out='O2_in_a_box.nc', 
              txtout='O2_in_a_box.txt')

     atoms.SetCalculator(calc) 


mol_energy = atoms.GetPotentialEnergy()
print 'molecular O2 energy ',mol_energy 

# remove the O atom 
del atoms[1:]
calc.SetTxtFile('O_in_a_box.txt')
calc.SetNetCDFFile('O_in_a_box.nc')
atomic_energy = atoms.GetPotentialEnergy()
print 'atomic O energy ',atomic_energy 

print 'binding energy ',mol_energy -2*atomic_energy




