# Copyright (C) 2003  CAMP
# Please see the accompanying LICENSE file for further information.

""" class for defining the dacap oexecutable 
"""

__docformat__ = 'reStructuredText'

import os

class JobType:
	"""Class for jobtypes
	An instance is created by:

	'>>> a=JobType(description=' *description ',executable=' *runstring* ')'

	where description is a string (e.g. "Parallel on IBM") and executable
	is the necessary shell commandline (e.g "dacapo.run").
"""
	
	def __init__(self,description="",executable="dacapo.run"):
            self._description_=description
            self.SetExecutable(executable) 
	
	def __str__(self):
            return self._description_

        def SetExecutable(self,executable): 
	    self.executable = executable

	def GetExecutable(self):
            return self.executable

        def GetAsciiFile(self,ascii):
            return ascii

        def SetScratch(self,scratchdir):
	    self.scratchdir = scratchdir
    
        def GetScratch(self,scratch):
            import getpass

            if scratch is not None:
		return scratch

	    if hasattr(self,'scratchdir'): 
		    return self.scratchdir
	    
	    #find a suitable default scratchdir (should be writeable!) 
            username=getpass.getuser()

	    if os.access("/scratch/"+username,os.W_OK):
		    return "/scratch/"+username
	    elif os.access("/scratch/",os.W_OK):
		    return "/scratch/"
	    else:
		    if os.access(os.curdir,os.W_OK):
			    return os.curdir #if no /scratch use curdir
		    else:
			    raise IOError,"No suitable scratch directory and no write access to current dir"
		    

	def GetInFile(self,infile):
            if infile==None:
                import tempfile
                tempfile.tempdir=os.curdir
                return tempfile.mktemp()
            else:
	        return infile

	def GetScratchInFile(self,scratch):
	    import tempfile
	    tempfile.tempdir=self.GetScratch(scratch)
	    return tempfile.mktemp()
            
        def GetOutFile(self,outfile):
            return outfile


Default=JobType(description="Standard Dacapo Job")

#define obsolete jobtype for backwardcompatibilty

Serial=JobType(description="Serial job")

Parallel=JobType(description="Parallel job")

JobTypes={"default":Default,"Default":Default,"DEFAULT":Default,Default:Default,
	"serial":Serial,"Serial":Serial,"SERIAL":Serial,"seriel":Serial,"Seriel":Serial,"SERIEL":Serial,
	"parallel":Parallel,"Parallel":Parallel,"PARALLEL":Parallel,Serial:Serial,Parallel:Parallel,1:Serial,2:Parallel}

