#!/usr/bin/env python

# Copyright (C) 2003  CAMP
# Please see the accompanying LICENSE file for further information.

from distutils.core import setup
from distutils.dep_util import newer
from glob import glob
from os.path import join

import os
import sys


long_description = """\
Dacapo is a python package implementing a CamposASE2 Calculator 
interface for the dacapo total energy program."""


if sys.version_info < (2, 2, 1, 'final', 0):
    raise SystemExit, 'Python 2.2.2 or later is required!'


# Building the documentation:
if sys.argv[1] == 'build_doc':
    os.system('cd doc; python Build.py')
    raise SystemExit

# Build the API:
if sys.argv[1] == 'build_api':
    os.system('cd doc; python Epydoc.py')
    raise SystemExit

packages = ['Dacapo', 
            'Dacapo/Tests',
            'Dacapo/Examples']

scripts = glob(join('Dacapo', 'Tools', '[a-z]*'))

setup(name = 'Dacapo',
      version='0.9.4',
      description='ASE interface to Dacapo calculator',
      url='http://www.fysik.dtu.dk',
      maintainer='camp',
      maintainer_email='camp@fysik.dtu.dk',
      license='...',
      platforms=['linux'],
      packages=packages,
      scripts=scripts,
      long_description=long_description)


