#!/usr/bin/env python

from math import sqrt

import Numeric as num

from Dacapo import Dacapo
from ASE.Filters.Subset import Subset
from ASE.Filters.NudgedElasticBand import NudgedElasticBand
from ASE.Dynamics.AdaptiveNudgedElasticBand import AdaptiveNudgedElasticBand
from ASE.Dynamics.QuasiNewton import QuasiNewton
from ASE.Trajectories.NetCDFTrajectory import NetCDFTrajectory
from ASE import Atom,ListOfAtoms


initial = Dacapo.ReadAtoms('initial.nc')
final = Dacapo.ReadAtoms('final.nc')
print 'initial state energy             : ',initial.GetPotentialEnergy()
print 'final state energy               : ',final.GetPotentialEnergy()

mask=[a.GetTag()==1 for a in initial]

atomslist = [initial]
configs   = [Subset(atomslist[0], mask=mask)]
for n in range(3): 
    atoms = Dacapo.ReadAtoms('initial.nc') 
    atomslist.append(atoms)
    configs.append(Subset(atoms, mask=mask))

configs.append(Subset(final, mask=mask))
atomslist.append(final)

# setup each calculator
for n in range(len(atomslist)): 
    calc = atomslist[n].GetCalculator() 
    calc.StayAliveOff()
    calc.SetTxtFile('out.'+str(n)+'.txt') 
    calc.SetNetCDFFile('out.'+str(n)+'.nc') 


band = NudgedElasticBand(configs)
band.SetInterpolatedPositions()

aneb = AdaptiveNudgedElasticBand(configs,prefix='al100')
aneb.Converge()

