#!/usr/bin/env python

# getocc.py -b 148 -l 6 tio233x1owa/tio2s33x1owa.nc
# tio2s33x1owa.nc    0.076   0.96  0.94  0.89  0.77  0.00  0.00 
#                            0.93  0.80  0.52  0.42  0.00  0.00 
#                            0.96  0.94  0.89  0.78  0.00  0.00 
#                            0.92  0.81  0.49  0.46  0.00  0.00 

import os,sys
from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms
from ASE.Filters import Subset
from ASE.Dynamics import MDMin
from ASE.Dynamics import ConjugateGradient
from ASE.Dynamics.LineMinimizers.LM1 import LM1
import Numeric as num
from math import sqrt
from getopt import getopt
import os.path
from Scientific.IO.NetCDF import NetCDFFile #Help from Mikkel Strange

try: opts, files = getopt(sys.argv[1:], "b:l:")
except GetoptError: print "Options!"; sys.exit(2)
if not files: print "No files! Exiting."; sys.exit()

# Defaults
begin=1
nlen=1
for o, a in opts:
    if o in ('-b', '--begin'): begin=int(a)
    if o in ('-l', '--begin'): nlen=int(a)
    

for onefile in files:
    name=os.path.basename(onefile)#[:-3]
    try:
        ncfile = NetCDFFile(onefile)
        dimensions=ncfile.dimensions
    except:
        print 'problem trying to open file'
        break
    try:
        nkpmax=dimensions['number_IBZ_kpoints']
        nspmax=dimensions['number_of_spin']
        atoms = Dacapo.ReadAtoms(onefile)
        calc=atoms.GetCalculator()
    except:
        print 'Not much to read in ncfile'
        sys.exit()

    #evaluate the residual force
    #any atom with a non-zero tag is considered dynamic
    to=0
    for i in range(0,len(atoms)):
        if atoms[i].GetTag() != 0:
            to+=num.power(atoms.GetCartesianForces()[i][0],2)+num.power(atoms.GetCartesianForces()[i][1],2)+num.power(atoms.GetCartesianForces()[i][2],2)
    occ=calc.GetNetCDFEntry('OccupationNumbers')[-1]

    #now prepare for some nicely formatted output
    first_line=True
    #setup a string with nlen formatted-print-float-declarations
    s0='%5.2f '
    s=''
    for i in range(0,nlen):
        s=s+s0
    for nkp in range(0,nkpmax):
        for nsp in range(0,nspmax):
            if first_line:
                print '%16s %8.3f ' %(name,sqrt(to)),s %(tuple(occ[nkp,nsp][begin:begin+nlen]))
                first_line=False
            else:
                print '%16s %8s ' %('',''),s %(tuple(occ[nkp,nsp][begin:begin+nlen]))



