"""CO dimer in a box."""

import os
from Dacapo import Dacapo
from ASE import Atom, ListOfAtoms

atoms = ListOfAtoms([Atom('C', (2, 2, 2)),
                     Atom('O', (3.1, 2, 2))],
                     cell=(4, 4, 4), periodic=1)

calc = Dacapo(planewavecutoff=300,    # in eV
	      nbands=10,              # 5 extra empty bands
	      out='CO_in_a_box.nc', 
              txtout='CO_in_a_box.txt')

atoms.SetCalculator(calc) 

energy = atoms.GetPotentialEnergy()

