"""
A simple test script.

Runs all scripts in the Tests and Examples directories.
"""


import glob, sys, os
from ASE.Utilities.Tests import ReportTest


class DownTheDrain:
    def write(self, text): pass
    def fileno(self): return 1

    
if __name__ == '__main__':

    # get location of ASE and Dacapo 
    import ASE,Dacapo
    print 'ASE location   : ',ASE.__file__
    print 'Dacapo location: ',Dacapo.__file__
    # Make a list of tests to do:
    tests = glob.glob('*.py')
    tests.remove('test.py')
    tests.extend(glob.glob('../Examples/*.py'))
    tests.remove('../Examples/setupham.py')
    tests.remove('../Examples/neb.py') # neb.py must run before aneb.py
    tests.sort()
    tests.insert(0, '../Examples/neb.py')

    # Do tests:
    for test in tests:
        print >> sys.stderr, 'Running', test
        error = os.system('python ' + test) 

	ReportTest("Running test "+test,error,0,0)

    ReportTest.Summary()

