""" K-points and planewave cutoff convergence tests. 
    Al used as example.
"""
import sys
from Dacapo import Dacapo
from ASE import Atom,ListOfAtoms
from ASE.Visualization.gnuplot import gnuplot
import os

bulk = ListOfAtoms([Atom('Al', (0,    0,     0))] )
a0_fcc = 4.05
b = a0_fcc/2.
bulk.SetUnitCell([(0, b, b), (b, 0, b), (b, b, 0)])

# remove output files
calc = Dacapo(kpts=(1,1,1),              # set the k-points Monkhorst-Pack 
              planewavecutoff=200,       # planewavecutoff in eV
              nbands=6,                  # set the number of electronic bands
              usesymm=True,              # use symmetry to reduce the k-point set
              out='Al-fcc.nc',           # define the out netcdf file
              txtout='Al-fcc.txt',       # define the ascii out file
              infile = 'in.nc' )      

calc.StayAliveOff()
calc.SetDensityCutoff(400)

bulk.SetCalculator(calc)

energy = calc.GetPotentialEnergy()

# make a plot of the convergence with respect to k-points
energies = [(1,energy)]
for n in [2,4,6]: 

    calc.SetBZKPoints((n,n,n))
    energy = calc.GetPotentialEnergy() 
    energies.append((n,energy))

kpointplot = gnuplot(energies) 


# make a plot of the convergence with respect to planewavecutoff
n = 2
calc.SetBZKPoints((n,n,n))
energies = []
for planewavecutoff in [75,100,150,200,250,300]:

    calc.SetPlaneWaveCutoff(planewavecutoff)
    energy = calc.GetPotentialEnergy()
    energies.append((planewavecutoff,energy))

pwplot = gnuplot(energies)

