#!/usr/bin/env python
from Dacapo import Dacapo
from ASE import Atom,ListOfAtoms

# setup the static Al slab 
alslab =  ListOfAtoms([Atom('Na',(.33,.16,-.1)),
                       Atom('Al',(0, 0, 0)),
                       Atom('Al',(0, 0.5, 0)),
                       Atom('Al',(0.5, 0, 0)),
                       Atom('Al',(0.5, 0.5, 0)),
                       Atom('Al',(0.3333333, 0.166666667, 0.125)),
                       Atom('Al',(0.3333333, 0.666666667, 0.125)),
                       Atom('Al',(0.8333333, 0.166666667, 0.125)),
                       Atom('Al',(0.8333333, 0.666666667, 0.125))])

# translating the atoms to the center of the cell makes the potential plots look nicer
for atom in alslab:
    atom.SetCartesianPosition(atom.GetCartesianPosition() + (0,0,0.5))

unitcell = [[5.72756492761103, 0, 0], 
            [-2.86378246380552, 4.96021672913593, 0], 
            [0,0,18.7061487217439]]

alslab.SetUnitCell(unitcell) 

calc = Dacapo(planewavecutoff = 340,
              nbands = 30) 
calc.DipoleCorrection()
calc.SetNetCDFFile('Alslab_Na_DIP.nc') 
alslab.SetCalculator(calc)

energy = alslab.GetPotentialEnergy() 

