# Copyright (C) 2003  CAMP
# Please see the accompanying LICENSE file for further information.

""" Default pseudopotential paths are defined here
"""

__docformat__ = 'reStructuredText'

defaultpseudopotentials = [ ' ', #  None
'ch_e9g4.pseudo', #  H
' ', #  He
'Li_us_cc.pseudo', #  Li
' ', #  Be
' ', #  B
'C_us_gga.pseudo', #  C
'N_us.pseudo', #  N
'co_gef_e13_gga.pseudo', #  O
'F_pw91_us_7.3.4.pseudo', #  F
' ', #  Ne
'Na_tm_lda_cc.pseudo', #  Na
'mg_us_gga.pseudo', #  Mg
'Al_us_gga_org.pseudo', #  Al
'csi_e8ag4.pseudo', #  Si
'P_us.pseudo', #  P
'S_tm.pseudo', #  S
'Cl_us_gga.pseudo', #  Cl
' ', #  Ar
'k_us_gga.pseudo', #  K
'Ca_us_cc_pw91.pseudo', #  Ca
'Sc_us_cc_pw91.pseudo', #  Sc
'ti_us_gga.pseudo', #  Ti
'V_us_pw91_13elec.pseudo', #  V
'Cr_us_pw91_14elec.pseudo', #  Cr
'Mn_us_gga.pseudo', #  Mn
'Fe_us_gga_d2.1.8.pseudo', #  Fe
'Co_us_gga.pseudo', #  Co
'Ni_us_gga.pseudo', #  Ni
'Cu_us_gga.pseudo', #  Cu
'zn_us_gga.pseudo', #  Zn
'ga_pw91_us_13elec.pseudo', #  Ga
'ge_pw91_us_14elec.pseudo', #  Ge
'as_pw91_us_15elec.pseudo', #  As
' ', #  Se
'Br_us_gga.pseudo', #  Br
'Kr_us_gga.pseudo', #  Kr
' ', #  Rb
'Sr_us_cc_pw91.pseudo', #  Sr
'Y_us_cc_pw91.pseudo', #  Y
'Zr_us_gga.pseudo', #  Zr
'Nb_us_pw91_13elec.pseudo', #  Nb
'Mo_us.pseudo', #  Mo
' ', #  Tc
'Ru_us_gga.pseudo', #  Ru
'Rh_us_gga_fl.pseudo', #  Rh
'pd_us_gga.pseudo', #  Pd
'ag_us.pseudo', #  Ag
'Cd_us_gga.pseudo', #  Cd
' ', #  In
'sn_us_f.pseudo', #  Sn
'sb_us_gga.pseudo', #  Sb
'te_tm.pseudo', #  Te
'I_us_pw91.pseudo', #  I
'Xe_us_gga.pseudo', #  Xe
'cs_tm_7el.pseudo', #  Cs
'Ba_us_cc_pw91.pseudo', #  Ba
'La_us_cc_pw91.pseudo', #  La
' ', #  Ce
' ', #  Pr
' ', #  Nd
' ', #  Pm
' ', #  Sm
' ', #  Eu
' ', #  Gd
' ', #  Tb
' ', #  Dy
' ', #  Ho
' ', #  Er
' ', #  Tm
' ', #  Yb
' ', #  Lu
' ', #  Hf
'Ta_us_pw91_13elec.pseudo', #  Ta
'W_us_pw91_6elec.pseudo', #  W
're_us_gga_7elec.pseudo', #  Re
'os_us_gga_7elec_7.3.4.pseudo', #  Os
'ir_us_gga_flocal.pseudo', #  Ir
'pt_us_gga.pseudo', #  Pt
'Au_us_gga.pseudo', #  Au
'Hg_us_pw91.pseudo', #  Hg
' ', #  Tl
' ', #  Pb
'Bi_us_gga.pseudo', #  Bi
' ', #  Po
' ', #  At
' ', #  Rn
' ', #  Fr
' ', #  Ra
' ', #  Ac
' ', #  Th
' ', #  Pa
' ', #  U
' ', #  Np
' ', #  Pu
' ', #  Am
' ', #  Cm
' ', #  Bk
' ', #  Cf
' ', #  Es
' ', #  Fm
' ', #  Md
' ', #  No
' ', #  Lr
' ', #  Unq
' ', #  Unp
' ' ]

def GetValenceElectrons(psp):
    """This reads the number of valence electrons from the pseudopotential.
    psp is a string with the pseudopotential file name in it."""
    import os
 
    dacapopath = os.environ['DACAPOPATH']
    from struct import unpack
    try: 
	f = open(os.path.join(dacapopath,psp))
	# read past version numbers and text information
	buf = f.read(64)
	# read number valence electrons
	buf = f.read(8)
	fmt = ">d"
	nvalence = unpack(fmt,buf)[0]
	return float(nvalence)
    except:
	return None

	
