#!/usr/bin/env python

"""Calculate the vibrational modes of a CO molecule."""
from Dacapo import Dacapo
from ASE.Utilities.VibrationalCalculation import *

loa=Dacapo.ReadAtoms('CO_relaxed_in_a_box.nc')
loa.GetCalculator().SetNetCDFFile('temp.nc')

vib=VibrationalCalculation(filetoken='CO_vib',
                           atoms=loa,
			   freeatoms=[0,1],
                           displacements=[0.05] * 2,
			   method=1)

vib.RunCalculations()

vib.PrintFrequencies()

print 'Zero-point energy = %1.2f eV' % vib.GetZeroPointEnergy()

