#!/usr/bin/env python
from Dacapo import Dacapo
import Gnuplot,Numeric

atoms = Dacapo.ReadAtoms('Alslab_Na_DIP.nc')

calc = atoms.GetCalculator()

### should the calculator method return this grid?
from ASE.Utilities.Grid import Grid
from ASE.Utilities import Vector,VectorSpaces
pot = Grid(calc.GetElectrostaticPotential(),
           space=VectorSpaces.BravaisLattice(atoms.GetUnitCell()))

avg_pot = pot.GetAverageAlongAxis(2)

E_f=calc.GetFermiLevel()

# define the z-axis for plotting, in real units
Number_of_points=len(avg_pot)
end_point=Vector.Vector(pot.GetSpace().GetBasis()[2]).Length()
step=end_point/float(Number_of_points-1)
axis=Numeric.arange(0,end_point,step)

###create a line with value of the fermi energy
E_f_data=[E_f]*len(avg_pot)

gplot=Gnuplot.Gnuplot(persist=1)
gplot.xlabel('axis')
gplot.ylabel('Electrostatic Potential')
gplot.title('workfunction plot')
d1=Gnuplot.Data(zip(axis,avg_pot),title="average potential",with='lines')
d2=Gnuplot.Data(zip(axis,E_f_data),title="Fermi Level",with='lines')
gplot.plot(d1,d2)

gplot('set terminal png')
gplot('set output "dip_z=0.png"')
gplot.replot()

### print data for reading
for tuple in zip(axis,avg_pot-E_f): print tuple
